/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl;

import akka.annotation.InternalApi;
import akka.stream.Attributes;
import akka.stream.RateExceededException;
import akka.stream.ThrottleMode;
import akka.stream.ThrottleMode$Enforcing$;
import akka.stream.impl.Throttle$;
import akka.stream.impl.Throttle$TimerKey$;
import akka.stream.impl.fusing.GraphStages;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.NanoTimeTokenBucket;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dvA\u0002\u0012$\u0011\u00039\u0013F\u0002\u0004,G!\u0005q\u0005\f\u0005\u0006g\u0005!\t!\u000e\u0005\bm\u0005\u0011\r\u0011\"\u00028\u0011\u0019Q\u0014\u0001)A\u0007q\u001d)1(\u0001EEy\u0019)a(\u0001EE\u007f!)1G\u0002C\u0001\r\"9qIBA\u0001\n\u0003B\u0005bB)\u0007\u0003\u0003%\tA\u0015\u0005\b-\u001a\t\t\u0011\"\u0001X\u0011\u001dif!!A\u0005ByCq!\u001a\u0004\u0002\u0002\u0013\u0005a\rC\u0004l\r\u0005\u0005I\u0011\t7\t\u000f54\u0011\u0011!C!]\"9qNBA\u0001\n\u0013\u0001h!B\u0016$\u0001\u001db\b\"CA\u001b!\t\u0015\r\u0011\"\u0001S\u0011%\t9\u0004\u0005B\u0001B\u0003%1\u000b\u0003\u0006\u0002:A\u0011)\u0019!C\u0001\u0003wA!\"!\u0014\u0011\u0005\u0003\u0005\u000b\u0011BA\u001f\u0011%\ty\u0005\u0005BC\u0002\u0013\u0005!\u000bC\u0005\u0002RA\u0011\t\u0011)A\u0005'\"Q\u00111\u000b\t\u0003\u0006\u0004%\t!!\u0016\t\u0015\u0005u\u0003C!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002`A\u0011)\u0019!C\u0001\u0003CB!\"a\u001b\u0011\u0005\u0003\u0005\u000b\u0011BA2\u0011\u0019\u0019\u0004\u0003\"\u0001\u0002n!I\u00111\u0010\tC\u0002\u0013%\u0011Q\u0010\u0005\t\u0003\u000b\u0003\u0002\u0015!\u0003\u0002\u0000!I\u0011q\u0011\tC\u0002\u0013\u0005\u0011Q\u0010\u0005\t\u0003\u0013\u0003\u0002\u0015!\u0003\u0002\u0000!9\u00111\u0012\t\u0005B\u00055\u0005\"B7\u0011\t\u0003r\u0017\u0001\u0003+ie>$H\u000f\\3\u000b\u0005\u0011*\u0013\u0001B5na2T!AJ\u0014\u0002\rM$(/Z1n\u0015\u0005A\u0013\u0001B1lW\u0006\u0004\"AK\u0001\u000e\u0003\r\u0012\u0001\u0002\u00165s_R$H.Z\n\u0003\u00035\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003%\nQ#Q;u_6\fG/[2NCbLW.^7CkJ\u001cH/F\u00019\u001f\u0005IT$A\u0000\u0002-\u0005+Ho\\7bi&\u001cW*\u0019=j[Vl')\u001e:ti\u0002\n\u0001\u0002V5nKJ\\U-\u001f\t\u0003{\u0019i\u0011!\u0001\u0002\t)&lWM]&fsN!a!\f!D!\tq\u0013)\u0003\u0002C_\t9\u0001K]8ek\u000e$\bC\u0001\u0018E\u0013\t)uF\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001=\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t\u0011\n\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006!A.\u00198h\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005\u0019\u0006C\u0001\u0018U\u0013\t)vFA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002Y7B\u0011a&W\u0005\u00035>\u00121!\u00118z\u0011\u001da&\"!AA\u0002M\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014X#A0\u0011\u0007\u0001\u001c\u0007,D\u0001b\u0015\t\u0011w&\u0001\u0006d_2dWm\u0019;j_:L!\u0001Z1\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0003O*\u0004\"A\f5\n\u0005%|#a\u0002\"p_2,\u0017M\u001c\u0005\b92\t\t\u00111\u0001Y\u0003!A\u0017m\u001d5D_\u0012,G#A*\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!S\u0001\fe\u0016\fGMU3t_24X\rF\u0001r!\tQ%/\u0003\u0002t\u0017\n1qJ\u00196fGRD#!A;\u0011\u0005YLX\"A<\u000b\u0005a<\u0013AC1o]>$\u0018\r^5p]&\u0011!p\u001e\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e\u000b\u0002\u0001kV\u0019Q0!\u000b\u0014\u0005Aq\b#B@\u0002 \u0005\u0015b\u0002BA\u0001\u00033qA!a\u0001\u0002\u00169!\u0011QAA\n\u001d\u0011\t9!!\u0005\u000f\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u00045\u0003\u0019a$o\\8u}%\t\u0001&\u0003\u0002'O%\u0011A%J\u0005\u0004\u0003/\u0019\u0013A\u00024vg&tw-\u0003\u0003\u0002\u001c\u0005u\u0011aC$sCBD7\u000b^1hKNT1!a\u0006$\u0013\u0011\t\t#a\t\u0003-MKW\u000e\u001d7f\u0019&tW-\u0019:He\u0006\u0004\bn\u0015;bO\u0016TA!a\u0007\u0002\u001eA!\u0011qEA\u0015\u0019\u0001!q!a\u000b\u0011\u0005\u0004\tiCA\u0001U#\r\ty\u0003\u0017\t\u0004]\u0005E\u0012bAA\u001a_\t9aj\u001c;iS:<\u0017\u0001B2pgR\fQaY8ti\u0002\n1\u0001]3s+\t\ti\u0004\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0011\u0011,(/\u0019;j_:T1!a\u00120\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u0017\n\tE\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\tA,'\u000fI\u0001\r[\u0006D\u0018.\\;n\u0005V\u00148\u000f^\u0001\u000e[\u0006D\u0018.\\;n\u0005V\u00148\u000f\u001e\u0011\u0002\u001f\r|7\u000f^\"bY\u000e,H.\u0019;j_:,\"!a\u0016\u0011\r9\nI&!\nT\u0013\r\tYf\f\u0002\n\rVt7\r^5p]F\n\u0001cY8ti\u000e\u000bGnY;mCRLwN\u001c\u0011\u0002\t5|G-Z\u000b\u0003\u0003G\u0002B!!\u001a\u0002h5\tQ%C\u0002\u0002j\u0015\u0012A\u0002\u00165s_R$H.Z'pI\u0016\fQ!\\8eK\u0002\"B\"a\u001c\u0002r\u0005M\u0014QOA<\u0003s\u0002BA\u000b\t\u0002&!1\u0011QG\u000eA\u0002MCq!!\u000f\u001c\u0001\u0004\ti\u0004\u0003\u0004\u0002Pm\u0001\ra\u0015\u0005\b\u0003'Z\u0002\u0019AA,\u0011\u001d\tyf\u0007a\u0001\u0003G\n!C\\1o_N\u0014U\r^<fK:$vn[3ogV\u0011\u0011q\u0010\t\u0004]\u0005\u0005\u0015bAAB_\t!Aj\u001c8h\u0003Mq\u0017M\\8t\u0005\u0016$x/Z3o)>\\WM\\:!\u0003U)gMZ3di&4X-T1yS6,XNQ;sgR\fa#\u001a4gK\u000e$\u0018N^3NCbLW.^7CkJ\u001cH\u000fI\u0001\fGJ,\u0017\r^3M_\u001eL7\r\u0006\u0003\u0002\u0010\u0006m\u0005\u0003BAI\u0003/k!!a%\u000b\u0007\u0005UU%A\u0003ti\u0006<W-\u0003\u0003\u0002\u001a\u0006M%aD$sCBD7\u000b^1hK2{w-[2\t\u000f\u0005u\u0005\u00051\u0001\u0002 \u0006\u0019\u0012N\u001c5fe&$X\rZ!uiJL'-\u001e;fgB!\u0011QMAQ\u0013\r\t\u0019+\n\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\bF\u0001\tv\u0001")
@InternalApi
public class Throttle<T>
extends GraphStages.SimpleLinearGraphStage<T> {
    private final int cost;
    private final FiniteDuration per;
    private final int maximumBurst;
    private final Function1<T, Object> costCalculation;
    private final ThrottleMode mode;
    private final long akka$stream$impl$Throttle$$nanosBetweenTokens;
    private final long effectiveMaximumBurst;

    public static int AutomaticMaximumBurst() {
        return Throttle$.MODULE$.AutomaticMaximumBurst();
    }

    public int cost() {
        return this.cost;
    }

    public FiniteDuration per() {
        return this.per;
    }

    public int maximumBurst() {
        return this.maximumBurst;
    }

    public Function1<T, Object> costCalculation() {
        return this.costCalculation;
    }

    public ThrottleMode mode() {
        return this.mode;
    }

    public long akka$stream$impl$Throttle$$nanosBetweenTokens() {
        return this.akka$stream$impl$Throttle$$nanosBetweenTokens;
    }

    public long effectiveMaximumBurst() {
        return this.effectiveMaximumBurst;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private final NanoTimeTokenBucket tokenBucket;
            private T currentElement;
            private final /* synthetic */ Throttle $outer;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$(this, cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$(this, ex);
            }

            private NanoTimeTokenBucket tokenBucket() {
                return this.tokenBucket;
            }

            private T currentElement() {
                return this.currentElement;
            }

            private void currentElement_$eq(T x$1) {
                this.currentElement = x$1;
            }

            public void preStart() {
                this.tokenBucket().init();
            }

            public void onUpstreamFinish() {
                if (!this.isAvailable(this.$outer.out()) || !this.isTimerActive(Throttle$TimerKey$.MODULE$)) {
                    this.completeStage();
                    return;
                }
            }

            public void onPush() {
                T elem = this.grab(this.$outer.in());
                int cost = BoxesRunTime.unboxToInt((Object)this.$outer.costCalculation().apply(elem));
                long delayNanos = this.tokenBucket().offer((long)cost);
                if (delayNanos == 0L) {
                    this.push(this.$outer.out(), elem);
                    return;
                }
                if (this.$outer.mode() == ThrottleMode$Enforcing$.MODULE$) {
                    this.failStage(new RateExceededException("Maximum throttle throughput exceeded."));
                    return;
                }
                this.currentElement_$eq(elem);
                this.scheduleOnce((Object)Throttle$TimerKey$.MODULE$, new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(delayNanos)).nanos());
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            public void onTimer(Object key) {
                this.push(this.$outer.out(), this.currentElement());
                this.currentElement_$eq(null);
                if (this.isClosed(this.$outer.in())) {
                    this.completeStage();
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$(this);
                OutHandler.$init$(this);
                this.tokenBucket = new NanoTimeTokenBucket($outer.effectiveMaximumBurst(), $outer.akka$stream$impl$Throttle$$nanosBetweenTokens());
                this.setHandlers($outer.in(), $outer.out(), this);
            }
        };
    }

    public String toString() {
        return "Throttle";
    }

    public Throttle(int cost, FiniteDuration per, int maximumBurst, Function1<T, Object> costCalculation, ThrottleMode mode) {
        this.cost = cost;
        this.per = per;
        this.maximumBurst = maximumBurst;
        this.costCalculation = costCalculation;
        this.mode = mode;
        Predef$.MODULE$.require(cost > 0, (Function0 & Serializable & scala.Serializable)() -> "cost must be > 0");
        Predef$.MODULE$.require(per.toNanos() > 0L, (Function0 & Serializable & scala.Serializable)() -> "per time must be > 0");
        Predef$.MODULE$.require(per.toNanos() >= (long)cost, (Function0 & Serializable & scala.Serializable)() -> "Rates larger than 1 unit / nanosecond are not supported");
        this.akka$stream$impl$Throttle$$nanosBetweenTokens = per.toNanos() / (long)cost;
        this.effectiveMaximumBurst = maximumBurst == -1 ? package$.MODULE$.max(1L, 100000000L / this.akka$stream$impl$Throttle$$nanosBetweenTokens()) : (long)maximumBurst;
        ThrottleMode throttleMode = mode;
        ThrottleMode$Enforcing$ throttleMode$Enforcing$ = ThrottleMode$Enforcing$.MODULE$;
        Predef$.MODULE$.require((throttleMode != null ? !throttleMode.equals(throttleMode$Enforcing$) : throttleMode$Enforcing$ != null) || this.effectiveMaximumBurst() >= 0L, (Function0 & Serializable & scala.Serializable)() -> "maximumBurst must be > 0 in Enforcing mode");
    }
}

