/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl;

import akka.annotation.InternalApi;
import akka.stream.impl.Buffer;
import akka.stream.impl.Buffer$;
import java.util.LinkedList;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!\u0002\u001c8\u0005mj\u0004\u0002C+\u0001\u0005\u000b\u0007I\u0011\u0001,\t\u0011i\u0003!\u0011!Q\u0001\n]CQa\u0017\u0001\u0005\u0002qCQa\u0018\u0001\u0005\u0002YCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ!\u001a\u0001\u0005\u0002\u0005DQA\u001a\u0001\u0005\u0002\u0005DQa\u001a\u0001\u0005\u0002!DQA\u001c\u0001\u0005\u0002=DQ\u0001\u001d\u0001\u0005\u0002=DQ!\u001d\u0001\u0005\u0002IDQa\u001d\u0001\u0005\u0002IDQ\u0001\u001e\u0001\u0005\u0002IDq!\u001e\u0001A\u0002\u0013%a\u000fC\u0004x\u0001\u0001\u0007I\u0011\u0002=\t\rm\u0004\u0001\u0015)\u0003F\u000f!\t9a\u000eE\u0001w\u0005%aa\u0002\u001c8\u0011\u0003Y\u00141\u0002\u0005\u00077J!\t!!\u0004\u0007\r\u0005=!CBA\t\u0011!)FC!b\u0001\n\u00032\u0006\u0002\u0003.\u0015\u0005\u0003\u0005\u000b\u0011B,\t\u0015\u0005mAC!A!\u0002\u0013\ti\u0002\u0003\u0004\\)\u0011\u0005\u00111\u0005\u0005\n\u0003[!\"\u0019!C\u0005\u0003_A\u0001\"a\u000e\u0015A\u0003%\u0011\u0011\u0007\u0005\t\u0003s!\u0002\u0019!C\u0005-\"I\u00111\b\u000bA\u0002\u0013%\u0011Q\b\u0005\b\u0003\u0003\"\u0002\u0015)\u0003X\u0011!\t\u0019\u0005\u0006a\u0001\n\u00131\u0006\"CA#)\u0001\u0007I\u0011BA$\u0011\u001d\tY\u0005\u0006Q!\n]CQa\u0018\u000b\u0005BYCQ\u0001\u0019\u000b\u0005B\u0005DQ!\u001a\u000b\u0005B\u0005DQA\u001a\u000b\u0005B\u0005Daa\u001a\u000b\u0005B\u00055\u0003B\u00028\u0015\t\u0003\n\t\u0006\u0003\u0004q)\u0011\u0005\u0013\u0011\u000b\u0005\u0006cR!\tE\u001d\u0005\u0006gR!\tE\u001d\u0005\u0006iR!\tE\u001d\u0004\u0007\u0003'\u0012b!!\u0016\t\u0011U[#Q1A\u0005BYC\u0001BW\u0016\u0003\u0002\u0003\u0006Ia\u0016\u0005\u00077.\"\t!a\u001c\t\u000b}[C\u0011\t,\t\u000b\u0001\\C\u0011I1\t\u000b\u0019\\C\u0011I1\t\r\u001d\\C\u0011IA;\u0011\u0019q7\u0006\"\u0011\u0002z!)1o\u000bC!e\")Ao\u000bC!e\ni!i\\;oI\u0016$')\u001e4gKJT!\u0001O\u001d\u0002\t%l\u0007\u000f\u001c\u0006\u0003um\naa\u001d;sK\u0006l'\"\u0001\u001f\u0002\t\u0005\\7.Y\u000b\u0003}-\u001b2\u0001A F!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fMB\u0019aiR%\u000e\u0003]J!\u0001S\u001c\u0003\r\t+hMZ3s!\tQ5\n\u0004\u0001\u0005\u000b1\u0003!\u0019\u0001(\u0003\u0003Q\u001b\u0001!\u0005\u0002P%B\u0011\u0001\tU\u0005\u0003#\u0006\u0013qAT8uQ&tw\r\u0005\u0002A'&\u0011A+\u0011\u0002\u0004\u0003:L\u0018\u0001C2ba\u0006\u001c\u0017\u000e^=\u0016\u0003]\u0003\"\u0001\u0011-\n\u0005e\u000b%aA%oi\u0006I1-\u00199bG&$\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005us\u0006c\u0001$\u0001\u0013\")Qk\u0001a\u0001/\u0006!Qo]3e\u0003\u0019I7OR;mYV\t!\r\u0005\u0002AG&\u0011A-\u0011\u0002\b\u0005>|G.Z1o\u0003\u001dI7/R7qif\f\u0001B\\8o\u000b6\u0004H/_\u0001\bK:\fX/Z;f)\tIG\u000e\u0005\u0002AU&\u00111.\u0011\u0002\u0005+:LG\u000fC\u0003n\u0011\u0001\u0007\u0011*\u0001\u0003fY\u0016l\u0017a\u00023fcV,W/\u001a\u000b\u0002\u0013\u0006!\u0001/Z3l\u0003\u0015\u0019G.Z1s)\u0005I\u0017\u0001\u00033s_BDU-\u00193\u0002\u0011\u0011\u0014x\u000e\u001d+bS2\f\u0011!]\u000b\u0002\u000b\u0006)\u0011o\u0018\u0013fcR\u0011\u0011.\u001f\u0005\bu>\t\t\u00111\u0001F\u0003\rAH%M\u0001\u0003c\u0002B#\u0001A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\taO\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0003\u007f\nY\u0011J\u001c;fe:\fG.\u00119j\u00035\u0011u.\u001e8eK\u0012\u0014UO\u001a4feB\u0011aIE\n\u0003%}\"\"!!\u0003\u0003\u0015\u0019K\u00070\u001a3Rk\u0016,X-\u0006\u0003\u0002\u0014\u0005e1\u0003\u0002\u000b@\u0003+\u0001BAR$\u0002\u0018A\u0019!*!\u0007\u0005\u000b1#\"\u0019\u0001(\u0002\u0019M<\u0018\u000e^2i\u0005V4g-\u001a:\u0011\r\u0001\u000by\"!\u0006j\u0013\r\t\t#\u0011\u0002\n\rVt7\r^5p]F\"b!!\n\u0002*\u0005-\u0002#BA\u0014)\u0005]Q\"\u0001\n\t\u000bUC\u0002\u0019A,\t\u000f\u0005m\u0001\u00041\u0001\u0002\u001e\u0005)\u0011/^3vKV\u0011\u0011\u0011\u0007\t\u0005\u0001\u0006Mr(C\u0002\u00026\u0005\u0013Q!\u0011:sCf\fa!];fk\u0016\u0004\u0013\u0001\u00025fC\u0012\f\u0001\u0002[3bI~#S-\u001d\u000b\u0004S\u0006}\u0002b\u0002>\u001d\u0003\u0003\u0005\raV\u0001\u0006Q\u0016\fG\rI\u0001\u0005i\u0006LG.\u0001\u0005uC&dw\fJ3r)\rI\u0017\u0011\n\u0005\bu~\t\t\u00111\u0001X\u0003\u0015!\u0018-\u001b7!)\rI\u0017q\n\u0005\u0007[\u0016\u0002\r!a\u0006\u0015\u0005\u0005]!\u0001\u0004#z]\u0006l\u0017nY)vKV,W\u0003BA,\u0003W\u001aRaKA-\u0003[\u0002b!a\u0017\u0002f\u0005%TBAA/\u0015\u0011\ty&!\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003G\nAA[1wC&!\u0011qMA/\u0005)a\u0015N\\6fI2K7\u000f\u001e\t\u0004\u0015\u0006-D!\u0002',\u0005\u0004q\u0005\u0003\u0002$H\u0003S\"B!!\u001d\u0002tA)\u0011qE\u0016\u0002j!)QK\fa\u0001/R\u0019\u0011.a\u001e\t\r5\u0014\u0004\u0019AA5)\t\tI\u0007\u000b\u0002\u0013{\"\u0012\u0011# ")
@InternalApi
public final class BoundedBuffer<T>
implements Buffer<T> {
    private final int capacity;
    private Buffer<T> q;

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int used() {
        return this.q().used();
    }

    @Override
    public boolean isFull() {
        return this.q().isFull();
    }

    @Override
    public boolean isEmpty() {
        return this.q().isEmpty();
    }

    @Override
    public boolean nonEmpty() {
        return this.q().nonEmpty();
    }

    @Override
    public void enqueue(T elem) {
        this.q().enqueue(elem);
    }

    @Override
    public T dequeue() {
        return this.q().dequeue();
    }

    @Override
    public T peek() {
        return this.q().peek();
    }

    @Override
    public void clear() {
        this.q().clear();
    }

    @Override
    public void dropHead() {
        this.q().dropHead();
    }

    @Override
    public void dropTail() {
        this.q().dropTail();
    }

    private Buffer<T> q() {
        return this.q;
    }

    private void q_$eq(Buffer<T> x$1) {
        this.q = x$1;
    }

    public BoundedBuffer(int capacity) {
        this.capacity = capacity;
        this.q = new FixedQueue(capacity, (Function1 & java.io.Serializable & Serializable)newBuffer -> {
            this.q_$eq(newBuffer);
            return BoxedUnit.UNIT;
        });
    }

    private static final class DynamicQueue<T>
    extends LinkedList<T>
    implements Buffer<T> {
        private final int capacity;

        @Override
        public int capacity() {
            return this.capacity;
        }

        @Override
        public int used() {
            return this.size();
        }

        @Override
        public boolean isFull() {
            return this.size() == this.capacity();
        }

        @Override
        public boolean nonEmpty() {
            return !this.isEmpty();
        }

        @Override
        public void enqueue(T elem) {
            this.add(elem);
        }

        @Override
        public T dequeue() {
            return (T)this.remove();
        }

        @Override
        public void dropHead() {
            this.remove();
        }

        @Override
        public void dropTail() {
            this.removeLast();
        }

        public DynamicQueue(int capacity) {
            this.capacity = capacity;
        }
    }

    private static final class FixedQueue<T>
    implements Buffer<T> {
        private final int capacity;
        private final Function1<Buffer<T>, BoxedUnit> switchBuffer;
        private final Object[] queue;
        private int head;
        private int tail;

        @Override
        public int capacity() {
            return this.capacity;
        }

        private Object[] queue() {
            return this.queue;
        }

        private int head() {
            return this.head;
        }

        private void head_$eq(int x$1) {
            this.head = x$1;
        }

        private int tail() {
            return this.tail;
        }

        private void tail_$eq(int x$1) {
            this.tail = x$1;
        }

        @Override
        public int used() {
            return this.tail() - this.head();
        }

        @Override
        public boolean isFull() {
            return this.used() == this.capacity();
        }

        @Override
        public boolean isEmpty() {
            return this.tail() == this.head();
        }

        @Override
        public boolean nonEmpty() {
            return this.tail() != this.head();
        }

        @Override
        public void enqueue(T elem) {
            if (this.tail() - this.head() == Buffer$.MODULE$.FixedQueueSize()) {
                DynamicQueue<T> queue = new DynamicQueue<T>(this.capacity());
                while (this.nonEmpty()) {
                    queue.enqueue(this.dequeue());
                }
                this.switchBuffer.apply(queue);
                queue.enqueue(elem);
                return;
            }
            this.queue()[this.tail() & Buffer$.MODULE$.FixedQueueMask()] = elem;
            this.tail_$eq(this.tail() + 1);
        }

        @Override
        public T dequeue() {
            int pos = this.head() & Buffer$.MODULE$.FixedQueueMask();
            Object ret = this.queue()[pos];
            this.queue()[pos] = null;
            this.head_$eq(this.head() + 1);
            return (T)ret;
        }

        @Override
        public T peek() {
            if (this.tail() == this.head()) {
                return null;
            }
            return (T)this.queue()[this.head() & Buffer$.MODULE$.FixedQueueMask()];
        }

        @Override
        public void clear() {
            while (this.nonEmpty()) {
                this.dequeue();
            }
        }

        @Override
        public void dropHead() {
            this.dequeue();
        }

        @Override
        public void dropTail() {
            this.tail_$eq(this.tail() - 1);
            this.queue()[this.tail() & Buffer$.MODULE$.FixedQueueMask()] = null;
        }

        public FixedQueue(int capacity, Function1<Buffer<T>, BoxedUnit> switchBuffer) {
            this.capacity = capacity;
            this.switchBuffer = switchBuffer;
            this.queue = new Object[Buffer$.MODULE$.FixedQueueSize()];
            this.head = 0;
            this.tail = 0;
        }
    }
}

