/*
 * Decompiled with CFR 0.152.
 */
package akka.kafka;

import akka.actor.ActorSystem;
import akka.kafka.ConsumerSettings;
import akka.kafka.internal.ConfigSettings$;
import com.typesafe.config.Config;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.serialization.Deserializer;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public final class ConsumerSettings$ {
    public static final ConsumerSettings$ MODULE$;

    static {
        new ConsumerSettings$();
    }

    public <K, V> ConsumerSettings<K, V> apply(ActorSystem system, Option<Deserializer<K>> keyDeserializer, Option<Deserializer<V>> valueDeserializer) {
        Config config = system.settings().config().getConfig("akka.kafka.consumer");
        return this.apply(config, keyDeserializer, valueDeserializer);
    }

    public <K, V> ConsumerSettings<K, V> apply(Config config, Option<Deserializer<K>> keyDeserializer, Option<Deserializer<V>> valueDeserializer) {
        Map<String, String> properties = ConfigSettings$.MODULE$.parseKafkaClientsProperties(config.getConfig("kafka-clients"));
        Predef$.MODULE$.require(keyDeserializer != null && (keyDeserializer.isDefined() || properties.contains((Object)"key.deserializer")), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Key deserializer should be defined or declared in configuration";
            }
        });
        Predef$.MODULE$.require(valueDeserializer != null && (valueDeserializer.isDefined() || properties.contains((Object)"value.deserializer")), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Value deserializer should be defined or declared in configuration";
            }
        });
        FiniteDuration pollInterval = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("poll-interval", TimeUnit.MILLISECONDS))).millis();
        FiniteDuration pollTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("poll-timeout", TimeUnit.MILLISECONDS))).millis();
        FiniteDuration stopTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("stop-timeout", TimeUnit.MILLISECONDS))).millis();
        FiniteDuration closeTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("close-timeout", TimeUnit.MILLISECONDS))).millis();
        FiniteDuration commitTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("commit-timeout", TimeUnit.MILLISECONDS))).millis();
        FiniteDuration wakeupTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("wakeup-timeout", TimeUnit.MILLISECONDS))).millis();
        int maxWakeups = config.getInt("max-wakeups");
        String dispatcher = config.getString("use-dispatcher");
        return new ConsumerSettings<K, V>(properties, keyDeserializer, valueDeserializer, pollInterval, pollTimeout, stopTimeout, closeTimeout, commitTimeout, wakeupTimeout, maxWakeups, dispatcher);
    }

    public <K, V> ConsumerSettings<K, V> apply(ActorSystem system, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.apply(system, Option$.MODULE$.apply(keyDeserializer), Option$.MODULE$.apply(valueDeserializer));
    }

    public <K, V> ConsumerSettings<K, V> apply(Config config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.apply(config, Option$.MODULE$.apply(keyDeserializer), Option$.MODULE$.apply(valueDeserializer));
    }

    public <K, V> ConsumerSettings<K, V> create(ActorSystem system, Optional<Deserializer<K>> keyDeserializer, Optional<Deserializer<V>> valueDeserializer) {
        return this.apply(system, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(keyDeserializer)), OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(valueDeserializer)));
    }

    public <K, V> ConsumerSettings<K, V> create(Config config, Optional<Deserializer<K>> keyDeserializer, Optional<Deserializer<V>> valueDeserializer) {
        return this.apply(config, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(keyDeserializer)), OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(valueDeserializer)));
    }

    public <K, V> ConsumerSettings<K, V> create(ActorSystem system, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.apply(system, keyDeserializer, valueDeserializer);
    }

    public <K, V> ConsumerSettings<K, V> create(Config config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.apply(config, keyDeserializer, valueDeserializer);
    }

    private ConsumerSettings$() {
        MODULE$ = this;
    }
}

