/*
 * Decompiled with CFR 0.152.
 */
package akka.kernel;

import akka.actor.ActorSystem$;
import akka.kernel.Bootable;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class Main$ {
    public static final Main$ MODULE$;
    private final boolean quiet;

    static {
        new Main$();
    }

    private boolean quiet() {
        return this.quiet;
    }

    public void akka$kernel$Main$$log(String s) {
        if (!this.quiet()) {
            Predef$.MODULE$.println((Object)s);
        }
    }

    public void main(String[] args) {
        if (Predef$.MODULE$.refArrayOps((Object[])args).isEmpty()) {
            this.akka$kernel$Main$$log("[error] No boot classes specified");
            System.exit(1);
        }
        this.akka$kernel$Main$$log(this.banner());
        this.akka$kernel$Main$$log("Starting Akka...");
        this.akka$kernel$Main$$log(new StringBuilder().append((Object)"Running Akka ").append((Object)ActorSystem$.MODULE$.Version()).toString());
        ClassLoader classLoader = this.createClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        scala.collection.immutable.Seq bootClasses = (scala.collection.immutable.Seq)Predef$.MODULE$.refArrayOps((Object[])args).to(Predef$.MODULE$.fallbackStringCanBuildFrom());
        scala.collection.immutable.Seq bootables = (scala.collection.immutable.Seq)bootClasses.map((Function1)new Serializable(classLoader){
            public static final long serialVersionUID = 0L;
            private final ClassLoader classLoader$1;

            public final Bootable apply(String c) {
                return (Bootable)this.classLoader$1.loadClass(c).newInstance();
            }
            {
                this.classLoader$1 = classLoader$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        bootables.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Bootable bootable) {
                Main$.MODULE$.akka$kernel$Main$$log(new StringBuilder().append((Object)"Starting up ").append((Object)bootable.getClass().getName()).toString());
                bootable.startup();
            }
        });
        this.addShutdownHook((scala.collection.immutable.Seq<Bootable>)bootables);
        this.akka$kernel$Main$$log("Successfully started Akka");
    }

    private ClassLoader createClassLoader() {
        ClassLoader classLoader;
        if (ActorSystem$.MODULE$.GlobalHome().isDefined()) {
            String home = (String)ActorSystem$.MODULE$.GlobalHome().get();
            File deploy = new File(home, "deploy");
            if (deploy.exists()) {
                classLoader = this.loadDeployJars(deploy);
            } else {
                this.akka$kernel$Main$$log(new StringBuilder().append((Object)"[warning] No deploy dir found at ").append((Object)deploy).toString());
                classLoader = Thread.currentThread().getContextClassLoader();
            }
        } else {
            this.akka$kernel$Main$$log("[warning] Akka home is not defined");
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private ClassLoader loadDeployJars(File deploy) {
        File[] jars = (File[])Predef$.MODULE$.refArrayOps((Object[])deploy.listFiles()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.getName().endsWith(".jar");
            }
        });
        File[] nestedJars = (File[])Predef$.MODULE$.refArrayOps((Object[])jars).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<File> apply(File jar) {
                JarFile jarFile = new JarFile(jar);
                JarEntry[] jarEntries = (JarEntry[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(jarFile.entries()).asScala()).toArray(ClassTag$.MODULE$.apply(JarEntry.class))).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(JarEntry x$2) {
                        return x$2.getName().endsWith(".jar");
                    }
                });
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])jarEntries).map((Function1)new Serializable(this, jarFile){
                    public static final long serialVersionUID = 0L;
                    private final JarFile jarFile$1;

                    public final File apply(JarEntry entry) {
                        return new File(new StringOps(Predef$.MODULE$.augmentString("jar:file:%s!/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jarFile$1.getName(), entry.getName()})));
                    }
                    {
                        this.jarFile$1 = jarFile$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        URL[] urls = (URL[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])jars).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])nestedJars), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URL apply(File x$3) {
                return x$3.toURI().toURL();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
        Predef$.MODULE$.refArrayOps((Object[])urls).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(URL url) {
                Main$.MODULE$.akka$kernel$Main$$log(new StringBuilder().append((Object)"Deploying ").append((Object)url).toString());
            }
        });
        return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    private void addShutdownHook(scala.collection.immutable.Seq<Bootable> bootables) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(bootables){
            private final scala.collection.immutable.Seq bootables$1;

            public void run() {
                Main$.MODULE$.akka$kernel$Main$$log("");
                Main$.MODULE$.akka$kernel$Main$$log("Shutting down Akka...");
                this.bootables$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Bootable bootable) {
                        Main$.MODULE$.akka$kernel$Main$$log(new StringBuilder().append((Object)"Shutting down ").append((Object)bootable.getClass().getName()).toString());
                        bootable.shutdown();
                    }
                });
                Main$.MODULE$.akka$kernel$Main$$log("Successfully shut down Akka");
            }
            {
                this.bootables$1 = bootables$1;
            }
        }));
    }

    private String banner() {
        return "\n==============================================================================\n\n                                                   ZZ:\n                                                  ZZZZ\n                                                 ZZZZZZ\n                                                ZZZ' ZZZ\n                                       ~7      7ZZ'   ZZZ\n                                      :ZZZ:   IZZ'     ZZZ\n                                     ,OZZZZ.~ZZ?        ZZZ\n                                    ZZZZ' 'ZZZ$          ZZZ\n                           .       $ZZZ   ~ZZ$            ZZZ\n                         .=Z?.   .ZZZO   ~ZZ7              OZZ\n                        .ZZZZ7..:ZZZ~   7ZZZ                ZZZ~\n                      .$ZZZ$Z+.ZZZZ    ZZZ:                  ZZZ$\n                   .,ZZZZ?'  =ZZO=   .OZZ                     'ZZZ\n                 .$ZZZZ+   .ZZZZ    IZZZ                        ZZZ$\n               .ZZZZZ'   .ZZZZ'   .ZZZ$                          ?ZZZ\n            .ZZZZZZ'   .OZZZ?    ?ZZZ                             'ZZZ$\n        .?ZZZZZZ'    .ZZZZ?    .ZZZ?                                'ZZZO\n    .+ZZZZZZ?'    .7ZZZZ'    .ZZZZ                                    :ZZZZ\n .ZZZZZZ$'     .?ZZZZZ'   .~ZZZZ                                        'ZZZZ.\n\n\n                      NNNNN              $NNNN+\n                      NNNNN              $NNNN+\n                      NNNNN              $NNNN+\n                      NNNNN              $NNNN+\n                      NNNNN              $NNNN+\n    =NNNNNNNNND$      NNNNN     DDDDDD:  $NNNN+     DDDDDN     NDDNNNNNNNN,\n   NNNNNNNNNNNNND     NNNNN    DNNNNN    $NNNN+   8NNNNN=    :NNNNNNNNNNNNNN\n  NNNNN$    DNNNNN    NNNNN  $NNNNN~     $NNNN+  NNNNNN      NNNNN,   :NNNNN+\n   ?DN~      NNNNN    NNNNN MNNNNN       $NNNN+:NNNNN7        $ND      =NNNNN\n            DNNNNN    NNNNNDNNNN$        $NNNNDNNNNN                  :DNNNNN\n     ZNDNNNNNNNNND    NNNNNNNNNND,       $NNNNNNNNNNN           DNDNNNNNNNNNN\n   NNNNNNNDDINNNNN    NNNNNNNNNNND       $NNNNNNNNNNND       ONNNNNNND8+NNNNN\n :NNNND      NNNNN    NNNNNN  DNNNN,     $NNNNNO 7NNNND     NNNNNO     :NNNNN\n DNNNN       NNNNN    NNNNN    DNNNN     $NNNN+   8NNNNN    NNNNN      $NNNNN\n DNNNNO     NNNNNN    NNNNN     NNNNN    $NNNN+    NNNNN$   NNNND,    ,NNNNND\n  NNNNNNDDNNNNNNNN    NNNNN     =NNNNN   $NNNN+     DNNNN?  DNNNNNNDNNNNNNNND\n   NNNNNNNNN  NNNN$   NNNNN      8NNNND  $NNNN+      NNNNN=  ,DNNNNNNND NNNNN$\n\n==============================================================================\n";
    }

    private Main$() {
        MODULE$ = this;
        this.quiet = Boolean.getBoolean("akka.kernel.quiet");
    }
}

