/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.util.calendar;

import com.tencent.kona.sun.security.action.GetPropertyAction;
import com.tencent.kona.sun.util.calendar.BaseCalendar;
import com.tencent.kona.sun.util.calendar.CalendarDate;
import com.tencent.kona.sun.util.calendar.CalendarUtils;
import com.tencent.kona.sun.util.calendar.Era;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalGregorianCalendar
extends BaseCalendar {
    private static final Era[] JAPANESE_ERAS = new Era[]{new Era("Meiji", "M", -3218832000000L, true), new Era("Taisho", "T", -1812153600000L, true), new Era("Showa", "S", -1357603200000L, true), new Era("Heisei", "H", 600220800000L, true), new Era("Reiwa", "R", 1556668800000L, true)};
    private String name;
    private Era[] eras;

    private static boolean isValidEra(Era newEra, Era[] eras) {
        Era last = eras[eras.length - 1];
        if (last.getSince(null) >= newEra.getSince(null)) {
            return false;
        }
        String newName = newEra.getName();
        for (Era era : eras) {
            if (!era.getName().equals(newName)) continue;
            return false;
        }
        return true;
    }

    static LocalGregorianCalendar getLocalGregorianCalendar(String name) {
        Era era;
        if (!"japanese".equals(name)) {
            return null;
        }
        String prop = GetPropertyAction.privilegedGetProperty("jdk.calendar.japanese.supplemental.era");
        if (prop != null && (era = LocalGregorianCalendar.parseEraEntry(prop)) != null && LocalGregorianCalendar.isValidEra(era, JAPANESE_ERAS)) {
            int length = JAPANESE_ERAS.length;
            Era[] eras = new Era[length + 1];
            System.arraycopy(JAPANESE_ERAS, 0, eras, 0, length);
            eras[length] = era;
            return new LocalGregorianCalendar(name, eras);
        }
        return new LocalGregorianCalendar(name, JAPANESE_ERAS);
    }

    private static Era parseEraEntry(String entry) {
        String[] keyValuePairs = entry.split(",");
        String eraName = null;
        boolean localTime = true;
        long since = 0L;
        String abbr = null;
        block12: for (String item : keyValuePairs) {
            String[] keyvalue = item.split("=");
            if (keyvalue.length != 2) {
                return null;
            }
            String key = keyvalue[0].trim();
            String value = LocalGregorianCalendar.convertUnicodeEscape(keyvalue[1].trim());
            switch (key) {
                case "name": {
                    eraName = value;
                    continue block12;
                }
                case "since": {
                    if (value.endsWith("u")) {
                        localTime = false;
                        value = value.substring(0, value.length() - 1);
                    }
                    try {
                        since = Long.parseLong(value);
                        continue block12;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                case "abbr": {
                    abbr = value;
                    continue block12;
                }
                default: {
                    return null;
                }
            }
        }
        if (eraName == null || eraName.isEmpty() || abbr == null || abbr.isEmpty()) {
            return null;
        }
        return new Era(eraName, abbr, since, localTime);
    }

    private static String convertUnicodeEscape(String src) {
        Matcher m = Pattern.compile("\\\\u([0-9a-fA-F]{4})").matcher(src);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, Character.toString((char)Integer.parseUnsignedInt(m.group(1), 16)));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private LocalGregorianCalendar(String name, Era[] eras) {
        this.name = name;
        this.eras = eras;
        this.setEras(eras);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getCalendarDate() {
        return this.getCalendarDate(System.currentTimeMillis(), this.newCalendarDate());
    }

    @Override
    public Date getCalendarDate(long millis) {
        return this.getCalendarDate(millis, this.newCalendarDate());
    }

    @Override
    public Date getCalendarDate(long millis, TimeZone zone) {
        return this.getCalendarDate(millis, this.newCalendarDate(zone));
    }

    @Override
    public Date getCalendarDate(long millis, CalendarDate date) {
        Date ldate = (Date)super.getCalendarDate(millis, date);
        return this.adjustYear(ldate, millis, ldate.getZoneOffset());
    }

    private Date adjustYear(Date ldate, long millis, int zoneOffset) {
        int i;
        for (i = this.eras.length - 1; i >= 0; --i) {
            Era era = this.eras[i];
            long since = era.getSince(null);
            if (era.isLocalTime()) {
                since -= (long)zoneOffset;
            }
            if (millis < since) continue;
            ldate.setLocalEra(era);
            int y = ldate.getNormalizedYear() - era.getSinceDate().getYear() + 1;
            ldate.setLocalYear(y);
            break;
        }
        if (i < 0) {
            ldate.setLocalEra(null);
            ldate.setLocalYear(ldate.getNormalizedYear());
        }
        ldate.setNormalized(true);
        return ldate;
    }

    @Override
    public Date newCalendarDate() {
        return new Date();
    }

    @Override
    public Date newCalendarDate(TimeZone zone) {
        return new Date(zone);
    }

    @Override
    public boolean validate(CalendarDate date) {
        Date ldate = (Date)date;
        Era era = ldate.getEra();
        if (era != null) {
            if (!this.validateEra(era)) {
                return false;
            }
            ldate.setNormalizedYear(era.getSinceDate().getYear() + ldate.getYear() - 1);
            Date tmp = this.newCalendarDate(date.getZone());
            tmp.setEra(era).setDate(date.getYear(), date.getMonth(), date.getDayOfMonth());
            this.normalize(tmp);
            if (tmp.getEra() != era) {
                return false;
            }
        } else {
            if (date.getYear() >= this.eras[0].getSinceDate().getYear()) {
                return false;
            }
            ldate.setNormalizedYear(ldate.getYear());
        }
        return super.validate(ldate);
    }

    private boolean validateEra(Era era) {
        for (Era era1 : this.eras) {
            if (era != era1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean normalize(CalendarDate date) {
        int i;
        if (date.isNormalized()) {
            return true;
        }
        this.normalizeYear(date);
        Date ldate = (Date)date;
        super.normalize(ldate);
        boolean hasMillis = false;
        long millis = 0L;
        int year = ldate.getNormalizedYear();
        Era era = null;
        for (i = this.eras.length - 1; i >= 0; --i) {
            long since;
            era = this.eras[i];
            if (era.isLocalTime()) {
                long sinceTimeOfDay;
                int sinceDay;
                int sinceMonth;
                CalendarDate sinceDate = era.getSinceDate();
                int sinceYear = sinceDate.getYear();
                if (year > sinceYear) break;
                if (year != sinceYear) continue;
                int month = ldate.getMonth();
                if (month > (sinceMonth = sinceDate.getMonth())) break;
                if (month != sinceMonth) continue;
                int day = ldate.getDayOfMonth();
                if (day > (sinceDay = sinceDate.getDayOfMonth())) break;
                if (day != sinceDay) continue;
                long timeOfDay = ldate.getTimeOfDay();
                if (timeOfDay >= (sinceTimeOfDay = sinceDate.getTimeOfDay())) break;
                --i;
                break;
            }
            if (!hasMillis) {
                millis = super.getTime(date);
                hasMillis = true;
            }
            if (millis >= (since = era.getSince(date.getZone()))) break;
        }
        if (i >= 0) {
            ldate.setLocalEra(era);
            int y = ldate.getNormalizedYear() - era.getSinceDate().getYear() + 1;
            ldate.setLocalYear(y);
        } else {
            ldate.setEra(null);
            ldate.setLocalYear(year);
            ldate.setNormalizedYear(year);
        }
        ldate.setNormalized(true);
        return true;
    }

    @Override
    void normalizeMonth(CalendarDate date) {
        this.normalizeYear(date);
        super.normalizeMonth(date);
    }

    void normalizeYear(CalendarDate date) {
        Date ldate = (Date)date;
        Era era = ldate.getEra();
        if (era == null || !this.validateEra(era)) {
            ldate.setNormalizedYear(ldate.getYear());
        } else {
            ldate.setNormalizedYear(era.getSinceDate().getYear() + ldate.getYear() - 1);
        }
    }

    @Override
    public boolean isLeapYear(int gregorianYear) {
        return CalendarUtils.isGregorianLeapYear(gregorianYear);
    }

    public boolean isLeapYear(Era era, int year) {
        if (era == null) {
            return this.isLeapYear(year);
        }
        int gyear = era.getSinceDate().getYear() + year - 1;
        return this.isLeapYear(gyear);
    }

    @Override
    public void getCalendarDateFromFixedDate(CalendarDate date, long fixedDate) {
        Date ldate = (Date)date;
        super.getCalendarDateFromFixedDate(ldate, fixedDate);
        this.adjustYear(ldate, (fixedDate - 719163L) * 86400000L, 0);
    }

    public static class Date
    extends BaseCalendar.Date {
        private int gregorianYear = Integer.MIN_VALUE;

        protected Date() {
        }

        protected Date(TimeZone zone) {
            super(zone);
        }

        @Override
        public Date setEra(Era era) {
            if (this.getEra() != era) {
                super.setEra(era);
                this.gregorianYear = Integer.MIN_VALUE;
            }
            return this;
        }

        @Override
        public Date addYear(int localYear) {
            super.addYear(localYear);
            this.gregorianYear += localYear;
            return this;
        }

        @Override
        public Date setYear(int localYear) {
            if (this.getYear() != localYear) {
                super.setYear(localYear);
                this.gregorianYear = Integer.MIN_VALUE;
            }
            return this;
        }

        @Override
        public int getNormalizedYear() {
            return this.gregorianYear;
        }

        @Override
        public void setNormalizedYear(int normalizedYear) {
            this.gregorianYear = normalizedYear;
        }

        void setLocalEra(Era era) {
            super.setEra(era);
        }

        void setLocalYear(int year) {
            super.setYear(year);
        }

        @Override
        public String toString() {
            String abbr;
            String time = super.toString();
            time = time.substring(time.indexOf(84));
            StringBuilder sb = new StringBuilder();
            Era era = this.getEra();
            if (era != null && (abbr = era.getAbbreviation()) != null) {
                sb.append(abbr);
            }
            sb.append(this.getYear()).append('.');
            CalendarUtils.sprintf0d(sb, this.getMonth(), 2).append('.');
            CalendarUtils.sprintf0d(sb, this.getDayOfMonth(), 2);
            sb.append(time);
            return sb.toString();
        }
    }
}

