/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util.math.intpoly;

import com.tencent.kona.java.lang.MathUtil;
import com.tencent.kona.sun.security.util.math.ImmutableIntegerModuloP;
import com.tencent.kona.sun.security.util.math.IntegerFieldModuloP;
import com.tencent.kona.sun.security.util.math.IntegerMontgomeryFieldModuloP;
import com.tencent.kona.sun.security.util.math.SmallValue;
import com.tencent.kona.sun.security.util.math.intpoly.IntegerPolynomial;
import com.tencent.kona.sun.security.util.math.intpoly.IntegerPolynomialP256;
import java.math.BigInteger;

public final class MontgomeryIntegerPolynomialP256
extends IntegerPolynomial
implements IntegerMontgomeryFieldModuloP {
    private static final int BITS_PER_LIMB = 52;
    private static final int NUM_LIMBS = 5;
    private static final int MAX_ADDS = 0;
    public static final BigInteger MODULUS = MontgomeryIntegerPolynomialP256.evaluateModulus();
    private static final long LIMB_MASK = 0xFFFFFFFFFFFFFL;
    public static final MontgomeryIntegerPolynomialP256 ONE = new MontgomeryIntegerPolynomialP256();
    private static final long[] h = new long[]{768L, 0xFFFFFFFF00000L, 0xFFFFEFFFFFFFBL, 0xFDFFFFFFFFFFFL, 0x4FFFFFFL};
    private static final long[] oneActual = new long[]{1L, 0L, 0L, 0L, 0L};
    private static final long[] oneMont = new long[]{16L, 0xF000000000000L, 0xFFFFFFFFFFFFFL, 0xFFEFFFFFFFFFFL, 1048575L};
    private static final long[] zero = new long[]{0L, 0L, 0L, 0L, 0L};
    private static final long[] modulus = new long[]{0xFFFFFFFFFFFFFL, 0xFFFFFFFFFFFL, 0L, 0x1000000000L, 0xFFFFFFFF0000L};

    private MontgomeryIntegerPolynomialP256() {
        super(52, 5, 0, MODULUS);
    }

    @Override
    public IntegerFieldModuloP residueField() {
        return IntegerPolynomialP256.ONE;
    }

    private static BigInteger evaluateModulus() {
        BigInteger result = BigInteger.valueOf(2L).pow(256);
        result = result.subtract(BigInteger.valueOf(1L).shiftLeft(224));
        result = result.add(BigInteger.valueOf(1L).shiftLeft(192));
        result = result.add(BigInteger.valueOf(1L).shiftLeft(96));
        result = result.subtract(BigInteger.valueOf(1L));
        return result;
    }

    @Override
    public IntegerPolynomial.ImmutableElement get0() {
        return new IntegerPolynomial.ImmutableElement(this, zero, 0);
    }

    @Override
    public IntegerPolynomial.ImmutableElement get1() {
        return new IntegerPolynomial.ImmutableElement(this, oneMont, 0);
    }

    @Override
    public IntegerPolynomial.ImmutableElement getElement(BigInteger v) {
        long[] vLimbs = new long[5];
        long[] montLimbs = new long[5];
        this.setLimbsValuePositive(v, vLimbs);
        this.mult(vLimbs, h, montLimbs);
        return new IntegerPolynomial.ImmutableElement(this, montLimbs, 0);
    }

    @Override
    public SmallValue getSmallValue(int value) {
        return super.getSmallValue(value);
    }

    @Override
    public ImmutableIntegerModuloP fromMontgomery(ImmutableIntegerModuloP n) {
        assert (n.getField() == ONE);
        IntegerPolynomial.ImmutableElement nn = (IntegerPolynomial.ImmutableElement)n;
        long[] r1 = new long[5];
        long[] r2 = new long[10];
        long[] limbs = nn.getLimbs();
        this.reduce(limbs);
        ONE.mult(limbs, oneActual, r1);
        this.reduce(r1);
        this.halfLimbs(r1, r2);
        IntegerPolynomialP256 integerPolynomialP256 = IntegerPolynomialP256.ONE;
        integerPolynomialP256.getClass();
        return new IntegerPolynomial.ImmutableElement(integerPolynomialP256, r2, 0);
    }

    private void halfLimbs(long[] a, long[] r) {
        long HALF_BITS_LIMB = 26L;
        long HALF_LIMB_MASK = -1L >>> 38;
        r[0] = a[0] & HALF_LIMB_MASK;
        r[1] = a[0] >> 26;
        r[2] = a[1] & HALF_LIMB_MASK;
        r[3] = a[1] >> 26;
        r[4] = a[2] & HALF_LIMB_MASK;
        r[5] = a[2] >> 26;
        r[6] = a[3] & HALF_LIMB_MASK;
        r[7] = a[3] >> 26;
        r[8] = a[4] & HALF_LIMB_MASK;
        r[9] = a[4] >> 26;
    }

    @Override
    protected void square(long[] a, long[] r) {
        this.mult(a, a, r);
    }

    @Override
    protected void mult(long[] a, long[] b, long[] r) {
        long aa0 = a[0];
        long aa1 = a[1];
        long aa2 = a[2];
        long aa3 = a[3];
        long aa4 = a[4];
        long bb0 = b[0];
        long bb1 = b[1];
        long bb2 = b[2];
        long bb3 = b[3];
        long bb4 = b[4];
        long shift1 = 12L;
        long shift2 = 52L;
        long d0 = aa0 * bb0;
        long dd0 = MathUtil.unsignedMultiplyHigh(aa0, bb0) << 12 | d0 >>> 52;
        long n = d0 &= 0xFFFFFFFFFFFFFL;
        long d1 = aa0 * bb1;
        long dd1 = MathUtil.unsignedMultiplyHigh(aa0, bb1) << 12 | d1 >>> 52;
        d1 &= 0xFFFFFFFFFFFFFL;
        long d2 = aa0 * bb2;
        long dd2 = MathUtil.unsignedMultiplyHigh(aa0, bb2) << 12 | d2 >>> 52;
        d2 &= 0xFFFFFFFFFFFFFL;
        long d3 = aa0 * bb3;
        long dd3 = MathUtil.unsignedMultiplyHigh(aa0, bb3) << 12 | d3 >>> 52;
        d3 &= 0xFFFFFFFFFFFFFL;
        long d4 = aa0 * bb4;
        long dd4 = MathUtil.unsignedMultiplyHigh(aa0, bb4) << 12 | d4 >>> 52;
        d4 &= 0xFFFFFFFFFFFFFL;
        long n0 = n * modulus[0];
        long nn0 = MathUtil.unsignedMultiplyHigh(n, modulus[0]) << 12 | n0 >>> 52;
        n0 &= 0xFFFFFFFFFFFFFL;
        long n1 = n * modulus[1];
        long nn1 = MathUtil.unsignedMultiplyHigh(n, modulus[1]) << 12 | n1 >>> 52;
        n1 &= 0xFFFFFFFFFFFFFL;
        long n2 = n * modulus[2];
        long nn2 = MathUtil.unsignedMultiplyHigh(n, modulus[2]) << 12 | n2 >>> 52;
        n2 &= 0xFFFFFFFFFFFFFL;
        long n3 = n * modulus[3];
        long nn3 = MathUtil.unsignedMultiplyHigh(n, modulus[3]) << 12 | n3 >>> 52;
        n3 &= 0xFFFFFFFFFFFFFL;
        long n4 = n * modulus[4];
        long nn4 = MathUtil.unsignedMultiplyHigh(n, modulus[4]) << 12 | n4 >>> 52;
        long c1 = (d1 += n1) + (dd0 += nn0) + ((d0 += n0) >>> 52);
        long c2 = (d2 += n2) + (dd1 += nn1);
        long c3 = (d3 += n3) + (dd2 += nn2);
        long c4 = (d4 += (n4 &= 0xFFFFFFFFFFFFFL)) + (dd3 += nn3);
        long c5 = dd4 += nn4;
        d0 = aa1 * bb0;
        dd0 = MathUtil.unsignedMultiplyHigh(aa1, bb0) << 12 | d0 >>> 52;
        d0 &= 0xFFFFFFFFFFFFFL;
        n = (d0 += c1) & 0xFFFFFFFFFFFFFL;
        d1 = aa1 * bb1;
        dd1 = MathUtil.unsignedMultiplyHigh(aa1, bb1) << 12 | d1 >>> 52;
        d1 &= 0xFFFFFFFFFFFFFL;
        d2 = aa1 * bb2;
        dd2 = MathUtil.unsignedMultiplyHigh(aa1, bb2) << 12 | d2 >>> 52;
        d2 &= 0xFFFFFFFFFFFFFL;
        d3 = aa1 * bb3;
        dd3 = MathUtil.unsignedMultiplyHigh(aa1, bb3) << 12 | d3 >>> 52;
        d3 &= 0xFFFFFFFFFFFFFL;
        d4 = aa1 * bb4;
        dd4 = MathUtil.unsignedMultiplyHigh(aa1, bb4) << 12 | d4 >>> 52;
        d4 &= 0xFFFFFFFFFFFFFL;
        n0 = n * modulus[0];
        dd0 += MathUtil.unsignedMultiplyHigh(n, modulus[0]) << 12 | n0 >>> 52;
        d0 += n0 & 0xFFFFFFFFFFFFFL;
        n1 = n * modulus[1];
        dd1 += MathUtil.unsignedMultiplyHigh(n, modulus[1]) << 12 | n1 >>> 52;
        d1 += n1 & 0xFFFFFFFFFFFFFL;
        n2 = n * modulus[2];
        dd2 += MathUtil.unsignedMultiplyHigh(n, modulus[2]) << 12 | n2 >>> 52;
        d2 += n2 & 0xFFFFFFFFFFFFFL;
        n3 = n * modulus[3];
        n4 = n * modulus[4];
        c2 += d1 + dd0 + (d0 >>> 52);
        c3 += d2 + dd1;
        c4 += (d3 += n3 & 0xFFFFFFFFFFFFFL) + dd2;
        c5 += (d4 += n4 & 0xFFFFFFFFFFFFFL) + (dd3 += MathUtil.unsignedMultiplyHigh(n, modulus[3]) << 12 | n3 >>> 52);
        long c6 = dd4 += MathUtil.unsignedMultiplyHigh(n, modulus[4]) << 12 | n4 >>> 52;
        d0 = aa2 * bb0;
        dd0 = MathUtil.unsignedMultiplyHigh(aa2, bb0) << 12 | d0 >>> 52;
        d0 &= 0xFFFFFFFFFFFFFL;
        n = (d0 += c2) & 0xFFFFFFFFFFFFFL;
        d1 = aa2 * bb1;
        dd1 = MathUtil.unsignedMultiplyHigh(aa2, bb1) << 12 | d1 >>> 52;
        d1 &= 0xFFFFFFFFFFFFFL;
        d2 = aa2 * bb2;
        dd2 = MathUtil.unsignedMultiplyHigh(aa2, bb2) << 12 | d2 >>> 52;
        d2 &= 0xFFFFFFFFFFFFFL;
        d3 = aa2 * bb3;
        dd3 = MathUtil.unsignedMultiplyHigh(aa2, bb3) << 12 | d3 >>> 52;
        d3 &= 0xFFFFFFFFFFFFFL;
        d4 = aa2 * bb4;
        dd4 = MathUtil.unsignedMultiplyHigh(aa2, bb4) << 12 | d4 >>> 52;
        d4 &= 0xFFFFFFFFFFFFFL;
        n0 = n * modulus[0];
        dd0 += MathUtil.unsignedMultiplyHigh(n, modulus[0]) << 12 | n0 >>> 52;
        d0 += n0 & 0xFFFFFFFFFFFFFL;
        n1 = n * modulus[1];
        dd1 += MathUtil.unsignedMultiplyHigh(n, modulus[1]) << 12 | n1 >>> 52;
        d1 += n1 & 0xFFFFFFFFFFFFFL;
        n2 = n * modulus[2];
        dd2 += MathUtil.unsignedMultiplyHigh(n, modulus[2]) << 12 | n2 >>> 52;
        d2 += n2 & 0xFFFFFFFFFFFFFL;
        n3 = n * modulus[3];
        n4 = n * modulus[4];
        c3 += d1 + dd0 + (d0 >>> 52);
        c4 += d2 + dd1;
        c5 += (d3 += n3 & 0xFFFFFFFFFFFFFL) + dd2;
        c6 += (d4 += n4 & 0xFFFFFFFFFFFFFL) + (dd3 += MathUtil.unsignedMultiplyHigh(n, modulus[3]) << 12 | n3 >>> 52);
        long c7 = dd4 += MathUtil.unsignedMultiplyHigh(n, modulus[4]) << 12 | n4 >>> 52;
        d0 = aa3 * bb0;
        dd0 = MathUtil.unsignedMultiplyHigh(aa3, bb0) << 12 | d0 >>> 52;
        d0 &= 0xFFFFFFFFFFFFFL;
        n = (d0 += c3) & 0xFFFFFFFFFFFFFL;
        d1 = aa3 * bb1;
        dd1 = MathUtil.unsignedMultiplyHigh(aa3, bb1) << 12 | d1 >>> 52;
        d1 &= 0xFFFFFFFFFFFFFL;
        d2 = aa3 * bb2;
        dd2 = MathUtil.unsignedMultiplyHigh(aa3, bb2) << 12 | d2 >>> 52;
        d2 &= 0xFFFFFFFFFFFFFL;
        d3 = aa3 * bb3;
        dd3 = MathUtil.unsignedMultiplyHigh(aa3, bb3) << 12 | d3 >>> 52;
        d3 &= 0xFFFFFFFFFFFFFL;
        d4 = aa3 * bb4;
        dd4 = MathUtil.unsignedMultiplyHigh(aa3, bb4) << 12 | d4 >>> 52;
        d4 &= 0xFFFFFFFFFFFFFL;
        n0 = n * modulus[0];
        dd0 += MathUtil.unsignedMultiplyHigh(n, modulus[0]) << 12 | n0 >>> 52;
        d0 += n0 & 0xFFFFFFFFFFFFFL;
        n1 = n * modulus[1];
        dd1 += MathUtil.unsignedMultiplyHigh(n, modulus[1]) << 12 | n1 >>> 52;
        d1 += n1 & 0xFFFFFFFFFFFFFL;
        n2 = n * modulus[2];
        dd2 += MathUtil.unsignedMultiplyHigh(n, modulus[2]) << 12 | n2 >>> 52;
        d2 += n2 & 0xFFFFFFFFFFFFFL;
        n3 = n * modulus[3];
        n4 = n * modulus[4];
        c4 += d1 + dd0 + (d0 >>> 52);
        c5 += d2 + dd1;
        c6 += (d3 += n3 & 0xFFFFFFFFFFFFFL) + dd2;
        c7 += (d4 += n4 & 0xFFFFFFFFFFFFFL) + (dd3 += MathUtil.unsignedMultiplyHigh(n, modulus[3]) << 12 | n3 >>> 52);
        long c8 = dd4 += MathUtil.unsignedMultiplyHigh(n, modulus[4]) << 12 | n4 >>> 52;
        d0 = aa4 * bb0;
        dd0 = MathUtil.unsignedMultiplyHigh(aa4, bb0) << 12 | d0 >>> 52;
        d0 &= 0xFFFFFFFFFFFFFL;
        n = (d0 += c4) & 0xFFFFFFFFFFFFFL;
        d1 = aa4 * bb1;
        dd1 = MathUtil.unsignedMultiplyHigh(aa4, bb1) << 12 | d1 >>> 52;
        d1 &= 0xFFFFFFFFFFFFFL;
        d2 = aa4 * bb2;
        dd2 = MathUtil.unsignedMultiplyHigh(aa4, bb2) << 12 | d2 >>> 52;
        d2 &= 0xFFFFFFFFFFFFFL;
        d3 = aa4 * bb3;
        dd3 = MathUtil.unsignedMultiplyHigh(aa4, bb3) << 12 | d3 >>> 52;
        d3 &= 0xFFFFFFFFFFFFFL;
        d4 = aa4 * bb4;
        dd4 = MathUtil.unsignedMultiplyHigh(aa4, bb4) << 12 | d4 >>> 52;
        d4 &= 0xFFFFFFFFFFFFFL;
        n0 = n * modulus[0];
        dd0 += MathUtil.unsignedMultiplyHigh(n, modulus[0]) << 12 | n0 >>> 52;
        n1 = n * modulus[1];
        n2 = n * modulus[2];
        n3 = n * modulus[3];
        n4 = n * modulus[4];
        long c9 = (dd4 += MathUtil.unsignedMultiplyHigh(n, modulus[4]) << 12 | n4 >>> 52) + ((c8 += (d4 += n4 & 0xFFFFFFFFFFFFFL) + (dd3 += MathUtil.unsignedMultiplyHigh(n, modulus[3]) << 12 | n3 >>> 52) + ((c7 += (d3 += n3 & 0xFFFFFFFFFFFFFL) + (dd2 += MathUtil.unsignedMultiplyHigh(n, modulus[2]) << 12 | n2 >>> 52) + ((c6 += (d2 += n2 & 0xFFFFFFFFFFFFFL) + (dd1 += MathUtil.unsignedMultiplyHigh(n, modulus[1]) << 12 | n1 >>> 52) + ((c5 += (d1 += n1 & 0xFFFFFFFFFFFFFL) + dd0 + ((d0 += n0 & 0xFFFFFFFFFFFFFL) >>> 52)) >>> 52)) >>> 52)) >>> 52)) >>> 52);
        c8 &= 0xFFFFFFFFFFFFFL;
        long c0 = (c5 &= 0xFFFFFFFFFFFFFL) - modulus[0];
        c1 = (c6 &= 0xFFFFFFFFFFFFFL) - modulus[1] + (c0 >> 52);
        c0 &= 0xFFFFFFFFFFFFFL;
        c2 = (c7 &= 0xFFFFFFFFFFFFFL) - modulus[2] + (c1 >> 52);
        c1 &= 0xFFFFFFFFFFFFFL;
        c3 = c8 - modulus[3] + (c2 >> 52);
        c4 = c9 - modulus[4] + (c3 >> 52);
        long mask = c4 >> 63;
        r[0] = c5 & mask | c0 & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        r[1] = c6 & mask | c1 & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        r[2] = c7 & mask | (c2 &= 0xFFFFFFFFFFFFFL) & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        r[3] = c8 & mask | (c3 &= 0xFFFFFFFFFFFFFL) & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        r[4] = c9 & mask | c4 & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    protected void finalCarryReduceLast(long[] limbs) {
        this.reduce(limbs);
    }

    @Override
    protected long carryValue(long x) {
        return x >> 52;
    }

    @Override
    protected void postEncodeCarry(long[] v) {
    }

    @Override
    protected void reduce(long[] limbs) {
        long b0 = limbs[0];
        long b1 = limbs[1];
        long b2 = limbs[2];
        long b3 = limbs[3];
        long b4 = limbs[4];
        long carry = b4 >> 48;
        b4 -= carry << 48;
        b1 -= carry << 44;
        b3 -= carry << 36;
        b4 += carry << 16;
        b4 += (b3 += (b2 += (b1 += (b0 += carry) >> 52) >> 52) >> 52) >> 52;
        b3 &= 0xFFFFFFFFFFFFFL;
        long c0 = modulus[0] + (b0 &= 0xFFFFFFFFFFFFFL);
        long c1 = modulus[1] + (b1 &= 0xFFFFFFFFFFFFFL) + (c0 >> 52);
        c0 &= 0xFFFFFFFFFFFFFL;
        long c2 = modulus[2] + (b2 &= 0xFFFFFFFFFFFFFL) + (c1 >> 52);
        c1 &= 0xFFFFFFFFFFFFFL;
        long c3 = modulus[3] + b3 + (c2 >> 52);
        long c4 = modulus[4] + b4 + (c3 >> 52);
        long mask = b4 >> 52;
        limbs[0] = b0 & (mask ^ 0xFFFFFFFFFFFFFFFFL) | c0 & mask;
        limbs[1] = b1 & (mask ^ 0xFFFFFFFFFFFFFFFFL) | c1 & mask;
        limbs[2] = b2 & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (c2 &= 0xFFFFFFFFFFFFFL) & mask;
        limbs[3] = b3 & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (c3 &= 0xFFFFFFFFFFFFFL) & mask;
        limbs[4] = b4 & (mask ^ 0xFFFFFFFFFFFFFFFFL) | c4 & mask;
    }

    @Override
    public IntegerPolynomial.ImmutableElement getElement(byte[] v, int offset, int length, byte highByte) {
        long[] vLimbs = new long[5];
        long[] montLimbs = new long[5];
        super.encode(v, offset, length, highByte, vLimbs);
        this.mult(vLimbs, h, montLimbs);
        return new IntegerPolynomial.ImmutableElement(this, montLimbs, 0);
    }

    @Override
    protected void reduceIn(long[] limbs, long v, int i) {
        v += v >> 32;
        int n = i - 1;
        limbs[n] = limbs[n] + (v << 20 & 0xFFFFFFFFFFFFFL);
        int n2 = i - 2;
        limbs[n2] = limbs[n2] - (v << 40 & 0xFFFFFFFFFFFFFL);
        int n3 = i - 1;
        limbs[n3] = limbs[n3] - (v >> 12);
        int n4 = i - 4;
        limbs[n4] = limbs[n4] - (v << 48 & 0xFFFFFFFFFFFFFL);
        int n5 = i - 3;
        limbs[n5] = limbs[n5] - (v >> 4);
        int n6 = i - 5;
        limbs[n6] = limbs[n6] + (v << 4 & 0xFFFFFFFFFFFFFL);
        int n7 = i - 4;
        limbs[n7] = limbs[n7] + (v >> 48);
    }
}

