/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.rsa;

import com.tencent.kona.sun.security.util.SecurityProviderConstants;
import java.security.Provider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public final class SunRsaSignEntries {
    private LinkedHashSet<Provider.Service> services = new LinkedHashSet(20, 0.9f);

    private void add(Provider p, String type, String algo, String cn, List<String> aliases, HashMap<String, String> attrs) {
        this.services.add(new Provider.Service(p, type, algo, cn, aliases, attrs));
    }

    private void addA(Provider p, String type, String algo, String cn, HashMap<String, String> attrs) {
        this.services.add(new Provider.Service(p, type, algo, cn, SecurityProviderConstants.getAliases(algo), attrs));
    }

    public SunRsaSignEntries(Provider p) {
        HashMap<String, String> attrs = new HashMap<String, String>(3);
        attrs.put("SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        this.add(p, "KeyFactory", "RSA", "com.tencent.kona.sun.security.rsa.RSAKeyFactory$Legacy", SecurityProviderConstants.getAliases("PKCS1"), null);
        this.add(p, "KeyPairGenerator", "RSA", "com.tencent.kona.sun.security.rsa.RSAKeyPairGenerator$Legacy", SecurityProviderConstants.getAliases("PKCS1"), null);
        this.addA(p, "Signature", "MD2withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$MD2withRSA", attrs);
        this.addA(p, "Signature", "MD5withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$MD5withRSA", attrs);
        this.addA(p, "Signature", "SHA1withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA1withRSA", attrs);
        this.addA(p, "Signature", "SHA224withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA224withRSA", attrs);
        this.addA(p, "Signature", "SHA256withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA256withRSA", attrs);
        this.addA(p, "Signature", "SHA384withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA384withRSA", attrs);
        this.addA(p, "Signature", "SHA512withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA512withRSA", attrs);
        this.addA(p, "Signature", "SHA512/224withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA512_224withRSA", attrs);
        this.addA(p, "Signature", "SHA512/256withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA512_256withRSA", attrs);
        this.addA(p, "Signature", "SHA3-224withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA3_224withRSA", attrs);
        this.addA(p, "Signature", "SHA3-256withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA3_256withRSA", attrs);
        this.addA(p, "Signature", "SHA3-384withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA3_384withRSA", attrs);
        this.addA(p, "Signature", "SHA3-512withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA3_512withRSA", attrs);
        this.addA(p, "KeyFactory", "RSASSA-PSS", "com.tencent.kona.sun.security.rsa.RSAKeyFactory$PSS", attrs);
        this.addA(p, "KeyPairGenerator", "RSASSA-PSS", "com.tencent.kona.sun.security.rsa.RSAKeyPairGenerator$PSS", attrs);
        this.addA(p, "Signature", "RSASSA-PSS", "com.tencent.kona.sun.security.rsa.RSAPSSSignature", attrs);
        this.addA(p, "AlgorithmParameters", "RSASSA-PSS", "com.tencent.kona.sun.security.rsa.PSSParameters", null);
    }

    public Iterator<Provider.Service> iterator() {
        return this.services.iterator();
    }

    public static void putEntries(Provider p) {
        p.put("SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        p.put("KeyFactory.RSA", "com.tencent.kona.sun.security.rsa.RSAKeyFactory$Legacy");
        p.put("KeyPairGenerator.RSA", "com.tencent.kona.sun.security.rsa.RSAKeyPairGenerator$Legacy");
        p.put("Signature.MD2withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$MD2withRSA");
        p.put("Signature.MD5withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$MD5withRSA");
        p.put("Signature.SHA1withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA1withRSA");
        p.put("Signature.SHA224withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA224withRSA");
        p.put("Signature.SHA256withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA256withRSA");
        p.put("Signature.SHA384withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA384withRSA");
        p.put("Signature.SHA512withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA512withRSA");
        p.put("Signature.SHA512/224withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA512_224withRSA");
        p.put("Signature.SHA512/256withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA512_256withRSA");
        p.put("Signature.SHA3-224withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA3_224withRSA");
        p.put("Signature.SHA3-256withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA3_256withRSA");
        p.put("Signature.SHA3-384withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA3_384withRSA");
        p.put("Signature.SHA3-512withRSA", "com.tencent.kona.sun.security.rsa.RSASignature$SHA3_512withRSA");
        p.put("KeyFactory.RSASSA-PSS", "com.tencent.kona.sun.security.rsa.RSAKeyFactory$PSS");
        p.put("KeyPairGenerator.RSASSA-PSS", "com.tencent.kona.sun.security.rsa.RSAKeyPairGenerator$PSS");
        p.put("Signature.RSASSA-PSS", "com.tencent.kona.sun.security.rsa.RSAPSSSignature");
        p.put("AlgorithmParameters.RSASSA-PSS", "com.tencent.kona.sun.security.rsa.PSSParameters");
    }
}

