/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ec;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.crypto.spec.RFC5915EncodedKeySpec;
import com.tencent.kona.jdk.internal.misc.SharedSecretsUtil;
import com.tencent.kona.sun.security.util.ArrayUtil;
import com.tencent.kona.sun.security.util.CurveDB;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.ECParameters;
import com.tencent.kona.sun.security.util.ECUtil;
import com.tencent.kona.sun.security.util.Oid;
import com.tencent.kona.sun.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;

public final class RFC5915Key
implements ECPrivateKey {
    private AlgorithmId algid;
    private byte[] key;
    private byte[] encodedKey;
    private static final int V1 = 1;
    private BigInteger s;
    private byte[] arrayS;
    private ECParameterSpec params;
    private ECPoint pubPoint;

    RFC5915Key(byte[] input) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(input));
        this.parseKeyBits();
    }

    private void decode(InputStream is) throws InvalidKeyException {
        DerValue val = null;
        try {
            val = new DerValue(is);
            if (val.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            int version = val.data.getInteger();
            if (version != 1) {
                throw new InvalidKeyException("unknown version: " + version);
            }
            this.key = val.data.getOctetString();
            if (val.data.available() == 0) {
                return;
            }
            DerValue next = val.data.getDerValue();
            if (next.isContextSpecific((byte)0)) {
                this.algid = new AlgorithmId(AlgorithmId.EC_oid, next.data.getDerValue());
                AlgorithmParameters algParams = this.algid.getParameters();
                if (algParams == null) {
                    throw new InvalidKeyException("EC domain parameters must be encoded in the algorithm identifier");
                }
                try {
                    this.params = algParams.getParameterSpec(ECParameterSpec.class);
                }
                catch (InvalidParameterSpecException e) {
                    throw new InvalidKeyException("Invalid EC private key", e);
                }
                if (val.data.available() == 0) {
                    return;
                }
                next = val.data.getDerValue();
            }
            if (next.isContextSpecific((byte)1)) {
                this.pubPoint = ECUtil.decodePoint(next.data.getUnalignedBitString().toByteArray(), this.params.getCurve());
                if (val.data.available() == 0) {
                    return;
                }
            }
            try {
                throw new InvalidKeyException("Extra bytes");
            }
            catch (IOException e) {
                throw new InvalidKeyException("IOException : " + e.getMessage());
            }
        }
        finally {
            if (val != null) {
                val.clear();
            }
        }
    }

    RFC5915Key(BigInteger s, ECPoint pubPoint, ECParameterSpec params) throws InvalidKeyException {
        this.s = s;
        this.params = params;
        this.pubPoint = pubPoint;
        this.makeEncoding(s);
    }

    private void makeEncoding(BigInteger s) throws InvalidKeyException {
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(this.params));
        byte[] sArr = s.toByteArray();
        int numOctets = (this.params.getOrder().bitLength() + 7) / 8;
        this.key = new byte[numOctets];
        int inPos = Math.max(sArr.length - this.key.length, 0);
        int outPos = Math.max(this.key.length - sArr.length, 0);
        int length = Math.min(sArr.length, this.key.length);
        System.arraycopy(sArr, inPos, this.key, outPos, length);
        Arrays.fill(sArr, (byte)0);
    }

    RFC5915Key(byte[] s, ECPoint pubPoint, ECParameterSpec params) throws InvalidKeyException {
        this.arrayS = (byte[])s.clone();
        this.params = params;
        this.pubPoint = pubPoint;
        this.makeEncoding(s);
    }

    private void makeEncoding(byte[] s) throws InvalidKeyException {
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(this.params));
        this.key = (byte[])s.clone();
        ArrayUtil.reverse(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PrivateKey parseKey(byte[] encoded) throws IOException {
        try {
            RFC5915Key rawKey = new RFC5915Key(encoded);
            byte[] internal = rawKey.getEncodedInternal();
            RFC5915EncodedKeySpec rfc5915KeySpec = new RFC5915EncodedKeySpec(internal);
            PrivateKey result = null;
            try {
                result = CryptoInsts.getKeyFactory("EC").generatePrivate(rfc5915KeySpec);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                result = rawKey;
            }
            finally {
                if (result != rawKey) {
                    rawKey.clear();
                }
                SharedSecretsUtil.secSpecClearEncodedKeySpec(rfc5915KeySpec);
            }
            return result;
        }
        catch (InvalidKeyException e) {
            throw new IOException("corrupt private key", e);
        }
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.getEncodedInternal().clone();
    }

    @Override
    public String getFormat() {
        return "RFC5915";
    }

    private void parseKeyBits() throws InvalidKeyException {
        byte[] clonedKey = (byte[])this.key.clone();
        ArrayUtil.reverse(clonedKey);
        this.arrayS = clonedKey;
    }

    @Override
    public BigInteger getS() {
        if (this.s == null) {
            byte[] arrCopy = (byte[])this.arrayS.clone();
            ArrayUtil.reverse(arrCopy);
            this.s = new BigInteger(1, arrCopy);
            Arrays.fill(arrCopy, (byte)0);
        }
        return this.s;
    }

    public byte[] getArrayS() {
        if (this.arrayS == null) {
            this.arrayS = ECUtil.sArray(this.getS(), this.params);
        }
        return (byte[])this.arrayS.clone();
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    private synchronized byte[] getEncodedInternal() {
        if (this.encodedKey == null) {
            DerOutputStream tmp = new DerOutputStream();
            tmp.putInteger(1);
            tmp.putOctetString(this.key);
            if (this.algid != null) {
                DerOutputStream algidDer = new DerOutputStream();
                algidDer.putOID(Oid.of(CurveDB.lookup(this.params).getObjectId()));
                tmp.write(DerValue.createTag((byte)-128, true, (byte)0), algidDer);
            }
            if (this.pubPoint != null) {
                DerOutputStream pubPointDer = new DerOutputStream();
                pubPointDer.putBitString(ECUtil.encodePoint(this.pubPoint, this.params.getCurve()));
                tmp.write(DerValue.createTag((byte)-128, true, (byte)1), pubPointDer);
            }
            DerValue out = DerValue.wrap((byte)48, tmp);
            this.encodedKey = out.toByteArray();
            out.clear();
        }
        return this.encodedKey;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncodedInternal());
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            this.decode(stream);
        }
        catch (InvalidKeyException e) {
            throw new IOException("deserialized key is invalid: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RFC5915Key) {
            return MessageDigest.isEqual(this.getEncodedInternal(), ((RFC5915Key)object).getEncodedInternal());
        }
        if (object instanceof Key) {
            byte[] otherEncoded = ((Key)object).getEncoded();
            try {
                boolean bl = MessageDigest.isEqual(this.getEncodedInternal(), otherEncoded);
                return bl;
            }
            finally {
                if (otherEncoded != null) {
                    Arrays.fill(otherEncoded, (byte)0);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncodedInternal());
    }

    public void clear() {
        if (this.encodedKey != null) {
            Arrays.fill(this.encodedKey, (byte)0);
        }
        Arrays.fill(this.key, (byte)0);
    }
}

