/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.nativeImpl.DataWindow;
import com.tencent.kona.crypto.provider.nativeImpl.Mode;
import com.tencent.kona.crypto.provider.nativeImpl.NativeSM4;
import com.tencent.kona.crypto.provider.nativeImpl.Padding;
import com.tencent.kona.crypto.provider.nativeImpl.SM4Params;
import com.tencent.kona.crypto.provider.nativeImpl.SymmetricCipher;
import com.tencent.kona.crypto.util.RangeUtil;
import java.security.InvalidKeyException;
import javax.crypto.AEADBadTagException;

class SM4OneShotCrypt
extends SymmetricCipher {
    private boolean opChanged = false;
    private boolean decrypting = false;
    private SM4Params paramSpec;
    private byte[] key;
    private NativeSM4 sm4;
    private DataWindow gcmLastCipherBlock;

    SM4OneShotCrypt() {
    }

    @Override
    int getBlockSize() {
        return 16;
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, SM4Params paramSpec) throws InvalidKeyException {
        this.paramSpec = null;
        this.key = null;
        this.gcmLastCipherBlock = null;
        this.sm4 = null;
        if (!"SM4".equalsIgnoreCase(algorithm)) {
            throw new InvalidKeyException("Wrong algorithm: expected SM4, actual: " + algorithm);
        }
        if (key.length != 16) {
            throw new InvalidKeyException("Wrong key size: expected 16-byte, actual " + key.length);
        }
        this.opChanged = this.decrypting != decrypting;
        this.decrypting = decrypting;
        this.paramSpec = paramSpec;
        this.key = key;
        this.init();
    }

    private void init() {
        Mode mode = this.paramSpec.mode();
        boolean padding = this.paramSpec.padding() == Padding.PKCS7Padding;
        byte[] iv = this.paramSpec.iv();
        switch (mode) {
            case ECB: {
                this.sm4 = new NativeSM4.SM4ECB(!this.decrypting, padding, this.key);
                break;
            }
            case CBC: {
                this.sm4 = new NativeSM4.SM4CBC(!this.decrypting, padding, this.key, iv);
                break;
            }
            case GCM: {
                this.gcmLastCipherBlock = new DataWindow(16);
                if (this.sm4 == null || this.opChanged) {
                    this.sm4 = new NativeSM4.SM4GCM(!this.decrypting, this.key, iv);
                    break;
                }
                ((NativeSM4.SM4GCM)this.sm4).setIV(iv);
                break;
            }
            case CTR: {
                this.sm4 = new NativeSM4.SM4CTR(!this.decrypting, this.key, iv);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected mode: " + (Object)((Object)mode));
            }
        }
    }

    @Override
    SM4Params getParamSpec() {
        return this.paramSpec;
    }

    @Override
    void updateAAD(byte[] aad) {
        if (this.isMode(Mode.GCM)) {
            NativeSM4.SM4GCM sm4GCM = (NativeSM4.SM4GCM)this.sm4;
            sm4GCM.updateAAD(aad);
        }
    }

    @Override
    byte[] encryptBlock(byte[] plaintext, int offset, int length) {
        return this.update(plaintext, offset, length);
    }

    @Override
    byte[] decryptBlock(byte[] ciphertext, int offset, int length) {
        byte[] bufCiphertext = ciphertext;
        int bufOffset = offset;
        int bufLength = length;
        if (this.isMode(Mode.GCM)) {
            bufCiphertext = this.gcmLastCipherBlock.put(bufCiphertext, bufOffset, bufLength);
            bufOffset = 0;
            bufLength = bufCiphertext.length;
        }
        return this.update(bufCiphertext, bufOffset, bufLength);
    }

    private byte[] update(byte[] input, int offset, int length) {
        RangeUtil.nullAndBoundsCheck(input, offset, length);
        byte[] data = CryptoUtils.copy(input, offset, length);
        if (this.sm4 instanceof NativeSM4.SM4ECB) {
            NativeSM4.SM4ECB sm4ecb = (NativeSM4.SM4ECB)this.sm4;
            return sm4ecb.update(data);
        }
        if (this.sm4 instanceof NativeSM4.SM4CBC) {
            NativeSM4.SM4CBC sm4cbc = (NativeSM4.SM4CBC)this.sm4;
            return sm4cbc.update(data);
        }
        if (this.sm4 instanceof NativeSM4.SM4GCM) {
            NativeSM4.SM4GCM sm4gcm = (NativeSM4.SM4GCM)this.sm4;
            return sm4gcm.update(data);
        }
        if (this.sm4 instanceof NativeSM4.SM4CTR) {
            NativeSM4.SM4CTR sm4ctr = (NativeSM4.SM4CTR)this.sm4;
            return sm4ctr.update(data);
        }
        throw new IllegalStateException("Unexpected SM4: " + this.sm4.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] encryptBlockFinal(byte[] plaintext, int offset, int length) {
        try {
            byte[] byArray = this.doFinal(plaintext, offset, length);
            return byArray;
        }
        finally {
            this.sm4.close();
            this.sm4 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] decryptBlockFinal(byte[] ciphertext, int offset, int length) {
        try {
            byte[] byArray = this.doFinal(ciphertext, offset, length);
            return byArray;
        }
        finally {
            this.sm4.close();
            this.sm4 = null;
        }
    }

    private byte[] doFinal(byte[] input, int offset, int length) {
        byte[] updateOut;
        RangeUtil.nullAndBoundsCheck(input, offset, length);
        byte[] data = CryptoUtils.copy(input, offset, length);
        byte[] finalOut = new byte[]{};
        if (this.sm4 instanceof NativeSM4.SM4ECB) {
            NativeSM4.SM4ECB sm4ecb = (NativeSM4.SM4ECB)this.sm4;
            updateOut = sm4ecb.update(data);
            finalOut = sm4ecb.doFinal();
        } else if (this.sm4 instanceof NativeSM4.SM4CBC) {
            NativeSM4.SM4CBC sm4cbc = (NativeSM4.SM4CBC)this.sm4;
            updateOut = sm4cbc.update(data);
            finalOut = sm4cbc.doFinal();
        } else if (this.sm4 instanceof NativeSM4.SM4GCM) {
            NativeSM4.SM4GCM sm4gcm = (NativeSM4.SM4GCM)this.sm4;
            if (!this.decrypting) {
                updateOut = sm4gcm.update(data);
                sm4gcm.doFinal();
                finalOut = sm4gcm.getTag();
            } else {
                byte[] finalCiphertext = this.gcmLastCipherBlock.put(data);
                updateOut = sm4gcm.update(finalCiphertext);
                byte[] tag = this.gcmLastCipherBlock.data();
                if (tag.length != 16) {
                    throw new IllegalStateException(new AEADBadTagException(String.format("The tag must be %s-bytes: %d", 16, tag.length)));
                }
                sm4gcm.setTag(tag);
                sm4gcm.doFinal();
            }
        } else if (this.sm4 instanceof NativeSM4.SM4CTR) {
            NativeSM4.SM4CTR sm4ctr = (NativeSM4.SM4CTR)this.sm4;
            updateOut = sm4ctr.update(data);
            sm4ctr.doFinal();
        } else {
            throw new IllegalStateException("Unexpected SM4: " + this.sm4.getClass());
        }
        return CryptoUtils.concat(updateOut, finalOut);
    }

    private boolean isMode(Mode mode) {
        return this.getParamSpec().mode() == mode;
    }
}

