/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.ByteArrayWriter;
import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.jdk.internal.util.Preconditions;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public final class SM3OneShotHMac
extends MacSpi
implements Cloneable {
    private final ByteArrayWriter buffer = new ByteArrayWriter();
    private byte[] key;

    @Override
    protected int engineGetMacLength() {
        return 32;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.key = null;
        this.buffer.reset();
        if (params != null) {
            throw new InvalidAlgorithmParameterException("No need parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("SecretKey is expected");
        }
        byte[] secret = key.getEncoded();
        if (secret == null) {
            throw new InvalidKeyException("No key data");
        }
        this.key = secret;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.buffer.write(new byte[]{input});
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (len == 0) {
            return;
        }
        Preconditions.checkFromIndexSize(offset, len, input.length, Preconditions.AIOOBE_FORMATTER);
        this.buffer.write(input, offset, len);
    }

    @Override
    protected byte[] engineDoFinal() {
        byte[] mac = NativeCrypto.sm3hmacOneShotMac(this.key, this.buffer.toByteArray());
        this.buffer.reset();
        return mac;
    }

    @Override
    protected void engineReset() {
        this.buffer.reset();
    }

    @Override
    public SM3OneShotHMac clone() throws CloneNotSupportedException {
        SM3OneShotHMac clone = new SM3OneShotHMac();
        clone.key = this.key == null ? null : (byte[])this.key.clone();
        clone.buffer.write(this.buffer.toByteArray());
        return clone;
    }
}

