/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.util.NamedCurve;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class SM2OneShotKeyPairGenerator
extends KeyPairGenerator {
    public SM2OneShotKeyPairGenerator() {
        super("SM2");
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        if (keySize != 256) {
            throw new IllegalArgumentException("keySize must be 256-bit: " + keySize);
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) {
        if (params == null || !(params instanceof SM2ParameterSpec) && !KnownOIDs.curveSM2.value().equals(((NamedCurve)params).getObjectId())) {
            throw new IllegalArgumentException("params must be SM2ParameterSpec or NamedCurve (curveSM2)");
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        byte[] keyPair = NativeCrypto.sm2OneShotKeyPairGenGenKeyPair();
        SM2PrivateKey priKey = new SM2PrivateKey(CryptoUtils.copy(keyPair, 0, 32));
        SM2PublicKey pubKey = new SM2PublicKey(CryptoUtils.copy(keyPair, 32, 65));
        return new KeyPair(pubKey, priKey);
    }
}

