/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.provider.nativeImpl.NativeRef;
import com.tencent.kona.crypto.util.Sweeper;
import java.util.Objects;

final class NativeSM3HMac
extends NativeRef
implements Cloneable {
    private static final Sweeper SWEEPER = Sweeper.instance();

    public NativeSM3HMac(byte[] key) {
        super(NativeSM3HMac.createCtx(key));
    }

    private static long createCtx(byte[] key) {
        if (key == null || key.length == 0) {
            throw new IllegalStateException("Key must not be null or empty");
        }
        return NativeCrypto.nativeCrypto().sm3hmacCreateCtx(key);
    }

    public NativeSM3HMac(long pointer) {
        super(pointer);
    }

    public void update(byte[] data) {
        Objects.requireNonNull(data);
        if (this.pointer == 0L || NativeCrypto.nativeCrypto().sm3hmacUpdate(this.pointer, data) != 1) {
            throw new IllegalStateException("SM3Hmac update operation failed");
        }
    }

    public byte[] doFinal() {
        byte[] result;
        byte[] byArray = result = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm3hmacFinal(this.pointer);
        if (result == null) {
            throw new IllegalStateException("SM3Hmac final operation failed");
        }
        return result;
    }

    public byte[] doFinal(byte[] data) {
        this.update(data);
        return this.doFinal();
    }

    @Override
    public void close() {
        if (this.pointer != 0L) {
            NativeCrypto.nativeCrypto().sm3hmacFreeCtx(this.pointer);
            super.close();
        }
    }

    public void reset() {
        if (this.pointer == 0L || NativeCrypto.nativeCrypto().sm3hmacReset(this.pointer) != 1) {
            throw new IllegalStateException("SM3Hmac reset operation failed");
        }
    }

    protected NativeSM3HMac clone() {
        if (this.pointer == 0L) {
            throw new IllegalStateException("Cannot clone closed SM3Hmac instance");
        }
        long clonePointer = NativeCrypto.nativeCrypto().sm3hmacClone(this.pointer);
        if (clonePointer == 0L) {
            throw new IllegalStateException("SM3Hmac clone operation failed");
        }
        return new NativeSM3HMac(clonePointer);
    }
}

