/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.provider.nativeImpl.NativeRef;
import javax.crypto.BadPaddingException;

final class NativeSM2Cipher
extends NativeRef {
    NativeSM2Cipher(byte[] key) {
        super(NativeSM2Cipher.createCtx(key));
    }

    private static long createCtx(byte[] key) {
        NativeSM2Cipher.checkKey(key);
        return NativeCrypto.nativeCrypto().sm2CipherCreateCtx(key);
    }

    private static void checkKey(byte[] key) {
        if (key == null || key.length != 32 && key.length != 65 && key.length != 97) {
            throw new IllegalStateException("Illegal key");
        }
    }

    public byte[] encrypt(byte[] plaintext) throws BadPaddingException {
        byte[] ciphertext;
        if (plaintext == null || plaintext.length == 0) {
            throw new BadPaddingException("Invalid plaintext");
        }
        byte[] byArray = ciphertext = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm2CipherEncrypt(this.pointer, plaintext);
        if (ciphertext == null) {
            throw new BadPaddingException("Encrypt failed");
        }
        return ciphertext;
    }

    public byte[] decrypt(byte[] ciphertext) throws BadPaddingException {
        byte[] cleartext;
        if (ciphertext == null || ciphertext.length == 0) {
            throw new BadPaddingException("Invalid ciphertext");
        }
        byte[] byArray = cleartext = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm2CipherDecrypt(this.pointer, ciphertext);
        if (cleartext == null) {
            throw new BadPaddingException("Decrypt failed");
        }
        return cleartext;
    }

    @Override
    public void close() {
        if (this.pointer != 0L) {
            NativeCrypto.nativeCrypto().sm2CipherFreeCtx(this.pointer);
            super.close();
        }
    }
}

