/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.util.Constants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;

final class NativeCrypto {
    private static final String OPENSSL_CRYPTO_LIB = CryptoUtils.privilegedGetProperty("com.tencent.kona.openssl.crypto.lib.path");
    private static final String KONA_CRYPTO_LIB = CryptoUtils.privilegedGetProperty("com.tencent.kona.crypto.lib.path");
    static final int OPENSSL_SUCCESS = 1;
    static final int OPENSSL_FAILURE = 0;

    private static void loadLibs() {
        NativeCrypto.loadLib("OpenSSLCrypto", OPENSSL_CRYPTO_LIB);
        NativeCrypto.loadLib("KonaCrypto", KONA_CRYPTO_LIB);
    }

    private static void loadLib(String libName, String libPath) {
        if (libPath != null && !libPath.isEmpty()) {
            NativeCrypto.systemLoad(libPath);
        } else {
            NativeCrypto.loadLibFromJar(libName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadLibFromJar(String libName) {
        String libFileName = NativeCrypto.getNativeLibFileName(libName);
        if (libFileName == null) {
            throw new RuntimeException(libName + " lib is not found for this platform");
        }
        Path tempLibDir = null;
        try {
            tempLibDir = Files.createTempDirectory("TencentKona-" + libName, new FileAttribute[0]);
            NativeCrypto.loadLibFromTempDir(tempLibDir, libFileName);
            if (tempLibDir == null) return;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Loaded lib failed: " + libName, e);
            }
            catch (Throwable throwable) {
                if (tempLibDir == null) throw throwable;
                try {
                    Files.walk(tempLibDir, new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
                    Files.deleteIfExists(tempLibDir);
                    throw throwable;
                }
                catch (IOException e2) {
                    System.out.println("Cannot delete temp native lib dir: " + tempLibDir);
                    e2.printStackTrace(System.out);
                }
                throw throwable;
            }
        }
        try {
            Files.walk(tempLibDir, new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
            Files.deleteIfExists(tempLibDir);
            return;
        }
        catch (IOException e) {
            System.out.println("Cannot delete temp native lib dir: " + tempLibDir);
            e.printStackTrace(System.out);
            return;
        }
    }

    private static void loadLibFromTempDir(Path tempLibDir, String libFileName) throws PrivilegedActionException {
        String libFilePath = AccessController.doPrivileged(() -> {
            Path tempLibPath = tempLibDir.resolve(libFileName);
            NativeCrypto.copyNativeLib(libFileName, tempLibPath);
            return tempLibPath.toAbsolutePath().toString();
        });
        NativeCrypto.systemLoad(libFilePath);
    }

    private static void systemLoad(String libFilePath) {
        Path bufPath = Paths.get(libFilePath, new String[0]);
        if (!Files.exists(bufPath, new LinkOption[0]) || !Files.isRegularFile(bufPath, new LinkOption[0])) {
            throw new RuntimeException("Lib file is not found: " + libFilePath);
        }
        System.load(libFilePath);
    }

    private static String getNativeLibFileName(String libName) {
        String platform = null;
        String ext = null;
        if (CryptoUtils.isX64()) {
            if (CryptoUtils.isMac()) {
                platform = "macos-x86_64";
                ext = ".dylib";
            } else if (CryptoUtils.isLinux()) {
                platform = "linux-x86_64";
                ext = ".so";
            }
        } else if (CryptoUtils.isArm64()) {
            if (CryptoUtils.isMac()) {
                platform = "macos-aarch64";
                ext = ".dylib";
            }
            if (CryptoUtils.isLinux()) {
                platform = "linux-aarch64";
                ext = ".so";
            }
        }
        if (platform == null) {
            return null;
        }
        return "lib" + libName + "-" + platform + ext;
    }

    private static void copyNativeLib(String libName, Path libPath) throws IOException {
        try (InputStream is = NativeCrypto.class.getResourceAsStream("/" + libName);
             OutputStream os = Files.newOutputStream(libPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            byte[] buffer = new byte[16384];
            int len = is.read(buffer);
            while (len >= 0) {
                os.write(buffer, 0, len);
                len = is.read(buffer);
            }
        }
    }

    static NativeCrypto nativeCrypto() {
        return InstanceHolder.INSTANCE;
    }

    private NativeCrypto() {
    }

    native long sm3CreateCtx();

    native void sm3FreeCtx(long var1);

    native int sm3Update(long var1, byte[] var3);

    native byte[] sm3Final(long var1);

    native int sm3Reset(long var1);

    native long sm3Clone(long var1);

    static native byte[] sm3OneShotDigest(byte[] var0);

    native long sm3hmacCreateCtx(byte[] var1);

    native void sm3hmacFreeCtx(long var1);

    native int sm3hmacUpdate(long var1, byte[] var3);

    native byte[] sm3hmacFinal(long var1);

    native int sm3hmacReset(long var1);

    native long sm3hmacClone(long var1);

    static native byte[] sm3hmacOneShotMac(byte[] var0, byte[] var1);

    native long sm4CreateCtx(boolean var1, String var2, boolean var3, byte[] var4, byte[] var5);

    native void sm4FreeCtx(long var1);

    native byte[] sm4Update(long var1, byte[] var3);

    native byte[] sm4Final(long var1, byte[] var3, byte[] var4);

    native int sm4GCMSetIV(long var1, byte[] var3);

    native int sm4GCMUpdateAAD(long var1, byte[] var3);

    native int sm4GCMProcTag(long var1, byte[] var3);

    static native byte[] sm2ToUncompPubKey(byte[] var0);

    static native byte[] sm2GenPubKey(byte[] var0);

    static native int sm2ValidatePoint(byte[] var0);

    native long sm2KeyPairGenCreateCtx();

    native void sm2KeyPairGenFreeCtx(long var1);

    native byte[] sm2KeyPairGenGenKeyPair(long var1);

    static native byte[] sm2OneShotKeyPairGenGenKeyPair();

    native long sm2CipherCreateCtx(byte[] var1);

    native void sm2CipherFreeCtx(long var1);

    native byte[] sm2CipherEncrypt(long var1, byte[] var3);

    native byte[] sm2CipherDecrypt(long var1, byte[] var3);

    static native byte[] sm2OneShotCipherEncrypt(byte[] var0, byte[] var1);

    static native byte[] sm2OneShotCipherDecrypt(byte[] var0, byte[] var1);

    native long sm2SignatureCreateCtx(byte[] var1, byte[] var2, boolean var3);

    native void sm2SignatureFreeCtx(long var1);

    native byte[] sm2SignatureSign(long var1, byte[] var3);

    native int sm2SignatureVerify(long var1, byte[] var3, byte[] var4);

    static native byte[] sm2OneShotSignatureSign(byte[] var0, byte[] var1, byte[] var2);

    static native int sm2OneShotSignatureVerify(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    native long sm2KeyExCreateCtx();

    native void sm2KeyExFreeCtx(long var1);

    native byte[] sm2DeriveKey(long var1, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9, boolean var10, int var11);

    static native byte[] sm2OneShotDeriveKey(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, boolean var7, int var8);

    static Object[] ecOneShotKeyPairGenGenKeyPair(int curveNID) {
        int priKeySize = Constants.getPrivateKeySize(curveNID);
        byte[] priKey = new byte[priKeySize];
        byte[] pubKey = new byte[priKeySize * 2 + 1];
        NativeCrypto.ecOneShotKeyPairGenGenKeyPair(curveNID, priKey, pubKey);
        return new Object[]{priKey, pubKey};
    }

    static Object[] ecKeyPairGenGenKeyPair(long pointer, int curveNID) {
        int priKeySize = Constants.getPrivateKeySize(curveNID);
        byte[] priKey = new byte[priKeySize];
        byte[] pubKey = new byte[priKeySize * 2 + 1];
        NativeCrypto.ecKeyPairGenGenKeyPair(pointer, priKey, pubKey);
        return new Object[]{priKey, pubKey};
    }

    static native void ecOneShotKeyPairGenGenKeyPair(int var0, byte[] var1, byte[] var2);

    static native long ecKeyPairGenCreateCtx(int var0);

    static native void ecKeyPairGenFreeCtx(long var0);

    static native void ecKeyPairGenGenKeyPair(long var0, byte[] var2, byte[] var3);

    static native long ecdsaCreateCtx(int var0, int var1, byte[] var2, boolean var3);

    static native void ecdsaFreeCtx(long var0);

    static native byte[] ecdsaSign(long var0, byte[] var2);

    static native int ecdsaVerify(long var0, byte[] var2, byte[] var3);

    static native byte[] ecdsaOneShotSign(int var0, int var1, byte[] var2, byte[] var3);

    static native int ecdsaOneShotVerify(int var0, int var1, byte[] var2, byte[] var3, byte[] var4);

    static native long ecdhCreateCtx(int var0, byte[] var1);

    static native void ecdhFreeCtx(long var0);

    static native byte[] ecdhDeriveKey(long var0, byte[] var2);

    static native byte[] ecdhOneShotDeriveKey(int var0, byte[] var1, byte[] var2);

    static {
        NativeCrypto.loadLibs();
    }

    private static class InstanceHolder {
        private static final NativeCrypto INSTANCE = new NativeCrypto();

        private InstanceHolder() {
        }
    }
}

