/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.CryptoUtils;
import java.util.Arrays;

class DataWindow {
    private byte[] window;
    private int offset = 0;

    DataWindow(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size must not be negative");
        }
        this.window = new byte[size];
    }

    byte[] put(byte[] src, int srcOffset, int srcLen) {
        this.checkRange(src, srcOffset, srcLen);
        byte[] excluded = new byte[]{};
        if (this.space() >= srcLen) {
            System.arraycopy(src, srcOffset, this.window, this.offset, srcLen);
            this.offset += srcLen;
        } else {
            int size = this.dataSize();
            int totalSize = size + srcLen;
            int excludedSize = totalSize - this.windowSize();
            int evictedSize = Math.min(excludedSize, size);
            excluded = new byte[excludedSize];
            System.arraycopy(this.window, 0, excluded, 0, evictedSize);
            if (evictedSize < excludedSize) {
                System.arraycopy(src, srcOffset, excluded, evictedSize, excludedSize - evictedSize);
            }
            byte[] tempWindow = new byte[this.windowSize()];
            System.arraycopy(this.window, evictedSize, tempWindow, 0, size - evictedSize);
            int srcLastPartSize = this.windowSize() - size + evictedSize;
            System.arraycopy(src, srcOffset + srcLen - srcLastPartSize, tempWindow, size - evictedSize, srcLastPartSize);
            this.offset = this.windowSize();
            this.window = tempWindow;
        }
        return excluded;
    }

    byte[] put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    private void checkRange(byte[] src, int srcOffset, int srcLen) {
        if (src.length < srcOffset + srcLen) {
            throw new ArrayIndexOutOfBoundsException("src.length < srcOffset + srcLength");
        }
    }

    byte[] data() {
        return CryptoUtils.copy(this.window, 0, this.dataSize());
    }

    int space() {
        return this.windowSize() - this.dataSize();
    }

    boolean moreSpace() {
        return this.space() > 0;
    }

    int dataSize() {
        return this.offset;
    }

    int windowSize() {
        return this.window.length;
    }

    void reset() {
        Arrays.fill(this.window, (byte)0);
        this.offset = 0;
    }
}

