/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.sun.security.jca.JCAUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class SM3HMacKeyGenerator
extends KeyGeneratorSpi {
    private int keySize = 32;
    private SecureRandom random;

    @Override
    protected void engineInit(SecureRandom random) {
        this.random = random;
        this.keySize = 32;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No parameter is needed");
    }

    @Override
    protected void engineInit(int keySize, SecureRandom random) {
        if (keySize < 128) {
            throw new InvalidParameterException("Key size must be 128-bits at least");
        }
        this.keySize = keySize + 7 >> 3;
        this.random = random;
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        byte[] key = new byte[this.keySize];
        this.random.nextBytes(key);
        return new SecretKeySpec(key, "SM3HMac");
    }
}

