/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.spec.SM2PrivateKeySpec;
import com.tencent.kona.crypto.spec.SM2PublicKeySpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public final class SM2KeyFactory
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof SM2PublicKeySpec)) {
            throw new InvalidKeySpecException("Only accept SM2PublicKeySpec");
        }
        SM2PublicKeySpec spec = (SM2PublicKeySpec)keySpec;
        ECPoint pubPoint = spec.getW();
        if (pubPoint == null || pubPoint.getAffineX() == null || pubPoint.getAffineY() == null) {
            throw new InvalidKeySpecException("No public key");
        }
        return new SM2PublicKey(pubPoint);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof SM2PrivateKeySpec)) {
            throw new InvalidKeySpecException("Only accept SM2PrivateKeySpec");
        }
        SM2PrivateKeySpec spec = (SM2PrivateKeySpec)keySpec;
        BigInteger keyS = spec.getS();
        if (keyS == null) {
            throw new InvalidKeySpecException("No private key");
        }
        return new SM2PrivateKey(keyS);
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpecClass) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException(e);
        }
        if (key instanceof ECPrivateKey) {
            if (keySpecClass.isAssignableFrom(SM2PrivateKeySpec.class)) {
                ECPrivateKey privateKey = (ECPrivateKey)key;
                return (T)((KeySpec)keySpecClass.cast(new SM2PrivateKeySpec(privateKey.getS())));
            }
            throw new InvalidKeySpecException("keySpecClass must be SM2PrivateKeySpec for SM2 private key");
        }
        if (key instanceof ECPublicKey) {
            if (keySpecClass.isAssignableFrom(SM2PublicKeySpec.class)) {
                ECPublicKey publicKey = (ECPublicKey)key;
                return (T)((KeySpec)keySpecClass.cast(new SM2PublicKeySpec(publicKey.getW())));
            }
            throw new InvalidKeySpecException("keySpecClass must be SM2PublicKeySpec for SM2 public key");
        }
        throw new InvalidKeySpecException("Neither public nor private key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ECPrivateKey) {
            return new SM2PrivateKey(((ECPrivateKey)key).getS());
        }
        if (key instanceof ECPublicKey) {
            return new SM2PublicKey(((ECPublicKey)key).getW());
        }
        throw new InvalidKeyException("key must be ECPrivateKey or ECPublicKey");
    }
}

