/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.provider.ConstructKeys;
import com.tencent.kona.crypto.provider.SM2Engine;
import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.sun.security.jca.JCAUtil;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class SM2Cipher
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private final SM2Engine engine = new SM2Engine();
    private final Buffer buffer = new Buffer();

    @Override
    public void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("none")) {
            throw new NoSuchAlgorithmException("Mode must be none");
        }
    }

    @Override
    public void engineSetPadding(String paddingName) throws NoSuchPaddingException {
        if (!paddingName.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Padding must be NoPadding");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        SecureRandom rand;
        this.buffer.reset();
        SecureRandom secureRandom = rand = random != null ? random : JCAUtil.getSecureRandom();
        if (opmode == 1 || opmode == 3) {
            if (!(key instanceof ECPublicKey)) throw new InvalidKeyException("Only accept ECPublicKey for encryption");
            SM2PublicKey publicKey = new SM2PublicKey((ECPublicKey)key);
            this.engine.init(true, publicKey, rand);
            return;
        } else {
            if (opmode != 2 && opmode != 4) return;
            if (!(key instanceof ECPrivateKey)) throw new InvalidKeyException("Only accept ECPrivateKey for decryption");
            SM2PrivateKey privateKey = new SM2PrivateKey((ECPrivateKey)key);
            BigInteger s = privateKey.getS();
            if (s.compareTo(BigInteger.ZERO) <= 0 || s.compareTo(SM2ParameterSpec.ORDER) >= 0) {
                throw new InvalidKeyException("The private key must be within the range [1, n - 1]");
            }
            this.engine.init(false, privateKey, rand);
        }
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Not need AlgorithmParameters");
        }
        this.engineInit(opmode, key, random);
    }

    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.buffer.write(input, inputOffset, inputLen);
        return B0;
    }

    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        this.buffer.write(input, inputOffset, inputLen);
        return 0;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        this.update(input, inputOffset, inputLen);
        return this.doFinal();
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int outputSize = this.engineGetOutputSize(this.buffer.size());
        if (outputSize > output.length - outputOffset) {
            throw new ShortBufferException("Need " + outputSize + " bytes for output");
        }
        this.update(input, inputOffset, inputLen);
        byte[] result = this.doFinal();
        int n = result.length;
        System.arraycopy(result, 0, output, outputOffset, n);
        Arrays.fill(result, (byte)0);
        return result.length;
    }

    @Override
    public byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("No encoded key");
        }
        try {
            byte[] byArray = this.engineDoFinal(encoded, 0, encoded.length);
            return byArray;
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Wrap key failed", e);
        }
        finally {
            Arrays.fill(encoded, (byte)0);
        }
    }

    @Override
    public Key engineUnwrap(byte[] wrappedKey, String algorithm, int type) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encoded;
        if (wrappedKey == null || wrappedKey.length == 0) {
            throw new InvalidKeyException("No wrapped key");
        }
        try {
            encoded = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeyException("Unwrap key failed", e);
        }
        return ConstructKeys.constructKey(encoded, algorithm, type);
    }

    private void update(byte[] input, int inputOffset, int inputLen) {
        if (input == null || inputLen == 0) {
            return;
        }
        this.buffer.write(input, inputOffset, inputLen);
    }

    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        try {
            byte[] input = this.buffer.toByteArray();
            byte[] byArray = this.engine.processBlock(input, 0, input.length);
            return byArray;
        }
        finally {
            this.buffer.reset();
        }
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    public byte[] engineGetIV() {
        return null;
    }

    @Override
    public int engineGetBlockSize() {
        return 0;
    }

    @Override
    public int engineGetOutputSize(int inputLen) {
        int offset = 97;
        return this.engine.encrypted() ? inputLen + offset : Math.max(0, inputLen - offset);
    }

    @Override
    public int engineGetKeySize(Key key) {
        return 256;
    }

    private static final class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        @Override
        public void reset() {
            Arrays.fill(this.buf, (byte)0);
            super.reset();
        }
    }
}

