/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.GFMultiplier;

class GFMultipliers {
    private static final long R = -2233785415175766016L;

    GFMultipliers() {
    }

    static GFMultiplier gfmWithoutPreTable(byte[] subkeyH) {
        return new GFMWithoutPreTable(subkeyH);
    }

    static GFMultiplier gfmWith32KPreTable(byte[] subkeyH) {
        return new GFMWith32KTable(subkeyH);
    }

    private static final class GFMWith32KTable
    extends GFMultiplier {
        private final long[][] table = this.preTable();

        GFMWith32KTable(byte[] subkeyH) {
            super(subkeyH);
        }

        private long[][] preTable() {
            long[][] table = new long[256][2];
            table[1][0] = this.subkeyWords[0];
            table[1][1] = this.subkeyWords[1];
            GFMWith32KTable.multiplyP7(table[1]);
            for (int i = 2; i < 256; i += 2) {
                GFMWith32KTable.divideP(table[i >> 1], table[i]);
                GFMWith32KTable.add(table[i], table[1], table[i + 1]);
            }
            return table;
        }

        private static void multiplyP7(long[] x) {
            long x0 = x[0];
            long x1 = x[1];
            long c = x1 << 57;
            x[0] = x0 >>> 7 ^ c ^ c >>> 1 ^ c >>> 2 ^ c >>> 7;
            x[1] = x1 >>> 7 | x0 << 57;
        }

        private static void divideP(long[] x, long[] z) {
            long x0 = x[0];
            long x1 = x[1];
            long m = x0 >> 63;
            z[0] = (x0 ^= m & 0xE100000000000000L) << 1 | x1 >>> 63;
            z[1] = x1 << 1 | -m;
        }

        private static void add(long[] x, long[] y, long[] z) {
            z[0] = x[0] ^ y[0];
            z[1] = x[1] ^ y[1];
        }

        @Override
        public void multiply(long[] block) {
            byte[] buf = new byte[16];
            CryptoUtils.longToBytes8(block[0], buf, 0);
            CryptoUtils.longToBytes8(block[1], buf, 8);
            long[] t = this.table[buf[15] & 0xFF];
            long z0 = t[0];
            long z1 = t[1];
            for (int i = 14; i >= 0; --i) {
                t = this.table[buf[i] & 0xFF];
                long c = z1 << 56;
                z1 = t[1] ^ (z1 >>> 8 | z0 << 56);
                z0 = t[0] ^ z0 >>> 8 ^ c ^ c >>> 1 ^ c >>> 2 ^ c >>> 7;
            }
            block[0] = z0;
            block[1] = z1;
        }
    }

    private static final class GFMWithoutPreTable
    extends GFMultiplier {
        private GFMWithoutPreTable(byte[] subkeyH) {
            super(subkeyH);
        }

        @Override
        public void multiply(long[] block) {
            long carry;
            long mask;
            int i;
            long Z0 = 0L;
            long Z1 = 0L;
            long V0 = this.subkeyWords[0];
            long V1 = this.subkeyWords[1];
            long X = block[0];
            for (i = 0; i < 64; ++i) {
                mask = X >> 63;
                Z0 ^= V0 & mask;
                Z1 ^= V1 & mask;
                mask = V1 << 63 >> 63;
                carry = V0 & 1L;
                V0 >>>= 1;
                V1 = V1 >>> 1 | carry << 63;
                V0 ^= 0xE100000000000000L & mask;
                X <<= 1;
            }
            X = block[1];
            for (i = 64; i < 127; ++i) {
                mask = X >> 63;
                Z0 ^= V0 & mask;
                Z1 ^= V1 & mask;
                mask = V1 << 63 >> 63;
                carry = V0 & 1L;
                V0 >>>= 1;
                V1 = V1 >>> 1 | carry << 63;
                V0 ^= 0xE100000000000000L & mask;
                X <<= 1;
            }
            long mask2 = X >> 63;
            block[0] = Z0 ^= V0 & mask2;
            block[1] = Z1 ^= V1 & mask2;
        }
    }
}

