/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.KonaCryptoNativeOneShotProvider;
import com.tencent.kona.crypto.KonaCryptoNativeProvider;
import com.tencent.kona.crypto.KonaCryptoProvider;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;

public class CryptoInsts {
    public static final Provider PROV = CryptoInsts.provider();
    private static final Set<String> ALGO_PARAMS_ALGOS = new HashSet<String>(Arrays.asList("EC", "SM4", "PBES2"));
    private static final Set<String> KEY_FACTORY_ALGOS = new HashSet<String>(Arrays.asList("EC", "SM2"));
    private static final Set<String> KEY_GEN_ALGOS = new HashSet<String>(Arrays.asList("SM4", "HmacSM3", "SM3HMac"));
    private static final Set<String> KEY_PAIR_GEN_ALGOS = new HashSet<String>(Arrays.asList("SM2"));
    private static final Set<String> CIPHER_ALGOS = new HashSet<String>(Arrays.asList("SM2", "SM4"));
    private static final Set<String> MESSAGE_DIGEST_ALGOS = new HashSet<String>(Collections.singletonList("SM3"));
    private static final Set<String> MAC_ALGOS = new HashSet<String>(Arrays.asList("HmacSM3", "SM3HMac"));
    private static final Set<String> SIGNATURE_ALGOS = new HashSet<String>(Arrays.asList("SM2", "SM3withSM2", "NONEwithECDSA", "SHA1withECDSA", "SHA224withECDSA", "SHA256withECDSA", "SHA384withECDSA", "SHA512withECDSA"));
    private static final Set<String> KEY_AGREEMENT_ALGOS = new HashSet<String>(Arrays.asList("SM2", "ECDH"));

    private static Provider provider() {
        String provName = CryptoUtils.defaultCrypto();
        if ("Native".equalsIgnoreCase(provName)) {
            return KonaCryptoNativeProvider.instance();
        }
        if ("NativeOneShot".equalsIgnoreCase(provName)) {
            return KonaCryptoNativeOneShotProvider.instance();
        }
        return KonaCryptoProvider.instance();
    }

    public static AlgorithmParameters getAlgorithmParameters(String algorithm) throws NoSuchAlgorithmException {
        AlgorithmParameters algoParams = null;
        algoParams = ALGO_PARAMS_ALGOS.contains(algorithm) ? AlgorithmParameters.getInstance(algorithm, PROV) : AlgorithmParameters.getInstance(algorithm);
        return algoParams;
    }

    public static KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        KeyFactory keyFactory = null;
        keyFactory = KEY_FACTORY_ALGOS.contains(algorithm) ? KeyFactory.getInstance(algorithm, PROV) : KeyFactory.getInstance(algorithm);
        return keyFactory;
    }

    public static KeyGenerator getKeyGenerator(String algorithm) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = null;
        keyGenerator = KEY_GEN_ALGOS.contains(algorithm) ? KeyGenerator.getInstance(algorithm, PROV) : KeyGenerator.getInstance(algorithm);
        return keyGenerator;
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm, Provider prov) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = null;
        keyPairGenerator = KEY_PAIR_GEN_ALGOS.contains(algorithm) ? KeyPairGenerator.getInstance(algorithm, prov) : KeyPairGenerator.getInstance(algorithm);
        return keyPairGenerator;
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException {
        return CryptoInsts.getKeyPairGenerator(algorithm, PROV);
    }

    public static Cipher getCipher(String algorithm, Provider prov) throws NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = null;
        cipher = CIPHER_ALGOS.contains(algorithm) ? Cipher.getInstance(algorithm, prov) : Cipher.getInstance(algorithm);
        return cipher;
    }

    public static Cipher getCipher(String algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException {
        return CryptoInsts.getCipher(algorithm, PROV);
    }

    public static MessageDigest getMessageDigest(String algorithm, Provider prov) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        messageDigest = MESSAGE_DIGEST_ALGOS.contains(algorithm) ? MessageDigest.getInstance(algorithm, prov) : MessageDigest.getInstance(algorithm);
        return messageDigest;
    }

    public static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        return CryptoInsts.getMessageDigest(algorithm, KonaCryptoProvider.instance());
    }

    public static Mac getMac(String algorithm, Provider prov) throws NoSuchAlgorithmException {
        Mac mac = null;
        mac = MAC_ALGOS.contains(algorithm) ? Mac.getInstance(algorithm, prov) : Mac.getInstance(algorithm);
        return mac;
    }

    public static Mac getMac(String algorithm) throws NoSuchAlgorithmException {
        return CryptoInsts.getMac(algorithm, KonaCryptoProvider.instance());
    }

    public static Signature getSignature(String algorithm, Provider prov) throws NoSuchAlgorithmException {
        Signature signature = null;
        signature = SIGNATURE_ALGOS.contains(algorithm) ? Signature.getInstance(algorithm, prov) : Signature.getInstance(algorithm);
        return signature;
    }

    public static Signature getSignature(String algorithm) throws NoSuchAlgorithmException {
        return CryptoInsts.getSignature(algorithm, PROV);
    }

    public static KeyAgreement getKeyAgreement(String algorithm, Provider prov) throws NoSuchAlgorithmException {
        KeyAgreement keyAgreement = null;
        keyAgreement = KEY_AGREEMENT_ALGOS.contains(algorithm) ? KeyAgreement.getInstance(algorithm, prov) : KeyAgreement.getInstance(algorithm);
        return keyAgreement;
    }

    public static KeyAgreement getKeyAgreement(String algorithm) throws NoSuchAlgorithmException {
        return CryptoInsts.getKeyAgreement(algorithm, PROV);
    }
}

