/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.generator.impl;

import com.mybatisflex.codegen.config.EntityConfig;
import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.config.PackageConfig;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.codegen.generator.IGenerator;
import com.mybatisflex.core.util.StringUtil;
import java.io.File;
import java.util.HashMap;

public class EntityGenerator
implements IGenerator {
    protected String templatePath;
    protected String entityWithBaseTemplatePath = "/templates/enjoy/entityWithBase.tpl";
    protected String ktEntityWithBaseTemplatePath = "/templates/enjoy/entityWithBase.kotlin.tpl";

    public EntityGenerator() {
        this("/templates/enjoy/entityOrBase.tpl");
    }

    public EntityGenerator(String templatePath) {
        this.templatePath = templatePath;
    }

    @Override
    public void generate(Table table, GlobalConfig globalConfig) {
        if (!globalConfig.isEntityGenerateEnable()) {
            return;
        }
        this.genEntityClass(table, globalConfig);
        this.genBaseClass(table, globalConfig);
    }

    protected void genEntityClass(Table table, GlobalConfig globalConfig) {
        PackageConfig packageConfig = globalConfig.getPackageConfig();
        EntityConfig entityConfig = globalConfig.getEntityConfig();
        String sourceDir = StringUtil.hasText((String)entityConfig.getSourceDir()) ? entityConfig.getSourceDir() : packageConfig.getSourceDir();
        String entityPackagePath = packageConfig.getEntityPackage().replace(".", "/");
        String entityClassName = table.buildEntityClassName();
        File entityJavaFile = new File(sourceDir, entityPackagePath + "/" + entityClassName + (Object)((Object)globalConfig.getFileType()));
        if (entityJavaFile.exists() && !entityConfig.isOverwriteEnable()) {
            return;
        }
        if (globalConfig.getStrategyConfig().getIgnoreColumns() != null) {
            table.getColumns().removeIf(column -> globalConfig.getStrategyConfig().getIgnoreColumns().contains(column.getName().toLowerCase()));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        params.put("table", table);
        params.put("entityPackageName", packageConfig.getEntityPackage());
        params.put("entityConfig", entityConfig);
        params.put("entityClassName", table.buildEntityClassName());
        params.put("packageConfig", packageConfig);
        params.put("javadocConfig", globalConfig.getJavadocConfig());
        params.put("isBase", false);
        params.putAll(globalConfig.getCustomConfig());
        String templatePath = this.templatePath;
        if (entityConfig.isWithBaseClassEnable()) {
            templatePath = globalConfig.getFileType() == GlobalConfig.FileType.KOTLIN ? this.ktEntityWithBaseTemplatePath : this.entityWithBaseTemplatePath;
            String baseClassName = table.buildEntityClassName() + entityConfig.getWithBaseClassSuffix();
            params.put("baseClassName", baseClassName);
            String baseClassPackage = StringUtil.hasText((String)entityConfig.getWithBasePackage()) ? entityConfig.getWithBasePackage() : packageConfig.getEntityPackage() + ".base";
            params.put("baseClassPackage", baseClassPackage);
            params.put("entityClassName", table.buildEntityClassName());
        }
        globalConfig.getTemplateConfig().getTemplate().generate(params, templatePath, entityJavaFile);
        System.out.println("Entity ---> " + entityJavaFile);
    }

    protected void genBaseClass(Table table, GlobalConfig globalConfig) {
        EntityConfig entityConfig = globalConfig.getEntityConfig();
        if (!entityConfig.isWithBaseClassEnable()) {
            return;
        }
        PackageConfig packageConfig = globalConfig.getPackageConfig();
        String sourceDir = StringUtil.hasText((String)entityConfig.getSourceDir()) ? entityConfig.getSourceDir() : packageConfig.getSourceDir();
        String baseEntityPackagePath = packageConfig.getEntityPackage().replace(".", "/");
        baseEntityPackagePath = StringUtil.hasText((String)entityConfig.getWithBasePackage()) ? entityConfig.getWithBasePackage().replace(".", "") : baseEntityPackagePath + "/base";
        String baseEntityClassName = table.buildEntityClassName() + entityConfig.getWithBaseClassSuffix();
        File baseEntityJavaFile = new File(sourceDir, baseEntityPackagePath + "/" + baseEntityClassName + (Object)((Object)globalConfig.getFileType()));
        if (baseEntityJavaFile.exists() && !entityConfig.isBaseOverwriteEnable()) {
            return;
        }
        if (globalConfig.getStrategyConfig().getIgnoreColumns() != null) {
            table.getColumns().removeIf(column -> globalConfig.getStrategyConfig().getIgnoreColumns().contains(column.getName().toLowerCase()));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", table);
        params.put("entityPackageName", baseEntityPackagePath.replace("/", "."));
        params.put("entityClassName", baseEntityClassName);
        params.put("entityConfig", entityConfig);
        params.put("packageConfig", packageConfig);
        params.put("javadocConfig", globalConfig.getJavadocConfig());
        params.put("isBase", true);
        params.putAll(globalConfig.getCustomConfig());
        globalConfig.getTemplateConfig().getTemplate().generate(params, this.templatePath, baseEntityJavaFile);
        System.out.println("BaseEntity ---> " + baseEntityJavaFile);
    }

    public String getEntityWithBaseTemplatePath() {
        return this.entityWithBaseTemplatePath;
    }

    public void setEntityWithBaseTemplatePath(String entityWithBaseTemplatePath) {
        this.entityWithBaseTemplatePath = entityWithBaseTemplatePath;
    }

    @Override
    public String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }
}

