/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.maxmind.db.MaxMindDbConstructor;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.db.Network;
import com.maxmind.geoip2.NetworkDeserializer;
import com.maxmind.geoip2.model.AbstractResponse;

public class ConnectionTypeResponse
extends AbstractResponse {
    private final ConnectionType connectionType;
    private final String ipAddress;
    private final Network network;

    ConnectionTypeResponse() {
        this(null, null);
    }

    @Deprecated
    public ConnectionTypeResponse(ConnectionType connectionType, String ipAddress) {
        this(connectionType, ipAddress, null);
    }

    public ConnectionTypeResponse(@JsonProperty(value="connection_type") ConnectionType connectionType, @JacksonInject(value="ip_address") @JsonProperty(value="ip_address") String ipAddress, @JacksonInject(value="network") @JsonProperty(value="network") @JsonDeserialize(using=NetworkDeserializer.class) Network network) {
        this.connectionType = connectionType;
        this.ipAddress = ipAddress;
        this.network = network;
    }

    @MaxMindDbConstructor
    public ConnectionTypeResponse(@MaxMindDbParameter(name="connection_type") String connectionType, @MaxMindDbParameter(name="ip_address") String ipAddress, @MaxMindDbParameter(name="network") Network network) {
        this(ConnectionType.fromString(connectionType), ipAddress, network);
    }

    public ConnectionTypeResponse(ConnectionTypeResponse response, String ipAddress, Network network) {
        this(response.getConnectionType(), ipAddress, network);
    }

    @JsonProperty(value="connection_type")
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty
    @JsonSerialize(using=ToStringSerializer.class)
    public Network getNetwork() {
        return this.network;
    }

    public static enum ConnectionType {
        DIALUP("Dialup"),
        CABLE_DSL("Cable/DSL"),
        CORPORATE("Corporate"),
        CELLULAR("Cellular");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        @JsonValue
        public String toString() {
            return this.name;
        }

        public static ConnectionType fromString(String s) {
            if (s == null) {
                return null;
            }
            switch (s) {
                case "Dialup": {
                    return DIALUP;
                }
                case "Cable/DSL": {
                    return CABLE_DSL;
                }
                case "Corporate": {
                    return CORPORATE;
                }
                case "Cellular": {
                    return CELLULAR;
                }
            }
            return null;
        }
    }
}

