/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class TestConfig {
    private String jsonData;

    public TestConfig(InputStream jsonFile) throws MojoExecutionException {
        try {
            this.jsonData = IOUtils.toString((InputStream)jsonFile, (Charset)Charset.forName("UTF-8"));
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    public TestConfig(File jsonFile) throws MojoExecutionException {
        try (FileReader jsonFileReader = new FileReader(jsonFile);){
            this.jsonData = IOUtils.toString((Reader)jsonFileReader);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    public String getFullConfig() {
        return this.jsonData;
    }

    public void writeResultFilesConfigTo(String configLocation) throws MojoExecutionException {
        try (FileWriter file = new FileWriter(configLocation);){
            file.write(this.jsonData);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    public void setResultsFileLocations(List<String> resultFileLocations) {
        this.jsonData = JsonPath.parse((String)this.jsonData).set("$.resultFilesLocations", resultFileLocations, new Predicate[0]).jsonString();
    }

    public List<String> getResultsFileLocations() {
        return (List)JsonPath.read((String)this.jsonData, (String)"$.resultFilesLocations", (Predicate[])new Predicate[0]);
    }

    public void setResultsOutputIsCSVFormat(boolean isCSVFormat) {
        this.jsonData = JsonPath.parse((String)this.jsonData).set("$.resultsOutputIsCSVFormat", (Object)isCSVFormat, new Predicate[0]).jsonString();
    }

    public boolean getResultsOutputIsCSVFormat() {
        return (Boolean)JsonPath.read((String)this.jsonData, (String)"$.resultsOutputIsCSVFormat", (Predicate[])new Predicate[0]);
    }

    public void setGenerateReports(boolean generateReports) {
        this.jsonData = JsonPath.parse((String)this.jsonData).set("$.generateReports", (Object)generateReports, new Predicate[0]).jsonString();
    }

    public boolean getGenerateReports() {
        return (Boolean)JsonPath.read((String)this.jsonData, (String)"$.generateReports", (Predicate[])new Predicate[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestConfig that = (TestConfig)o;
        return Objects.equals(this.jsonData, that.jsonData);
    }

    public int hashCode() {
        return Objects.hash(this.jsonData);
    }
}

