/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.colors;

import com.itextpdf.io.IOException;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class IccProfile
implements Serializable {
    private static final long serialVersionUID = -7466035855770591929L;
    protected byte[] data;
    protected int numComponents;
    private static Map<String, Integer> cstags = new HashMap<String, Integer>();

    protected IccProfile() {
    }

    public static IccProfile getInstance(byte[] data, int numComponents) {
        int nc;
        if (data.length < 128 || data[36] != 97 || data[37] != 99 || data[38] != 115 || data[39] != 112) {
            throw new IOException("Invalid ICC profile.");
        }
        IccProfile icc = new IccProfile();
        icc.data = data;
        Integer cs = IccProfile.getIccNumberOfComponents(data);
        icc.numComponents = nc = cs == null ? 0 : cs;
        if (nc != numComponents) {
            throw new IOException("ICC profile contains {0} components, while the image data contains {1} components.").setMessageParams(nc, numComponents);
        }
        return icc;
    }

    public static IccProfile getInstance(byte[] data) {
        Integer cs = IccProfile.getIccNumberOfComponents(data);
        int numComponents = cs == null ? 0 : cs;
        return IccProfile.getInstance(data, numComponents);
    }

    public static IccProfile getInstance(RandomAccessFileOrArray file) {
        try {
            byte[] head = new byte[128];
            int remain = head.length;
            int ptr = 0;
            while (remain > 0) {
                int n = file.read(head, ptr, remain);
                if (n < 0) {
                    throw new IOException("Invalid ICC profile.");
                }
                remain -= n;
                ptr += n;
            }
            if (head[36] != 97 || head[37] != 99 || head[38] != 115 || head[39] != 112) {
                throw new IOException("Invalid ICC profile.");
            }
            remain = (head[0] & 0xFF) << 24 | (head[1] & 0xFF) << 16 | (head[2] & 0xFF) << 8 | head[3] & 0xFF;
            byte[] icc = new byte[remain];
            System.arraycopy(head, 0, icc, 0, head.length);
            remain -= head.length;
            ptr = head.length;
            while (remain > 0) {
                int n = file.read(icc, ptr, remain);
                if (n < 0) {
                    throw new IOException("Invalid ICC profile.");
                }
                remain -= n;
                ptr += n;
            }
            return IccProfile.getInstance(icc);
        }
        catch (Exception ex) {
            throw new IOException("Invalid ICC profile.", ex);
        }
    }

    public static IccProfile getInstance(InputStream stream) {
        RandomAccessFileOrArray raf;
        try {
            raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(stream));
        }
        catch (java.io.IOException e) {
            throw new IOException("Invalid ICC profile.", e);
        }
        return IccProfile.getInstance(raf);
    }

    public static IccProfile getInstance(String filename) {
        RandomAccessFileOrArray raf;
        try {
            raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createBestSource(filename));
        }
        catch (java.io.IOException e) {
            throw new IOException("Invalid ICC profile.", e);
        }
        return IccProfile.getInstance(raf);
    }

    public static String getIccColorSpaceName(byte[] data) {
        String colorSpace;
        try {
            colorSpace = new String(data, 16, 4, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Invalid ICC profile.", e);
        }
        return colorSpace;
    }

    public static String getIccDeviceClass(byte[] data) {
        String deviceClass;
        try {
            deviceClass = new String(data, 12, 4, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Invalid ICC profile.", e);
        }
        return deviceClass;
    }

    public static Integer getIccNumberOfComponents(byte[] data) {
        return cstags.get(IccProfile.getIccColorSpaceName(data));
    }

    public byte[] getData() {
        return this.data;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    static {
        cstags.put("XYZ ", 3);
        cstags.put("Lab ", 3);
        cstags.put("Luv ", 3);
        cstags.put("YCbr", 3);
        cstags.put("Yxy ", 3);
        cstags.put("RGB ", 3);
        cstags.put("GRAY", 1);
        cstags.put("HSV ", 3);
        cstags.put("HLS ", 3);
        cstags.put("CMYK", 4);
        cstags.put("CMY ", 3);
        cstags.put("2CLR", 2);
        cstags.put("3CLR", 3);
        cstags.put("4CLR", 4);
        cstags.put("5CLR", 5);
        cstags.put("6CLR", 6);
        cstags.put("7CLR", 7);
        cstags.put("8CLR", 8);
        cstags.put("9CLR", 9);
        cstags.put("ACLR", 10);
        cstags.put("BCLR", 11);
        cstags.put("CCLR", 12);
        cstags.put("DCLR", 13);
        cstags.put("ECLR", 14);
        cstags.put("FCLR", 15);
    }
}

