/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.kotlin.visitor.AllPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinPropertyFilter;
import proguard.classfile.visitor.MemberVisitor;

public class MemberToKotlinPropertyVisitor
implements MemberVisitor {
    private final KotlinPropertyVisitor kotlinPropertyVisitor;

    public MemberToKotlinPropertyVisitor(KotlinPropertyVisitor kotlinPropertyVisitor) {
        this.kotlinPropertyVisitor = kotlinPropertyVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programClass.kotlinMetadataAccept(new AllPropertyVisitor(new KotlinPropertyFilter(prop -> prop.referencedBackingField == programField, this.kotlinPropertyVisitor)));
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        libraryClass.kotlinMetadataAccept(new AllPropertyVisitor(new KotlinPropertyFilter(prop -> prop.referencedBackingField == libraryField, this.kotlinPropertyVisitor)));
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programClass.kotlinMetadataAccept(new AllPropertyVisitor(new KotlinPropertyFilter(prop -> prop.referencedGetterMethod == programMethod || prop.referencedSetterMethod == programMethod, this.kotlinPropertyVisitor)));
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        libraryClass.kotlinMetadataAccept(new AllPropertyVisitor(new KotlinPropertyFilter(prop -> prop.referencedGetterMethod == libraryMethod || prop.referencedSetterMethod == libraryMethod, this.kotlinPropertyVisitor)));
    }
}

