/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.InstructionUsageMarker;
import proguard.optimize.info.ParameterUsageMarker;

public class EvaluationShrinker
implements AttributeVisitor,
ExceptionInfoVisitor {
    private static final Logger logger = LogManager.getLogger(EvaluationShrinker.class);
    private static final int UNSUPPORTED = -1;
    private static final int NOP = 0;
    private static final int POP = 87;
    private static final int POP2 = 88;
    private static final int DUP = 89;
    private static final int DUP_X1 = 90;
    private static final int DUP_X2 = 91;
    private static final int DUP2 = 92;
    private static final int DUP2_X1 = 93;
    private static final int DUP2_X2 = 94;
    private static final int SWAP = 95;
    private static final int MOV_X2 = 22363;
    private static final int MOV2_X1 = 22621;
    private static final int MOV2_X2 = 22622;
    private static final int POP_X1 = 22367;
    private static final int POP_X2 = 5724253;
    private static final int POP_X3 = -1;
    private static final int POP2_X1 = 5789531;
    private static final int POP2_X2 = 0x58585E;
    private static final int POP3 = 22360;
    private static final int POP4 = 22616;
    private static final int POP_DUP = 22871;
    private static final int POP_DUP_X1 = 23127;
    private static final int POP_SWAP = 24407;
    private static final int POP_SWAP_POP = 0x575F57;
    private static final int POP_SWAP_POP_DUP = 1498898263;
    private static final int POP2_SWAP_POP = 5726040;
    private static final int SWAP_DUP_X1 = 23135;
    private static final int SWAP_DUP_X1_POP3 = 1465408095;
    private static final int SWAP_DUP2_X1_POP3 = 1465408863;
    private static final int SWAP_DUP_X1_SWAP = 0x5F5A5F;
    private static final int SWAP_POP_DUP = 5855071;
    private static final int SWAP_POP_DUP_X1 = 5920607;
    private static final int DUP_X2_POP = 22363;
    private static final int DUP_X2_POP2 = 22619;
    private static final int DUP_X2_POP3_DUP = 1498961755;
    private static final int DUP2_X1_POP = 22365;
    private static final int DUP2_X1_POP3_DUP = 1498896477;
    private static final int DUP2_X1_POP3_DUP_X1 = 1515673693;
    private static final int DUP2_X1_POP3_DUP2 = 1549228125;
    private static final int DUP2_X2_POP3 = 5724254;
    private static final int DUP2_X2_SWAP_POP = 5726046;
    private final InstructionUsageMarker instructionUsageMarker;
    private final boolean runInstructionUsageMarker;
    private final InstructionVisitor extraDeletedInstructionVisitor;
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final MyStaticInvocationFixer staticInvocationFixer = new MyStaticInvocationFixer();
    private final MyBackwardBranchFixer backwardBranchFixer = new MyBackwardBranchFixer();
    private final MyNonReturningSubroutineFixer nonReturningSubroutineFixer = new MyNonReturningSubroutineFixer();
    private final MyStackConsistencyFixer stackConsistencyFixer = new MyStackConsistencyFixer();
    private final MyInstructionDeleter instructionDeleter = new MyInstructionDeleter();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false, true);

    public EvaluationShrinker() {
        this(new PartialEvaluator(), true, null, null);
    }

    public EvaluationShrinker(PartialEvaluator partialEvaluator, boolean runPartialEvaluator, InstructionVisitor extraDeletedInstructionVisitor, InstructionVisitor extraAddedInstructionVisitor) {
        this(new InstructionUsageMarker(partialEvaluator, runPartialEvaluator, true), true, extraDeletedInstructionVisitor, extraAddedInstructionVisitor);
    }

    public EvaluationShrinker(InstructionUsageMarker instructionUsageMarker, boolean runInstructionUsageMarker, InstructionVisitor extraDeletedInstructionVisitor, InstructionVisitor extraAddedInstructionVisitor) {
        this.instructionUsageMarker = instructionUsageMarker;
        this.runInstructionUsageMarker = runInstructionUsageMarker;
        this.extraDeletedInstructionVisitor = extraDeletedInstructionVisitor;
        this.extraAddedInstructionVisitor = extraAddedInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        block2: {
            try {
                this.visitCodeAttribute0(clazz, method, codeAttribute);
            }
            catch (RuntimeException ex) {
                logger.error("Unexpected error while shrinking instructions after partial evaluation:");
                logger.error("  Class       = [{}]", (Object)clazz.getName());
                logger.error("  Method      = [{}{}]", (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
                logger.error("  Exception   = [{}] ({})", (Object)ex.getClass().getName(), (Object)ex.getMessage());
                ex.printStackTrace();
                logger.error("Not optimizing this method");
                logger.debug("{}", new Supplier[]{() -> {
                    StringWriter sw = new StringWriter();
                    method.accept(clazz, (MemberVisitor)new ClassPrinter(new PrintWriter(sw)));
                    return sw.toString();
                }});
                if (!logger.getLevel().isLessSpecificThan(Level.DEBUG)) break block2;
                throw ex;
            }
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        logger.debug("EvaluationShrinker [{}.{}]", (Object)clazz.getName(), (Object)(method.getName(clazz) + method.getDescriptor(clazz)));
        if (this.runInstructionUsageMarker) {
            this.instructionUsageMarker.visitCodeAttribute(clazz, method, codeAttribute);
        }
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        logger.debug("Static invocation fixing:");
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.necessaryInstructionFilter(true, this.staticInvocationFixer));
        logger.debug("Backward branch fixing:");
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.tracedInstructionFilter(true, this.instructionUsageMarker.necessaryInstructionFilter(false, this.backwardBranchFixer)));
        logger.debug("Non-returning subroutine fixing:");
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.necessaryInstructionFilter(true, this.nonReturningSubroutineFixer));
        logger.debug("Stack consistency fixing:");
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.tracedInstructionFilter(true, this.stackConsistencyFixer));
        logger.debug("Deleting unused instructions");
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.necessaryInstructionFilter(false, this.instructionDeleter));
        logger.debug("Simplification results:");
        if (logger.getLevel().isLessSpecificThan(Level.DEBUG)) {
            Instruction instruction;
            int offset = 0;
            do {
                Instruction postInsertion;
                Instruction replacement;
                Instruction preInsertion;
                instruction = InstructionFactory.create((byte[])codeAttribute.code, (int)offset);
                logger.debug("{}{}", (Object)(this.instructionUsageMarker.isInstructionNecessary(offset) ? " + " : (this.instructionUsageMarker.isExtraPushPopInstructionNecessary(offset) ? " ~ " : " - ")), (Object)instruction.toString(offset));
                if (!this.instructionUsageMarker.isTraced(offset)) continue;
                InstructionOffsetValue branchTargets = this.instructionUsageMarker.branchTargets(offset);
                if (branchTargets != null) {
                    logger.debug("     has overall been branching to {}", (Object)branchTargets);
                }
                boolean deleted = this.codeAttributeEditor.deleted[offset];
                if (this.instructionUsageMarker.isInstructionNecessary(offset) && deleted) {
                    logger.debug("     is deleted");
                }
                if ((preInsertion = this.codeAttributeEditor.preInsertions[offset]) != null) {
                    logger.debug("     is preceded by: {}", (Object)preInsertion);
                }
                if ((replacement = this.codeAttributeEditor.replacements[offset]) != null) {
                    logger.debug("     is replaced by: {}", (Object)replacement);
                }
                if ((postInsertion = this.codeAttributeEditor.postInsertions[offset]) == null) continue;
                logger.debug("     is followed by: {}", (Object)postInsertion);
            } while ((offset += instruction.length(offset)) < codeLength);
        }
        codeAttribute.exceptionsAccept(clazz, method, (ExceptionInfoVisitor)this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        if (!this.instructionUsageMarker.isTraced(exceptionInfo.u2handlerPC)) {
            exceptionInfo.u2endPC = exceptionInfo.u2startPC;
        }
    }

    private boolean isAnyUnnecessaryInstructionBranchingOver(int instructionOffset1, int instructionOffset2) {
        for (int offset = instructionOffset1; offset < instructionOffset2; ++offset) {
            if (!this.instructionUsageMarker.isTraced(offset) || this.instructionUsageMarker.isInstructionNecessary(offset) || !this.isAnyLargerThan(this.instructionUsageMarker.branchTargets(offset), instructionOffset2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyLargerThan(InstructionOffsetValue instructionOffsets, int instructionOffset) {
        int branchCount;
        if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                return true;
            }
        }
        return false;
    }

    private void insertPushInstructions(int offset, boolean replace, boolean before, int computationalType) {
        SimpleInstruction replacementInstruction = new SimpleInstruction(this.pushOpcode(computationalType));
        logger.debug(": {}", (Object)replacementInstruction.toString(offset));
        this.insertInstruction(offset, replace, before, (Instruction)replacementInstruction);
    }

    private byte pushOpcode(int computationalType) {
        switch (computationalType) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalArgumentException("No push opcode for computational type [" + computationalType + "]");
    }

    private void insertPopInstructions(int offset, boolean replace, boolean before, int popCount) {
        switch (popCount) {
            case 1: {
                SimpleInstruction popInstruction = new SimpleInstruction(87);
                this.insertInstruction(offset, replace, before, (Instruction)popInstruction);
                break;
            }
            case 2: {
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                this.insertInstruction(offset, replace, before, (Instruction)popInstruction);
                break;
            }
            default: {
                Instruction[] popInstructions = new Instruction[popCount / 2 + popCount % 2];
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                for (int index = 0; index < popCount / 2; ++index) {
                    popInstructions[index] = popInstruction;
                }
                if (popCount % 2 == 1) {
                    popInstruction = new SimpleInstruction(87);
                    popInstructions[popCount / 2] = popInstruction;
                }
                this.insertInstructions(offset, replace, before, (Instruction)popInstruction, popInstructions);
                break;
            }
        }
    }

    private void insertInstruction(int offset, boolean replace, boolean before, Instruction instruction) {
        if (replace) {
            this.codeAttributeEditor.replaceInstruction(offset, instruction);
            if (this.extraAddedInstructionVisitor != null && !this.instructionUsageMarker.isInstructionNecessary(offset)) {
                instruction.accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        } else {
            if (before) {
                this.codeAttributeEditor.insertBeforeInstruction(offset, instruction);
            } else {
                this.codeAttributeEditor.insertAfterInstruction(offset, instruction);
            }
            if (this.extraAddedInstructionVisitor != null) {
                instruction.accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
    }

    private void insertInstructions(int offset, boolean replace, boolean before, Instruction instruction, Instruction[] instructions) {
        block6: {
            block5: {
                if (!replace) break block5;
                this.codeAttributeEditor.replaceInstruction(offset, instructions);
                if (this.extraAddedInstructionVisitor == null) break block6;
                if (!this.instructionUsageMarker.isInstructionNecessary(offset)) {
                    instruction.accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                }
                for (int index = 1; index < instructions.length; ++index) {
                    instructions[index].accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                }
                break block6;
            }
            if (before) {
                this.codeAttributeEditor.insertBeforeInstruction(offset, instructions);
            } else {
                this.codeAttributeEditor.insertAfterInstruction(offset, instructions);
            }
            for (int index = 0; index < instructions.length; ++index) {
                if (this.extraAddedInstructionVisitor == null) continue;
                instructions[index].accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
    }

    private void replaceByStaticInvocation(Clazz clazz, int offset, ConstantInstruction constantInstruction) {
        ConstantInstruction replacementInstruction = new ConstantInstruction(-72, constantInstruction.constantIndex);
        logger.debug("  Replacing by static invocation {} -> {}", (Object)constantInstruction.toString(offset), (Object)replacementInstruction.toString());
        this.codeAttributeEditor.replaceInstruction(offset, (Instruction)replacementInstruction);
    }

    private void replaceByInfiniteLoop(Clazz clazz, int offset) {
        logger.debug("  Inserting infinite loop at [{}]", (Object)offset);
        BranchInstruction replacementInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(offset, (Instruction)replacementInstruction);
    }

    private void replaceBySimpleInstructions(int offset, Instruction oldInstruction, int newOpcodes) {
        if (newOpcodes == -1) {
            throw new UnsupportedOperationException("Can't handle " + oldInstruction.toString() + " instruction at [" + offset + "]");
        }
        if ((newOpcodes & 0xFFFFFF00) == 0) {
            byte newOpcode = (byte)newOpcodes;
            if (newOpcode == 0) {
                this.codeAttributeEditor.deleteInstruction(offset);
                if (this.extraDeletedInstructionVisitor != null) {
                    this.extraDeletedInstructionVisitor.visitSimpleInstruction(null, null, null, offset, null);
                }
                logger.debug("  Deleting marked instruction {}", (Object)oldInstruction.toString(offset));
            } else if (newOpcode == oldInstruction.opcode) {
                this.codeAttributeEditor.undeleteInstruction(offset);
                logger.debug("  Marking unchanged instruction {}", (Object)oldInstruction.toString(offset));
            } else {
                SimpleInstruction replacementInstruction = new SimpleInstruction(newOpcode);
                this.codeAttributeEditor.replaceInstruction(offset, (Instruction)replacementInstruction);
                logger.debug("  Replacing instruction {} by {}", (Object)oldInstruction.toString(offset), (Object)replacementInstruction.toString());
            }
        } else {
            logger.debug("  Replacing instruction {} by", (Object)oldInstruction.toString(offset));
            Instruction[] replacementInstructions = this.simpleInstructions(newOpcodes);
            this.codeAttributeEditor.replaceInstruction(offset, replacementInstructions);
        }
    }

    private Instruction[] simpleInstructions(int opcodes) {
        if (opcodes == -1) {
            throw new UnsupportedOperationException("Can't perform complex stack manipulation");
        }
        Instruction[] instructions = new Instruction[4];
        int count = 0;
        while (opcodes != 0) {
            SimpleInstruction replacementInstruction = new SimpleInstruction((byte)opcodes);
            instructions[count++] = replacementInstruction;
            logger.debug("    {}", (Object)replacementInstruction.toString());
            opcodes >>>= 8;
        }
        if (count < 4) {
            Instruction[] newInstructions = new Instruction[count];
            System.arraycopy(instructions, 0, newInstructions, 0, count);
            instructions = newInstructions;
        }
        return instructions;
    }

    private class MyInstructionDeleter
    implements InstructionVisitor {
        private MyInstructionDeleter() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            EvaluationShrinker.this.codeAttributeEditor.deleteInstruction(offset);
            if (EvaluationShrinker.this.extraDeletedInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, offset, EvaluationShrinker.this.extraDeletedInstructionVisitor);
            }
        }
    }

    private class MyStackConsistencyFixer
    implements InstructionVisitor {
        private MyStackConsistencyFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(offset)) {
                int pushCount;
                int stackIndex;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset);
                    int stackSize = tracedStack.size();
                    int requiredPopMask = 0;
                    int requiredPushMask = 0;
                    for (stackIndex = stackSize - popCount; stackIndex < stackSize; ++stackIndex) {
                        requiredPopMask <<= 1;
                        requiredPushMask <<= 1;
                        boolean stackEntryUnwantedBefore = EvaluationShrinker.this.instructionUsageMarker.isStackEntryUnwantedBefore(offset, stackIndex);
                        boolean stackEntryPresentBefore = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(offset, stackIndex);
                        if (stackEntryUnwantedBefore) {
                            if (!stackEntryPresentBefore) continue;
                            requiredPopMask |= 1;
                            continue;
                        }
                        if (stackEntryPresentBefore) continue;
                        requiredPushMask |= 1;
                    }
                    if (requiredPopMask > 0) {
                        logger.debug("  Popping 0x{} before marked consumer {}", (Object)Integer.toHexString(requiredPopMask), (Object)instruction.toString(offset));
                        EvaluationShrinker.this.insertInstructions(offset, false, true, instruction, EvaluationShrinker.this.simpleInstructions(this.complexPop(requiredPopMask)));
                    }
                    if (requiredPushMask > 0) {
                        Value value = tracedStack.getTop(0);
                        if (requiredPushMask != (value.isCategory2() ? 3 : 1)) {
                            throw new IllegalArgumentException("Unsupported stack size increment [" + requiredPushMask + "] at [" + offset + "]");
                        }
                        logger.debug("  Pushing {} before marked consumer {}", (Object)value.computationalType(), (Object)instruction.toString(offset));
                        EvaluationShrinker.this.insertPushInstructions(offset, false, true, value.computationalType());
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackAfter(offset);
                    int stackSize = tracedStack.size();
                    int requiredPopCount = 0;
                    for (stackIndex = stackSize - pushCount; stackIndex < stackSize; ++stackIndex) {
                        if (EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(offset, stackIndex)) continue;
                        ++requiredPopCount;
                    }
                    if (requiredPopCount > 0) {
                        logger.debug("  Popping {} entries after marked producer {}", (Object)requiredPopCount, (Object)instruction.toString(offset));
                        EvaluationShrinker.this.insertPopInstructions(offset, false, false, requiredPopCount);
                    }
                }
            } else if (EvaluationShrinker.this.instructionUsageMarker.isExtraPushPopInstructionNecessary(offset)) {
                int pushCount;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset);
                    int stackSize = tracedStack.size();
                    int expectedPopCount = 0;
                    for (int stackIndex = stackSize - popCount; stackIndex < stackSize; ++stackIndex) {
                        if (!EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(offset, stackIndex)) continue;
                        ++expectedPopCount;
                    }
                    if (expectedPopCount > 0) {
                        logger.debug("  Popping {} entries instead of unmarked consumer {}", (Object)expectedPopCount, (Object)instruction.toString(offset));
                        EvaluationShrinker.this.insertPopInstructions(offset, true, false, expectedPopCount);
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackAfter(offset);
                    int stackSize = tracedStack.size();
                    int expectedPushCount = 0;
                    for (int stackIndex = stackSize - pushCount; stackIndex < stackSize; ++stackIndex) {
                        if (!EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(offset, stackIndex)) continue;
                        ++expectedPushCount;
                    }
                    if (expectedPushCount > 0) {
                        logger.debug("  Pushing type {} entry instead of unmarked producer {}", (Object)tracedStack.getTop(0).computationalType(), (Object)instruction.toString(offset));
                        EvaluationShrinker.this.insertPushInstructions(offset, true, false, tracedStack.getTop(0).computationalType());
                    }
                }
            }
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(offset) && this.isDupOrSwap((Instruction)simpleInstruction)) {
                int topBefore = EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset).size() - 1;
                int topAfter = EvaluationShrinker.this.instructionUsageMarker.getStackAfter(offset).size() - 1;
                byte oldOpcode = simpleInstruction.opcode;
                int newOpcodes = this.fixDupSwap(offset, oldOpcode, topBefore, topAfter);
                EvaluationShrinker.this.replaceBySimpleInstructions(offset, (Instruction)simpleInstruction, newOpcodes);
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, (Instruction)simpleInstruction);
            }
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(offset)) {
                if (branchInstruction.stackPopCount(clazz) > 0 && !EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(offset, EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset).size() - 1)) {
                    BranchInstruction replacementInstruction = new BranchInstruction(-89, branchInstruction.branchOffset);
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(offset, (Instruction)replacementInstruction);
                    logger.debug("  Replacing branch instruction {} by {}", (Object)branchInstruction.toString(offset), (Object)replacementInstruction.toString());
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, (Instruction)branchInstruction);
            }
        }

        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(offset)) {
                if (switchInstruction.stackPopCount(clazz) > 0 && !EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(offset, EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset).size() - 1)) {
                    BranchInstruction replacementInstruction = new BranchInstruction(-89, switchInstruction.defaultOffset);
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(offset, (Instruction)replacementInstruction);
                    logger.debug("  Replacing switch instruction {} by {}", (Object)switchInstruction.toString(offset), (Object)replacementInstruction.toString());
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, (Instruction)switchInstruction);
            }
        }

        private boolean isDupOrSwap(Instruction instruction) {
            return instruction.opcode >= 89 && instruction.opcode <= 95;
        }

        private int fixDupSwap(int instructionOffset, byte dupSwapOpcode, int topBefore, int topAfter) {
            switch (dupSwapOpcode) {
                case 89: {
                    return this.fixedDup(instructionOffset, topBefore, topAfter);
                }
                case 90: {
                    return this.fixedDup_x1(instructionOffset, topBefore, topAfter);
                }
                case 91: {
                    return this.fixedDup_x2(instructionOffset, topBefore, topAfter);
                }
                case 92: {
                    return this.fixedDup2(instructionOffset, topBefore, topAfter);
                }
                case 93: {
                    return this.fixedDup2_x1(instructionOffset, topBefore, topAfter);
                }
                case 94: {
                    return this.fixedDup2_x2(instructionOffset, topBefore, topAfter);
                }
                case 95: {
                    return this.fixedSwap(instructionOffset, topBefore, topAfter);
                }
            }
            throw new IllegalArgumentException("Not a dup/swap opcode [" + dupSwapOpcode + "]");
        }

        private int fixedDup(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            return stackEntryNecessary0 ? (stackEntryNecessary1 ? 89 : 0) : (stackEntryNecessary1 ? 0 : (stackEntryPresent0 ? 87 : 0));
        }

        private int fixedDup_x1(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryPresent1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            return stackEntryNecessary1 ? (stackEntryNecessary2 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))) : (stackEntryPresent1 ? (stackEntryNecessary2 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))) : (stackEntryNecessary2 ? (stackEntryNecessary0 ? 89 : 0) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))));
        }

        private int fixedDup_x2(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryPresent1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryPresent2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 2);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            return stackEntryNecessary1 ? (stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 91 : 22363) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 1515673693 : 1465408863) : (stackEntryNecessary0 ? 5724253 : (stackEntryPresent0 ? 0x575F57 : 22367))) : (stackEntryNecessary3 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))))) : (stackEntryPresent1 ? (stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 5920607 : 22619) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 1498961755 : 5789531) : (stackEntryNecessary0 ? 5789531 : (stackEntryPresent0 ? 22360 : 88))) : (stackEntryNecessary3 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))))) : (stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))) : (stackEntryNecessary3 ? (stackEntryNecessary0 ? 89 : 0) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))))));
        }

        private int fixedDup2(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryPresent1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            return stackEntryNecessary3 ? (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 92 : 23135) : (stackEntryNecessary0 ? 89 : 0)) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 0x5F5A5F : (stackEntryPresent0 ? 22871 : 89)) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)))) : (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 89 : 0))) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87)) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)))));
        }

        private int fixedDup2_x1(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryPresent1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryPresent2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 2);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            boolean stackEntryNecessary4 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 4);
            return stackEntryNecessary4 ? (stackEntryNecessary3 ? (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 93 : 22365) : (stackEntryNecessary0 ? -1 : 22621)) : (stackEntryPresent2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 1549228125 : -1) : (stackEntryNecessary0 ? 1498896477 : 5724253)) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 92 : 23135) : (stackEntryNecessary0 ? 89 : 0)))) : (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? -1 : (stackEntryPresent0 ? 23127 : 90)) : (stackEntryNecessary0 ? -1 : (stackEntryPresent0 ? 24407 : 95))) : (stackEntryPresent2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? -1 : (stackEntryPresent0 ? 1498898263 : 5855071)) : (stackEntryNecessary0 ? 5724253 : (stackEntryPresent0 ? 0x575F57 : 22367))) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 0x5F5A5F : (stackEntryPresent0 ? 22871 : 89)) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)))))) : (stackEntryNecessary3 ? (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 91 : 22363) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 5920607 : 22619) : (stackEntryNecessary0 ? 5724253 : 95))) : (stackEntryPresent2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 1515673693 : 1465408095) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 1498961755 : 5789531) : (stackEntryNecessary0 ? 5855071 : 22367))) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 89 : 0))))) : (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87)) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)))) : (stackEntryPresent2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 5724253 : (stackEntryPresent0 ? 0x575F57 : 22367)) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 5789531 : (stackEntryPresent0 ? 22360 : 88)) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87)))) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87)) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)))))));
        }

        private int fixedDup2_x2(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntriesPresent01 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesPresentBefore(instructionOffset, topBefore, topBefore - 1);
            boolean stackEntryPresent2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 2);
            boolean stackEntryPresent3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 3);
            boolean stackEntriesNecessary01 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(instructionOffset, topAfter, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            boolean stackEntriesNecessary45 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(instructionOffset, topAfter - 4, topAfter - 5);
            return stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 94 : 22622) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))) : (stackEntryPresent3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5726046) : (stackEntriesNecessary01 ? -1 : (stackEntriesPresent01 ? 5726040 : 22367))) : (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 93 : 22621) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5724254) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))) : (stackEntryPresent3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 0x58585E) : (stackEntriesNecessary01 ? 0x58585E : (stackEntriesPresent01 ? 22616 : 88))) : (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 1549228125 : 5724253) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))))) : (stackEntryNecessary3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 93 : 22621) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))) : (stackEntryPresent3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 1549228125 : 5724253) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))) : (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 92 : 0) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))))));
        }

        private int fixedSwap(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryPresent1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            return stackEntryNecessary0 ? (stackEntryNecessary1 ? 95 : (stackEntryPresent0 ? 87 : 0)) : (stackEntryPresent1 ? 22367 : 0);
        }

        private int complexPop(int popMask) {
            switch (popMask) {
                case 1: {
                    return 87;
                }
                case 3: {
                    return 88;
                }
                case 7: {
                    return 22360;
                }
                case 15: {
                    return 22616;
                }
                case 2: {
                    return 22367;
                }
                case 4: {
                    return 5724253;
                }
            }
            throw new UnsupportedOperationException("Can't remove complex pattern of entries from stack [0x" + Integer.toHexString(popMask) + "]");
        }
    }

    private class MyNonReturningSubroutineFixer
    implements InstructionVisitor {
        private MyNonReturningSubroutineFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (branchInstruction.canonicalOpcode() == -88) {
                int nextOffset = offset + branchInstruction.length(offset);
                if (!EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(nextOffset)) {
                    EvaluationShrinker.this.replaceByInfiniteLoop(clazz, nextOffset);
                    logger.debug("  Adding infinite loop at [{}] after {}", (Object)nextOffset, (Object)branchInstruction.toString(offset));
                }
            }
        }
    }

    private class MyBackwardBranchFixer
    implements InstructionVisitor {
        private MyBackwardBranchFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            if (this.isAllSmallerThanOrEqual(EvaluationShrinker.this.instructionUsageMarker.branchTargets(offset), offset) && !EvaluationShrinker.this.isAnyUnnecessaryInstructionBranchingOver(this.lastNecessaryInstructionOffset(offset), offset)) {
                EvaluationShrinker.this.replaceByInfiniteLoop(clazz, offset);
                logger.debug("  Setting infinite loop instead of {}", (Object)instruction.toString(offset));
            }
        }

        private boolean isAllSmallerThanOrEqual(InstructionOffsetValue instructionOffsets, int instructionOffset) {
            int branchCount;
            if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
                for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                    if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private int lastNecessaryInstructionOffset(int instructionOffset) {
            for (int offset = instructionOffset - 1; offset >= 0; --offset) {
                if (!EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(instructionOffset)) continue;
                return offset;
            }
            return 0;
        }
    }

    private class MyStaticInvocationFixer
    implements InstructionVisitor,
    ConstantVisitor,
    MemberVisitor {
        private int invocationOffset;
        private ConstantInstruction invocationInstruction;

        private MyStaticInvocationFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -74: 
                case -73: 
                case -71: {
                    this.invocationOffset = offset;
                    this.invocationInstruction = constantInstruction;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                }
            }
        }

        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            refConstant.referencedMemberAccept((MemberVisitor)this);
        }

        public void visitAnyMember(Clazz clazz, Member member) {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            if ((programMethod.getAccessFlags() & 8) == 0 && !ParameterUsageMarker.isParameterUsed((Method)programMethod, 0)) {
                EvaluationShrinker.this.replaceByStaticInvocation((Clazz)programClass, this.invocationOffset, this.invocationInstruction);
            }
        }
    }
}

