/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.AutoValue_ErrorProneOptions_PatchingOptions;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.ImportOrderParser;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.apply.ImportOrganizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ErrorProneOptions {
    private static final String SEVERITY_PREFIX = "-Xep:";
    private static final String PATCH_CHECKS_PREFIX = "-XepPatchChecks:";
    private static final String PATCH_OUTPUT_LOCATION = "-XepPatchLocation:";
    private static final String PATCH_IMPORT_ORDER_PREFIX = "-XepPatchImportOrder:";
    private static final String ERRORS_AS_WARNINGS_FLAG = "-XepAllErrorsAsWarnings";
    private static final String ENABLE_ALL_CHECKS = "-XepAllDisabledChecksAsWarnings";
    private static final String DISABLE_ALL_CHECKS = "-XepDisableAllChecks";
    private static final String IGNORE_UNKNOWN_CHECKS_FLAG = "-XepIgnoreUnknownCheckNames";
    private static final String DISABLE_WARNINGS_IN_GENERATED_CODE_FLAG = "-XepDisableWarningsInGeneratedCode";
    private static final String COMPILING_TEST_ONLY_CODE = "-XepCompilingTestOnlyCode";
    private final ImmutableList<String> remainingArgs;
    private final ImmutableMap<String, Severity> severityMap;
    private final boolean ignoreUnknownChecks;
    private final boolean disableWarningsInGeneratedCode;
    private final boolean dropErrorsToWarnings;
    private final boolean enableAllChecksAsWarnings;
    private final boolean disableAllChecks;
    private final boolean isTestOnlyTarget;
    private final ErrorProneFlags flags;
    private final PatchingOptions patchingOptions;
    private static final ErrorProneOptions EMPTY = new Builder().build((ImmutableList<String>)ImmutableList.of());

    public static int isSupportedOption(String option) {
        boolean isSupported = option.startsWith(SEVERITY_PREFIX) || option.startsWith("-XepOpt:") || option.startsWith(PATCH_OUTPUT_LOCATION) || option.startsWith(PATCH_CHECKS_PREFIX) || option.equals(IGNORE_UNKNOWN_CHECKS_FLAG) || option.equals(DISABLE_WARNINGS_IN_GENERATED_CODE_FLAG) || option.equals(ERRORS_AS_WARNINGS_FLAG) || option.equals(ENABLE_ALL_CHECKS) || option.equals(DISABLE_ALL_CHECKS) || option.equals(COMPILING_TEST_ONLY_CODE);
        return isSupported ? 0 : -1;
    }

    public boolean isEnableAllChecksAsWarnings() {
        return this.enableAllChecksAsWarnings;
    }

    public boolean isDisableAllChecks() {
        return this.disableAllChecks;
    }

    private ErrorProneOptions(ImmutableMap<String, Severity> severityMap, ImmutableList<String> remainingArgs, boolean ignoreUnknownChecks, boolean disableWarningsInGeneratedCode, boolean dropErrorsToWarnings, boolean enableAllChecksAsWarnings, boolean disableAllChecks, boolean isTestOnlyTarget, ErrorProneFlags flags, PatchingOptions patchingOptions) {
        this.severityMap = severityMap;
        this.remainingArgs = remainingArgs;
        this.ignoreUnknownChecks = ignoreUnknownChecks;
        this.disableWarningsInGeneratedCode = disableWarningsInGeneratedCode;
        this.dropErrorsToWarnings = dropErrorsToWarnings;
        this.enableAllChecksAsWarnings = enableAllChecksAsWarnings;
        this.disableAllChecks = disableAllChecks;
        this.isTestOnlyTarget = isTestOnlyTarget;
        this.flags = flags;
        this.patchingOptions = patchingOptions;
    }

    public String[] getRemainingArgs() {
        return (String[])this.remainingArgs.toArray((Object[])new String[this.remainingArgs.size()]);
    }

    public ImmutableMap<String, Severity> getSeverityMap() {
        return this.severityMap;
    }

    public boolean ignoreUnknownChecks() {
        return this.ignoreUnknownChecks;
    }

    public boolean disableWarningsInGeneratedCode() {
        return this.disableWarningsInGeneratedCode;
    }

    public boolean isDropErrorsToWarnings() {
        return this.dropErrorsToWarnings;
    }

    public boolean isTestOnlyTarget() {
        return this.isTestOnlyTarget;
    }

    public ErrorProneFlags getFlags() {
        return this.flags;
    }

    public PatchingOptions patchingOptions() {
        return this.patchingOptions;
    }

    public static ErrorProneOptions empty() {
        return EMPTY;
    }

    public static ErrorProneOptions processArgs(Iterable<String> args) {
        Preconditions.checkNotNull(args);
        ImmutableList.Builder remainingArgs = ImmutableList.builder();
        Builder builder = new Builder();
        Iterator<String> iterator = args.iterator();
        block16: while (iterator.hasNext()) {
            String remaining;
            String arg;
            switch (arg = iterator.next()) {
                case "-XepIgnoreUnknownCheckNames": {
                    builder.setIgnoreUnknownChecks(true);
                    continue block16;
                }
                case "-XepDisableWarningsInGeneratedCode": {
                    builder.setDisableWarningsInGeneratedCode(true);
                    continue block16;
                }
                case "-XepAllErrorsAsWarnings": {
                    builder.setDropErrorsToWarnings(true);
                    continue block16;
                }
                case "-XepAllDisabledChecksAsWarnings": {
                    builder.setEnableAllChecksAsWarnings(true);
                    continue block16;
                }
                case "-XepDisableAllChecks": {
                    builder.setDisableAllChecks(true);
                    continue block16;
                }
                case "-XepCompilingTestOnlyCode": {
                    builder.setTestOnlyTarget(true);
                    continue block16;
                }
            }
            if (arg.startsWith(SEVERITY_PREFIX)) {
                builder.parseSeverity(arg);
                continue;
            }
            if (arg.startsWith("-XepOpt:")) {
                builder.parseFlag(arg);
                continue;
            }
            if (arg.startsWith(PATCH_OUTPUT_LOCATION)) {
                remaining = arg.substring(PATCH_OUTPUT_LOCATION.length());
                if (remaining.equals("IN_PLACE")) {
                    builder.patchingOptionsBuilder().inPlace(true);
                    continue;
                }
                if (remaining.isEmpty()) {
                    throw new InvalidCommandLineOptionException("invalid flag: " + arg);
                }
                builder.patchingOptionsBuilder().baseDirectory(remaining);
                continue;
            }
            if (arg.startsWith(PATCH_CHECKS_PREFIX)) {
                remaining = arg.substring(PATCH_CHECKS_PREFIX.length());
                if (remaining.startsWith("refaster:")) {
                    builder.patchingOptionsBuilder().customRefactorer((Supplier<CodeTransformer>)((Supplier)() -> {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }));
                    continue;
                }
                Iterable checks = Splitter.on((char)',').trimResults().split((CharSequence)remaining);
                builder.patchingOptionsBuilder().namedCheckers((Set<String>)ImmutableSet.copyOf((Iterable)checks));
                continue;
            }
            if (arg.startsWith(PATCH_IMPORT_ORDER_PREFIX)) {
                remaining = arg.substring(PATCH_IMPORT_ORDER_PREFIX.length());
                ImportOrganizer importOrganizer = ImportOrderParser.getImportOrganizer(remaining);
                builder.patchingOptionsBuilder().importOrganizer(importOrganizer);
                continue;
            }
            remainingArgs.add((Object)arg);
        }
        return builder.build((ImmutableList<String>)remainingArgs.build());
    }

    public static ErrorProneOptions processArgs(String[] args) {
        Preconditions.checkNotNull((Object)args);
        return ErrorProneOptions.processArgs(Arrays.asList(args));
    }

    private static class Builder {
        private boolean ignoreUnknownChecks = false;
        private boolean disableWarningsInGeneratedCode = false;
        private boolean dropErrorsToWarnings = false;
        private boolean enableAllChecksAsWarnings = false;
        private boolean disableAllChecks = false;
        private boolean isTestOnlyTarget = false;
        private Map<String, Severity> severityMap = new HashMap<String, Severity>();
        private final ErrorProneFlags.Builder flagsBuilder = ErrorProneFlags.builder();
        private final PatchingOptions.Builder patchingOptionsBuilder = PatchingOptions.builder();

        private Builder() {
        }

        private void parseSeverity(String arg) {
            Severity severity;
            String remaining = arg.substring(ErrorProneOptions.SEVERITY_PREFIX.length());
            String[] parts = remaining.split(":");
            if (parts.length > 2 || parts[0].isEmpty()) {
                throw new InvalidCommandLineOptionException("invalid flag: " + arg);
            }
            String checkName = parts[0];
            if (parts.length == 1) {
                severity = Severity.DEFAULT;
            } else {
                try {
                    severity = Severity.valueOf(parts[1]);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidCommandLineOptionException("invalid flag: " + arg);
                }
            }
            this.severityMap.put(checkName, severity);
        }

        public void parseFlag(String flag) {
            this.flagsBuilder.parseFlag(flag);
        }

        public void setIgnoreUnknownChecks(boolean ignoreUnknownChecks) {
            this.ignoreUnknownChecks = ignoreUnknownChecks;
        }

        public void setDisableWarningsInGeneratedCode(boolean disableWarningsInGeneratedCode) {
            this.disableWarningsInGeneratedCode = disableWarningsInGeneratedCode;
        }

        public void setDropErrorsToWarnings(boolean dropErrorsToWarnings) {
            this.severityMap.entrySet().stream().filter(e -> e.getValue() == Severity.ERROR).forEach(e -> e.setValue(Severity.WARN));
            this.dropErrorsToWarnings = dropErrorsToWarnings;
        }

        public void setEnableAllChecksAsWarnings(boolean enableAllChecksAsWarnings) {
            this.severityMap.entrySet().stream().filter(e -> e.getValue() == Severity.OFF).forEach(e -> e.setValue(Severity.WARN));
            this.enableAllChecksAsWarnings = enableAllChecksAsWarnings;
        }

        public void setDisableAllChecks(boolean disableAllChecks) {
            this.severityMap.clear();
            this.disableAllChecks = disableAllChecks;
        }

        public void setTestOnlyTarget(boolean isTestOnlyTarget) {
            this.isTestOnlyTarget = isTestOnlyTarget;
        }

        public PatchingOptions.Builder patchingOptionsBuilder() {
            return this.patchingOptionsBuilder;
        }

        public ErrorProneOptions build(ImmutableList<String> remainingArgs) {
            return new ErrorProneOptions(ImmutableMap.copyOf(this.severityMap), remainingArgs, this.ignoreUnknownChecks, this.disableWarningsInGeneratedCode, this.dropErrorsToWarnings, this.enableAllChecksAsWarnings, this.disableAllChecks, this.isTestOnlyTarget, this.flagsBuilder.build(), this.patchingOptionsBuilder.build());
        }
    }

    static abstract class PatchingOptions {
        PatchingOptions() {
        }

        final boolean doRefactor() {
            return this.inPlace() || !this.baseDirectory().isEmpty();
        }

        abstract Set<String> namedCheckers();

        abstract boolean inPlace();

        abstract String baseDirectory();

        abstract Optional<Supplier<CodeTransformer>> customRefactorer();

        abstract ImportOrganizer importOrganizer();

        static Builder builder() {
            return new AutoValue_ErrorProneOptions_PatchingOptions.Builder().baseDirectory("").inPlace(false).namedCheckers(Collections.emptySet()).importOrganizer(ImportOrganizer.STATIC_FIRST_ORGANIZER);
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder namedCheckers(Set<String> var1);

            abstract Builder inPlace(boolean var1);

            abstract Builder baseDirectory(String var1);

            abstract Builder customRefactorer(Supplier<CodeTransformer> var1);

            abstract Builder importOrganizer(ImportOrganizer var1);

            abstract PatchingOptions autoBuild();

            final PatchingOptions build() {
                PatchingOptions patchingOptions = this.autoBuild();
                if ((!patchingOptions.namedCheckers().isEmpty() || patchingOptions.customRefactorer().isPresent()) ^ patchingOptions.doRefactor()) {
                    throw new InvalidCommandLineOptionException("-XepPatchChecks and -XepPatchLocation must be specified together");
                }
                return patchingOptions;
            }
        }
    }

    public static enum Severity {
        DEFAULT,
        OFF,
        WARN,
        ERROR;

    }
}

