/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

class MavenSettingsServerCredentials {
    @VisibleForTesting
    static final String CREDENTIAL_SOURCE = "Maven settings";
    private final Settings settings;

    MavenSettingsServerCredentials(Settings settings) {
        this.settings = settings;
    }

    @Nullable
    RegistryCredentials retrieve(@Nullable String registry) {
        if (registry == null) {
            return null;
        }
        Server registryServerSettings = this.settings.getServer(registry);
        if (registryServerSettings == null) {
            return null;
        }
        return new RegistryCredentials(CREDENTIAL_SOURCE, Authorizations.withBasicCredentials(registryServerSettings.getUsername(), registryServerSettings.getPassword()));
    }
}

