/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.BuildStepsRunner;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.maven.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenBuildLogger;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dockerBuild", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildDockerMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "dockerBuild";
    private static final String USER_AGENT_SUFFIX = "jib-maven-plugin";
    private static final HelpfulSuggestions HELPFUL_SUGGESTIONS = HelpfulSuggestionsProvider.get("Build to Docker daemon failed");

    public void execute() throws MojoExecutionException {
        MavenBuildLogger mavenBuildLogger = new MavenBuildLogger(this.getLog());
        this.handleDeprecatedParameters(mavenBuildLogger);
        if (!new DockerClient().isDockerInstalled()) {
            throw new MojoExecutionException(HELPFUL_SUGGESTIONS.forDockerNotInstalled());
        }
        ImageReference baseImage = BuildDockerMojo.parseImageReference(this.getBaseImage(), "from");
        ImageReference targetImage = this.getDockerTag(mavenBuildLogger);
        MavenSettingsServerCredentials mavenSettingsServerCredentials = new MavenSettingsServerCredentials(((MavenSession)Preconditions.checkNotNull((Object)this.session)).getSettings());
        RegistryCredentials knownBaseRegistryCredentials = mavenSettingsServerCredentials.retrieve(baseImage.getRegistry());
        MavenProjectProperties mavenProjectProperties = MavenProjectProperties.getForProject(this.getProject(), mavenBuildLogger);
        String mainClass = mavenProjectProperties.getMainClass(this);
        BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.builder(mavenBuildLogger).setBaseImage(baseImage).setBaseImageCredentialHelperName(this.getBaseImageCredentialHelperName()).setKnownBaseRegistryCredentials(knownBaseRegistryCredentials).setTargetImage(targetImage).setMainClass(mainClass).setJavaArguments(this.getArgs()).setJvmFlags(this.getJvmFlags()).setEnvironment(this.getEnvironment()).setExposedPorts((List<Port>)ExposedPortsParser.parse(this.getExposedPorts())).setAllowHttp(this.getAllowInsecureRegistries());
        if (this.getExtraDirectory() != null && Files.exists(this.getExtraDirectory(), new LinkOption[0])) {
            try (Stream<Path> extraFilesLayerDirectoryFiles = Files.list(this.getExtraDirectory());){
                buildConfigurationBuilder.setExtraFilesLayerConfiguration(LayerConfiguration.builder().addEntry(extraFilesLayerDirectoryFiles.collect(Collectors.toList()), "/").build());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to list directory for extra files: " + this.getExtraDirectory(), (Exception)ex);
            }
        }
        CacheConfiguration applicationLayersCacheConfiguration = CacheConfiguration.forPath(mavenProjectProperties.getCacheDirectory());
        buildConfigurationBuilder.setApplicationLayersCacheConfiguration(applicationLayersCacheConfiguration);
        if (this.getUseOnlyProjectCache()) {
            buildConfigurationBuilder.setBaseImageLayersCacheConfiguration(applicationLayersCacheConfiguration);
        }
        BuildConfiguration buildConfiguration = buildConfigurationBuilder.build();
        MavenBuildLogger.disableHttpLogging();
        RegistryClient.setUserAgentSuffix(USER_AGENT_SUFFIX);
        try {
            BuildStepsRunner.forBuildToDockerDaemon(buildConfiguration, mavenProjectProperties.getSourceFilesConfiguration()).build(HELPFUL_SUGGESTIONS);
            this.getLog().info((CharSequence)"");
        }
        catch (CacheDirectoryCreationException | BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
    }

    ImageReference getDockerTag(MavenBuildLogger mavenBuildLogger) {
        if (Strings.isNullOrEmpty((String)this.getTargetImage())) {
            mavenBuildLogger.lifecycle("Tagging image with generated image reference " + this.getProject().getName() + ":" + this.getProject().getVersion() + ". If you'd like to specify a different tag, you can set the <to><image> parameter in your pom.xml, or use the -Dimage=<MY IMAGE> commandline flag.");
            return ImageReference.of(null, this.getProject().getName(), this.getProject().getVersion());
        }
        return BuildDockerMojo.parseImageReference(this.getTargetImage(), "to");
    }
}

