/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.cloud.tools.jib.image.json.DescriptorDigestDeserializer;
import com.google.cloud.tools.jib.image.json.DescriptorDigestSerializer;
import java.security.DigestException;

@JsonSerialize(using=DescriptorDigestSerializer.class)
@JsonDeserialize(using=DescriptorDigestDeserializer.class)
public class DescriptorDigest {
    private static final String HASH_REGEX = "[a-f0-9]{64}";
    private static final String DIGEST_PREFIX = "sha256:";
    static final String DIGEST_REGEX = "sha256:[a-f0-9]{64}";
    private final String hash;

    public static DescriptorDigest fromHash(String hash) throws DigestException {
        if (!hash.matches(HASH_REGEX)) {
            throw new DigestException("Invalid hash: " + hash);
        }
        return new DescriptorDigest(hash);
    }

    public static DescriptorDigest fromDigest(String digest) throws DigestException {
        if (!digest.matches(DIGEST_REGEX)) {
            throw new DigestException("Invalid digest: " + digest);
        }
        String hash = digest.substring(DIGEST_PREFIX.length());
        return new DescriptorDigest(hash);
    }

    private DescriptorDigest(String hash) {
        this.hash = hash;
    }

    public String getHash() {
        return this.hash;
    }

    public String toString() {
        return DIGEST_PREFIX + this.hash;
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DescriptorDigest) {
            return this.hash.equals(((DescriptorDigest)obj).hash);
        }
        return false;
    }
}

