/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.docker.json.DockerLoadManifestTemplate;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class ImageToTarballTranslator {
    private static final String CONTAINER_CONFIGURATION_JSON_FILE_NAME = "config.json";
    private static final String MANIFEST_JSON_FILE_NAME = "manifest.json";
    private final Image<CachedLayer> image;

    public ImageToTarballTranslator(Image<CachedLayer> image) {
        this.image = image;
    }

    public Blob toTarballBlob(ImageReference imageReference) throws IOException {
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        DockerLoadManifestTemplate manifestTemplate = new DockerLoadManifestTemplate();
        for (CachedLayer layer : this.image.getLayers()) {
            Path layerContentFile = layer.getContentFile();
            String layerName = layerContentFile.getFileName().toString();
            tarStreamBuilder.addEntry(new TarArchiveEntry(layerContentFile.toFile(), layerName));
            manifestTemplate.addLayerFile(layerName);
        }
        Blob containerConfigurationBlob = new ImageToJsonTranslator(this.image).getContainerConfigurationBlob();
        tarStreamBuilder.addEntry(Blobs.writeToString(containerConfigurationBlob), CONTAINER_CONFIGURATION_JSON_FILE_NAME);
        manifestTemplate.setRepoTags(imageReference.toStringWithTag());
        tarStreamBuilder.addEntry(Blobs.writeToString(JsonTemplateMapper.toBlob(manifestTemplate)), MANIFEST_JSON_FILE_NAME);
        return tarStreamBuilder.toBlob();
    }
}

