/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ChannelFactory;
import com.google.api.gax.grpc.SafeShutdownManagedChannel;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

class RefreshingManagedChannel
extends ManagedChannel {
    private static final Logger LOG = Logger.getLogger(RefreshingManagedChannel.class.getName());
    private static final Duration refreshPeriod = Duration.ofMinutes((long)50L);
    private static final double jitterPercentage = 0.15;
    private volatile SafeShutdownManagedChannel delegate;
    private volatile ScheduledFuture<?> nextScheduledRefresh;
    private final ReadWriteLock lock;
    private final ChannelFactory channelFactory;
    private final ScheduledExecutorService scheduledExecutorService;

    RefreshingManagedChannel(ChannelFactory channelFactory, ScheduledExecutorService scheduledExecutorService) throws IOException {
        this.delegate = new SafeShutdownManagedChannel(channelFactory.createSingleChannel());
        this.channelFactory = channelFactory;
        this.scheduledExecutorService = scheduledExecutorService;
        this.lock = new ReentrantReadWriteLock();
        this.nextScheduledRefresh = this.scheduleNextRefresh();
    }

    private void refreshChannel() {
        SafeShutdownManagedChannel newChannel;
        try {
            newChannel = new SafeShutdownManagedChannel(this.channelFactory.createSingleChannel());
        }
        catch (IOException ioException) {
            LOG.log(Level.WARNING, "Failed to create a new channel when refreshing channel. This has no effect on the existing channels. The existing channel will continue to be used", ioException);
            return;
        }
        SafeShutdownManagedChannel oldChannel = this.delegate;
        this.lock.writeLock().lock();
        try {
            if (Thread.currentThread().isInterrupted()) {
                newChannel.shutdownNow();
                return;
            }
            this.delegate = newChannel;
            this.nextScheduledRefresh = this.scheduleNextRefresh();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        oldChannel.shutdownSafely();
    }

    private ScheduledFuture<?> scheduleNextRefresh() {
        long delayPeriod = refreshPeriod.toMillis();
        long jitter = (long)((Math.random() - 0.5) * 0.15 * (double)delayPeriod);
        long delay = jitter + delayPeriod;
        return this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                RefreshingManagedChannel.this.refreshChannel();
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        this.lock.readLock().lock();
        try {
            ClientCall<ReqT, RespT> clientCall = this.delegate.newCall(methodDescriptor, callOptions);
            return clientCall;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String authority() {
        return this.delegate.authority();
    }

    public ManagedChannel shutdown() {
        this.lock.readLock().lock();
        try {
            this.nextScheduledRefresh.cancel(true);
            this.delegate.shutdown();
            RefreshingManagedChannel refreshingManagedChannel = this;
            return refreshingManagedChannel;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ManagedChannel shutdownNow() {
        this.lock.readLock().lock();
        try {
            this.nextScheduledRefresh.cancel(true);
            this.delegate.shutdownNow();
            RefreshingManagedChannel refreshingManagedChannel = this;
            return refreshingManagedChannel;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isShutdown() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.isShutdown();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isTerminated() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.isTerminated();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.awaitTermination(timeout, unit);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

