/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit.reflect;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeParameterResolver {
    private final Map<TypeVariable<?>, Type> map;
    private final Set<Type> distinct;

    protected TypeParameterResolver(Map<TypeVariable<?>, Type> map) {
        this.map = map;
        this.distinct = new HashSet<Type>();
    }

    public static Type resolveClassIndexedParameter(Type type, Class<?> source, int index) {
        return TypeParameterResolver.calculateParameterValue(TypeParameterResolver.resolveParameterValues(type), source.getTypeParameters()[index]);
    }

    public static Type calculateParameterValue(Map<TypeVariable<?>, Type> map, TypeVariable<?> parameter) {
        Type res = map.get(parameter);
        while (res instanceof TypeVariable) {
            res = map.get(res);
        }
        return res;
    }

    public static Map<TypeVariable<?>, Type> resolveParameterValues(Type from) {
        HashMap map = new HashMap();
        new TypeParameterResolver(map).visitType(from);
        return map;
    }

    public void visitType(Type type) {
        if (!this.distinct.add(type)) {
            return;
        }
        if (type instanceof Class) {
            this.visitClass((Class)type);
            return;
        }
        if (type instanceof ParameterizedType) {
            this.visitParameterizedType((ParameterizedType)type);
        }
    }

    private void visitClass(Class<?> c) {
        this.visitType(c.getGenericSuperclass());
        for (Type i : c.getGenericInterfaces()) {
            this.visitType(i);
        }
    }

    private void visitParameterizedType(ParameterizedType parameterized) {
        Type raw = parameterized.getRawType();
        this.visitType(raw);
        if (raw instanceof GenericDeclaration) {
            GenericDeclaration declaration = (GenericDeclaration)((Object)raw);
            TypeVariable<?>[] parameters = declaration.getTypeParameters();
            Type[] arguments = parameterized.getActualTypeArguments();
            for (int i = 0; i < parameters.length; ++i) {
                TypeVariable<?> parameter = parameters[i];
                Type argument = arguments[i];
                this.map.put(parameter, argument);
                this.visitType(argument);
            }
        }
    }
}

