/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.AwareIconStyle;
import com.github.weisj.darklaf.icons.CustomThemedIcon;
import com.github.weisj.darklaf.icons.DarkSVGIcon;
import com.github.weisj.darklaf.icons.DarkUIAwareIcon;
import com.github.weisj.darklaf.icons.DerivableIcon;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.icons.LazyImageIcon;
import com.github.weisj.darklaf.icons.ThemedSVGIcon;
import com.github.weisj.darklaf.util.LazyValue;
import com.github.weisj.darklaf.util.LogUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class IconLoader {
    private static final Logger LOGGER = LogUtil.getLogger(IconLoader.class);
    private static final Map<Class<?>, IconLoader> iconLoaderMap = new HashMap();
    private static final LazyValue<IconLoader> instance = new LazyValue(() -> IconLoader.get(null));
    private static Object currentThemeKey;
    private static AwareIconStyle currentAwareStyle;
    private static final int DEFAULT_W = 16;
    private static final int DEFAULT_H = 16;
    private final Class<?> parentClass;
    private final Map<IconKey, DarkUIAwareIcon> awareIconMap = new HashMap<IconKey, DarkUIAwareIcon>();
    private final Map<IconKey, Icon> iconMap = new HashMap<IconKey, Icon>();

    private IconLoader(Class<?> parentClass) {
        this.parentClass = parentClass;
        iconLoaderMap.put(parentClass, this);
    }

    public static IconLoader get() {
        return (IconLoader)instance.get();
    }

    public static IconLoader get(Class<?> parentClass) {
        if (iconLoaderMap.containsKey(parentClass)) {
            return iconLoaderMap.get(parentClass);
        }
        IconLoader loader = new IconLoader(parentClass);
        iconLoaderMap.put(parentClass, loader);
        return loader;
    }

    public static void updateAwareStyle(AwareIconStyle style) {
        currentAwareStyle = style;
    }

    public static void updateThemeStatus(Object theme) {
        currentThemeKey = theme;
    }

    public static AwareIconStyle getAwareStyle() {
        return currentAwareStyle;
    }

    public static Object getThemeStatus() {
        return currentThemeKey;
    }

    public DarkUIAwareIcon getUIAwareIcon(String path) {
        return this.getUIAwareIcon(path, 16, 16);
    }

    public DarkUIAwareIcon getUIAwareIcon(String path, int w, int h) {
        IconKey key = new IconKey(path, w, h);
        if (this.awareIconMap.containsKey(key)) {
            return this.awareIconMap.get(key);
        }
        DarkUIAwareIcon icon = this.createUIAwareIcon(path, w, h);
        this.awareIconMap.put(key, icon);
        return icon;
    }

    protected DarkUIAwareIcon createUIAwareIcon(String name, int w, int h) {
        return new DarkUIAwareIcon("dark/" + name, "light/" + name, w, h, this.parentClass);
    }

    public Icon getIcon(String path) {
        return this.getIcon(path, 16, 16);
    }

    public Icon getIcon(String path, int w, int h) {
        return this.getIcon(path, w, h, false);
    }

    public Icon getIcon(String path, int w, int h, boolean themed) {
        Icon icon;
        IconKey key = new IconKey(path, w, h);
        if (this.iconMap.containsKey(key)) {
            return this.iconMap.get(key);
        }
        if (this.awareIconMap.containsKey(key)) {
            return this.awareIconMap.get(key);
        }
        key.w = -1;
        if (this.iconMap.containsKey(key) && (icon = this.iconMap.get(key)) instanceof DerivableIcon) {
            Object derived = ((DerivableIcon)icon).derive(w, h);
            key.w = w;
            this.iconMap.put(key, (Icon)derived);
            return derived;
        }
        key.w = w;
        if (path.endsWith(".svg")) {
            icon = this.loadSVGIcon(path, w, h, themed);
            this.iconMap.put(key, icon);
            return icon;
        }
        icon = new LazyImageIcon(path, key, this.parentClass);
        this.iconMap.put(key, icon);
        return icon;
    }

    public Icon loadSVGIcon(String path, boolean themed) {
        return this.loadSVGIcon(path, 16, 16, themed);
    }

    public Icon loadSVGIcon(String path, int w, int h, boolean themed) {
        return this.loadSVGIcon(path, w, h, themed, null);
    }

    public Icon loadSVGIcon(String path, int w, int h, boolean themed, Map<Object, Object> propertyMap) {
        try {
            if (themed) {
                URI uri = Objects.requireNonNull(this.getResource(path).toURI());
                if (propertyMap != null) {
                    return new CustomThemedIcon(uri, w, h, propertyMap);
                }
                return new ThemedSVGIcon(uri, w, h);
            }
            return new DarkSVGIcon(Objects.requireNonNull(this.getResource(path).toURI()), w, h);
        }
        catch (NullPointerException | URISyntaxException e) {
            LOGGER.log(Level.SEVERE, "Exception while loading '" + path + "'. Resolving from " + this.parentClass, e.getStackTrace());
            return EmptyIcon.create(0);
        }
    }

    public ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        LOGGER.severe("Could not find icon file: '" + path + "'");
        return null;
    }

    protected URL getResource(String name) {
        if (this.parentClass != null) {
            return this.parentClass.getResource(name);
        }
        return this.getClass().getClassLoader().getResource(name);
    }

    protected static final class IconKey {
        final String path;
        int w;
        int h;

        private IconKey(String path, int w, int h) {
            this.path = path;
            this.w = w;
            this.h = h;
        }

        public int hashCode() {
            return Objects.hash(this.path, this.w, this.h);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IconKey iconKey = (IconKey)o;
            if (iconKey.w == -1 || iconKey.h == -1) {
                return Objects.equals(this.path, iconKey.path);
            }
            if (this.w != iconKey.w) {
                return false;
            }
            if (this.h != iconKey.h) {
                return false;
            }
            return Objects.equals(this.path, iconKey.path);
        }

        public String toString() {
            return "[path=" + this.path + ", w=" + this.w + ", h=" + this.h + "]";
        }
    }
}

