/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.delegate.ScrollLayoutManagerDelegate;
import com.github.weisj.darklaf.ui.scrollpane.ScrollBarUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class DarkScrollPaneUI
extends BasicScrollPaneUI {
    public static final String KEY_VERTICALS_SCROLL_BAR = "verticalScrollBar";
    public static final String KEY_HORIZONTAL_SCROLL_BAR = "horizontalScrollBar";
    private final MouseWheelListener verticalMouseWheelListener = e -> {
        if (!this.scrollpane.isWheelScrollingEnabled() || e.getModifiersEx() == 0 || !this.horizontalScrollBarEnabled()) {
            return;
        }
        JScrollBar scrollbar = this.scrollpane.getHorizontalScrollBar();
        scrollbar.setValueIsAdjusting(true);
        ScrollBarUtil.doScroll(scrollbar, this.scrollpane.getViewport(), e, this.scrollpane.getComponentOrientation().isLeftToRight());
        scrollbar.setValueIsAdjusting(false);
    };
    private final MouseWheelListener horizontalMouseWheelListener = e -> {
        if (!this.scrollpane.isWheelScrollingEnabled() || e.isShiftDown() || !this.verticalScrollBarEnabled()) {
            return;
        }
        JScrollBar scrollbar = this.scrollpane.getVerticalScrollBar();
        scrollbar.setValueIsAdjusting(true);
        ScrollBarUtil.doScroll(scrollbar, this.scrollpane.getViewport(), e, this.scrollpane.getComponentOrientation().isLeftToRight());
        scrollbar.setValueIsAdjusting(false);
    };
    private final MouseWheelListener mouseWheelListener = e -> {
        if (!this.scrollpane.isWheelScrollingEnabled()) {
            return;
        }
        JScrollBar scrollbar = e.isShiftDown() ? this.scrollpane.getHorizontalScrollBar() : this.scrollpane.getVerticalScrollBar();
        scrollbar.setValueIsAdjusting(true);
        ScrollBarUtil.doScroll(scrollbar, this.scrollpane.getViewport(), e, this.scrollpane.getComponentOrientation().isLeftToRight());
        scrollbar.setValueIsAdjusting(false);
    };
    private final PropertyChangeListener propertyChangeListener = e -> {
        if (e.getSource() == this.scrollpane) {
            String propertyName = e.getPropertyName();
            if (KEY_VERTICALS_SCROLL_BAR.equals(propertyName)) {
                Object old = e.getOldValue();
                Object newVal = e.getNewValue();
                if (old instanceof JScrollBar) {
                    ((JScrollBar)old).removeMouseWheelListener(this.verticalMouseWheelListener);
                }
                if (newVal instanceof JScrollBar) {
                    ((JScrollBar)newVal).addMouseWheelListener(this.verticalMouseWheelListener);
                }
            } else if (KEY_HORIZONTAL_SCROLL_BAR.equals(propertyName)) {
                Object old = e.getOldValue();
                Object newVal = e.getNewValue();
                if (old instanceof JScrollBar) {
                    ((JScrollBar)old).removeMouseWheelListener(this.horizontalMouseWheelListener);
                }
                if (newVal instanceof JScrollBar) {
                    ((JScrollBar)newVal).addMouseWheelListener(this.horizontalMouseWheelListener);
                }
            }
        }
    };
    private ScrollPaneLayout oldLayout;

    public static ComponentUI createUI(JComponent c) {
        return new DarkScrollPaneUI();
    }

    private boolean horizontalScrollBarEnabled() {
        JScrollBar sb = this.scrollpane.getHorizontalScrollBar();
        if (sb == null) {
            return false;
        }
        return sb.isVisible();
    }

    private boolean verticalScrollBarEnabled() {
        JScrollBar sb = this.scrollpane.getVerticalScrollBar();
        if (sb == null) {
            return false;
        }
        return sb.isVisible();
    }

    @Override
    protected void installListeners(JScrollPane c) {
        super.installListeners(c);
        this.scrollpane.addPropertyChangeListener(this.propertyChangeListener);
        this.scrollpane.getVerticalScrollBar().addMouseWheelListener(this.verticalMouseWheelListener);
        this.scrollpane.getHorizontalScrollBar().addMouseWheelListener(this.horizontalMouseWheelListener);
    }

    @Override
    public void installUI(JComponent x) {
        super.installUI(x);
        this.oldLayout = (ScrollPaneLayout)x.getLayout();
        while (this.oldLayout instanceof ScrollLayoutManagerDelegate) {
            this.oldLayout = ((ScrollLayoutManagerDelegate)this.oldLayout).getDelegate();
        }
        if (this.oldLayout != null) {
            x.setLayout(new ScrollLayoutManagerDelegate(this.oldLayout){

                @Override
                public void layoutContainer(Container parent) {
                    Insets barInsets;
                    JScrollBar hsb;
                    super.layoutContainer(parent);
                    JScrollBar vsb = DarkScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                    if (vsb == null) {
                        vsb = DarkScrollPaneUI.this.scrollpane.createHorizontalScrollBar();
                        DarkScrollPaneUI.this.scrollpane.setHorizontalScrollBar(vsb);
                    }
                    if ((hsb = DarkScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) == null) {
                        hsb = DarkScrollPaneUI.this.scrollpane.createHorizontalScrollBar();
                        DarkScrollPaneUI.this.scrollpane.setHorizontalScrollBar(hsb);
                    }
                    Component lowerRight = DarkScrollPaneUI.this.scrollpane.getCorner("LOWER_RIGHT_CORNER");
                    Component lowerLeft = DarkScrollPaneUI.this.scrollpane.getCorner("LOWER_LEFT_CORNER");
                    Rectangle vertBounds = vsb.getBounds();
                    Rectangle horBounds = hsb.getBounds();
                    if (parent.getComponentOrientation().isLeftToRight()) {
                        if (lowerRight == null && hsb.isVisible()) {
                            vertBounds.height += horBounds.height;
                        }
                    } else if (lowerLeft == null && hsb.isVisible()) {
                        vertBounds.height += horBounds.height;
                    }
                    if ((barInsets = UIManager.getInsets("ScrollPane.barInsets")) != null) {
                        vertBounds.height -= barInsets.top + barInsets.bottom;
                        vertBounds.y += barInsets.top;
                        horBounds.width -= barInsets.left + barInsets.right;
                        horBounds.x += barInsets.left;
                    }
                    vsb.setBounds(vertBounds);
                    hsb.setBounds(horBounds);
                }
            });
        }
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners(c);
        this.scrollpane.addPropertyChangeListener(this.propertyChangeListener);
        this.scrollpane.getVerticalScrollBar().removeMouseWheelListener(this.verticalMouseWheelListener);
        this.scrollpane.getHorizontalScrollBar().removeMouseWheelListener(this.horizontalMouseWheelListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setLayout(this.oldLayout);
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        return this.mouseWheelListener;
    }
}

