/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.optionpane;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import sun.swing.DefaultLookup;

public class DarkOptionPaneUI
extends BasicOptionPaneUI {
    public static ComponentUI createUI(JComponent x) {
        return new DarkOptionPaneUI();
    }

    @Override
    protected Container createButtonArea() {
        JPanel bottom = new JPanel();
        Border border = (Border)DefaultLookup.get(this.optionPane, this, "OptionPane.buttonAreaBorder");
        bottom.setName("OptionPane.buttonArea");
        if (border != null) {
            bottom.setBorder(border);
        }
        bottom.setLayout(new DarkButtonAreaLayout(DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.sameSizeButtons", false), DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonPadding", 6), DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonOrientation", 0), DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.isYesLast", false)));
        this.addButtonComponents(bottom, this.getButtons(), this.getInitialValueIndex());
        return bottom;
    }

    @Override
    protected boolean getSizeButtonsToSameWidth() {
        return UIManager.getBoolean("OptionPane.sameSizeButtons");
    }

    public static class DarkButtonAreaLayout
    extends BasicOptionPaneUI.ButtonAreaLayout {
        protected boolean syncAllWidthOverwrite = false;
        private int orientation;
        private boolean reverseButtons;
        private boolean useOrientation;

        public DarkButtonAreaLayout(boolean syncAllSizes, int padding, int orientation, boolean reverseButtons) {
            this(syncAllSizes, padding);
            this.useOrientation = true;
            this.orientation = orientation;
            this.reverseButtons = reverseButtons;
        }

        public DarkButtonAreaLayout(boolean syncAllWidths, int padding) {
            super(syncAllWidths, padding);
            this.syncAllWidths = syncAllWidths;
            this.padding = padding;
            this.centersChildren = true;
            this.useOrientation = false;
        }

        @Override
        public void setSyncAllWidths(boolean newValue) {
            this.syncAllWidths = newValue;
        }

        @Override
        public boolean getSyncAllWidths() {
            return this.syncAllWidths && !this.syncAllWidthOverwrite;
        }

        @Override
        public void setPadding(int newPadding) {
            this.padding = newPadding;
        }

        @Override
        public int getPadding() {
            return this.padding;
        }

        @Override
        public void setCentersChildren(boolean newValue) {
            this.centersChildren = newValue;
            this.useOrientation = false;
        }

        @Override
        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        private int getOrientation(Container container) {
            if (!this.useOrientation) {
                return 0;
            }
            if (container.getComponentOrientation().isLeftToRight()) {
                return this.orientation;
            }
            switch (this.orientation) {
                case 2: {
                    return 4;
                }
                case 4: {
                    return 2;
                }
                case 0: {
                    return 0;
                }
            }
            return 2;
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int numChildren = children.length;
                Insets insets = container.getInsets();
                int maxWidth = 0;
                int maxHeight = 0;
                int totalButtonWidth = 0;
                int x = 0;
                int xOffset = 0;
                boolean ltr = container.getComponentOrientation().isLeftToRight();
                boolean reverse = ltr == this.reverseButtons;
                for (Component child : children) {
                    Dimension pref = child.getPreferredSize();
                    maxWidth = Math.max(maxWidth, pref.width);
                    maxHeight = Math.max(maxHeight, pref.height);
                    totalButtonWidth += pref.width;
                }
                if (this.getSyncAllWidths()) {
                    int totalButtonWidthTmp = maxWidth * numChildren;
                    boolean bl = this.syncAllWidthOverwrite = (totalButtonWidthTmp += (numChildren - 1) * this.padding) > container.getWidth();
                    if (!this.syncAllWidthOverwrite) {
                        totalButtonWidth = totalButtonWidthTmp;
                    }
                } else {
                    totalButtonWidth += (numChildren - 1) * this.padding;
                }
                switch (this.getOrientation(container)) {
                    case 2: {
                        x = insets.left;
                        break;
                    }
                    case 4: {
                        x = container.getWidth() - insets.right - totalButtonWidth;
                        break;
                    }
                    case 0: {
                        if (this.getCentersChildren() || numChildren < 2) {
                            x = (container.getWidth() - totalButtonWidth) / 2;
                            break;
                        }
                        x = insets.left;
                        xOffset = this.getSyncAllWidths() ? (container.getWidth() - insets.left - insets.right - totalButtonWidth) / (numChildren - 1) + maxWidth : (container.getWidth() - insets.left - insets.right - totalButtonWidth) / (numChildren - 1);
                    }
                }
                for (int counter = 0; counter < numChildren; ++counter) {
                    int index = reverse ? numChildren - counter - 1 : counter;
                    Dimension pref = children[index].getPreferredSize();
                    if (this.getSyncAllWidths()) {
                        children[index].setBounds(x, insets.top, maxWidth, maxHeight);
                    } else {
                        children[index].setBounds(x, insets.top, pref.width, pref.height);
                    }
                    if (xOffset != 0) {
                        x += xOffset;
                        continue;
                    }
                    x += children[index].getWidth() + this.padding;
                }
            }
            this.syncAllWidthOverwrite = false;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                if (this.getSyncAllWidths()) {
                    int maxWidth = 0;
                    for (Component child : children) {
                        Dimension aSize = child.getPreferredSize();
                        height = Math.max(height, aSize.height);
                        maxWidth = Math.max(maxWidth, aSize.width);
                    }
                    return new Dimension(extraWidth + maxWidth * numChildren + (numChildren - 1) * this.padding, extraHeight + height);
                }
                int totalWidth = 0;
                for (Component child : children) {
                    Dimension aSize = child.getPreferredSize();
                    height = Math.max(height, aSize.height);
                    totalWidth += aSize.width;
                }
                return new Dimension(extraWidth + (totalWidth += (numChildren - 1) * this.padding), extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }
}

