/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.task.FontMapper;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.UIDefaults;

public class PropertyFontMapper
implements FontMapper {
    private static final Logger LOGGER = LogUtil.getLogger(PropertyFontMapper.class);
    private Theme lastTheme = null;
    private int adjustment;
    private String propertyKey;

    public PropertyFontMapper() {
        this(null);
    }

    public PropertyFontMapper(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    @Override
    public Font map(Font font, UIDefaults defaults) {
        if (this.propertyKey == null) {
            return font;
        }
        this.adjustment = this.getSize(defaults);
        if (this.adjustment == 0) {
            return font;
        }
        if ((float)this.adjustment + font.getSize2D() <= 0.0f) {
            if (this.adjustment != Integer.MIN_VALUE) {
                LOGGER.warning("Font " + font + " would be invisible after applying an adjustment of " + this.adjustment + ". Aborting!");
            }
            return font;
        }
        return font.deriveFont(font.getSize2D() + (float)this.adjustment);
    }

    private int getSize(UIDefaults defaults) {
        if (this.lastTheme == LafManager.getTheme()) {
            return this.adjustment;
        }
        this.lastTheme = LafManager.getTheme();
        Object obj = defaults.get(this.propertyKey);
        if (!(obj instanceof Integer)) {
            LOGGER.warning("Font size property '" + this.propertyKey + "' not specified. Mapper will do nothing");
            return Integer.MIN_VALUE;
        }
        return (Integer)obj;
    }
}

