/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.ColoredRadioButton;
import com.github.weisj.darklaf.components.color.QuickColorChooser;
import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.components.tristate.TristateCheckBox;
import com.github.weisj.darklaf.components.tristate.TristateState;
import com.github.weisj.darklaf.graphics.ThemedColor;
import com.github.weisj.darklaf.platform.ThemePreferencesHandler;
import com.github.weisj.darklaf.platform.macos.theme.MacOSColors;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.FontSizePreset;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.ui.slider.DarkSliderUI;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.SliderUI;

public class ThemeSettingsPanel
extends JPanel {
    private final ResourceBundle resourceBundle;
    private Icon icon;
    private JCheckBox fontSizeFollowsSystem;
    private JCheckBox accentColorFollowsSystem;
    private JCheckBox selectionColorFollowsSystem;
    private JComboBox<Theme> themeComboBox;
    private JCheckBox themeFollowsSystem;
    private JSlider fontSlider;
    private TristateCheckBox enabledSystemPreferences;
    private ButtonGroup bgSelection;
    private ButtonGroup bgAccent;
    private boolean followFontSize;
    private boolean followAccentColor;
    private boolean followSelectionColor;
    private boolean followTheme;
    private boolean systemPreferences;
    private Color defaultAccentColor;
    private Color defaultSelectionColor;
    private ColoredRadioButton customAccent;
    private ColoredRadioButton defaultAccent;
    private ColoredRadioButton customSelection;
    private ColoredRadioButton defaultSelection;

    public ThemeSettingsPanel(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(this.createGeneralSettings(), "Center");
        this.add(this.createMonitorSettings(), "South");
        this.fetch(true);
        this.update();
    }

    public void saveSettings() {
        this.systemPreferences = !this.enabledSystemPreferences.getTristateModel().isDeselected();
        this.followTheme = this.fontSizeFollowsSystem.isSelected();
        this.followAccentColor = this.accentColorFollowsSystem.isSelected();
        this.followSelectionColor = this.selectionColorFollowsSystem.isSelected();
        this.followFontSize = this.fontSizeFollowsSystem.isSelected();
        LafManager.enabledPreferenceChangeReporting(!this.enabledSystemPreferences.getTristateModel().isDeselected());
    }

    public void discardChanges() {
        this.setFontSizeFollowsSystem(this.followFontSize);
        this.setThemeFollowsSystem(this.followTheme);
        this.setAccentColorFollowsSystem(this.followAccentColor);
        this.setSelectionColorFollowsSystem(this.followSelectionColor);
        this.setEnabledSystemPreferences(this.systemPreferences);
    }

    private void update() {
        Theme selectedTheme = (Theme)this.themeComboBox.getSelectedItem();
        if (selectedTheme == null) {
            selectedTheme = LafManager.getTheme();
        }
        boolean enabled = !this.enabledSystemPreferences.getTristateModel().isDeselected();
        this.themeFollowsSystem.setEnabled(enabled);
        this.accentColorFollowsSystem.setEnabled(enabled);
        this.selectionColorFollowsSystem.setEnabled(enabled);
        this.fontSizeFollowsSystem.setEnabled(enabled);
        if (this.enabledSystemPreferences.isSelected()) {
            this.themeFollowsSystem.setSelected(this.themeFollowsSystem.isSelected() && this.themeFollowsSystem.isEnabled());
            this.accentColorFollowsSystem.setSelected(this.accentColorFollowsSystem.isSelected() && this.accentColorFollowsSystem.isEnabled());
            this.selectionColorFollowsSystem.setSelected(this.selectionColorFollowsSystem.isSelected() && this.selectionColorFollowsSystem.isEnabled());
            this.fontSizeFollowsSystem.setSelected(this.fontSizeFollowsSystem.isSelected() && this.fontSizeFollowsSystem.isEnabled());
        }
        this.enabledSystemPreferences.setEnabled(ThemePreferencesHandler.getSharedInstance().canReport());
        this.themeComboBox.setEnabled(!this.isThemeFollowsSystem() || !this.isSystemPreferencesEnabled());
        this.setEnabledSystemPreferences(this.isSystemPreferencesEnabled());
        this.enableButtonGroup(this.bgAccent, selectedTheme.supportsCustomAccentColor() && !this.accentColorFollowsSystem.isSelected());
        this.enableButtonGroup(this.bgSelection, selectedTheme.supportsCustomSelectionColor() && !this.selectionColorFollowsSystem.isSelected());
        this.fontSlider.setEnabled(!this.isFontSizeFollowsSystem() || !this.isSystemPreferencesEnabled());
    }

    protected void fetch(PreferredThemeStyle themeStyle, boolean ignoreSettings) {
        Theme theme = LafManager.themeForPreferredStyle(themeStyle);
        this.fetch(theme, ignoreSettings);
    }

    protected void fetch(Theme theme, boolean ignoreSettings) {
        Theme selectedTheme = (Theme)this.themeComboBox.getSelectedItem();
        Theme currentTheme = LafManager.getTheme();
        this.themeComboBox.setModel(LafManager.getThemeComboBoxModel());
        if (ignoreSettings || this.isThemeFollowsSystem()) {
            this.setTheme(this.isThemeFollowsSystem() ? theme : currentTheme);
        } else {
            this.themeComboBox.setSelectedItem(selectedTheme);
        }
        if (ignoreSettings || this.isFontSizeFollowsSystem()) {
            this.setFontSizeRule(this.isFontSizeFollowsSystem() ? theme.getFontSizeRule() : currentTheme.getFontSizeRule());
        }
        if (ignoreSettings || this.isAccentColorFollowsSystem()) {
            this.setAccentColor(this.getAccentColor(this.isAccentColorFollowsSystem() ? theme : currentTheme, true));
        }
        if (ignoreSettings || this.isSelectionColorFollowsSystem()) {
            this.setSelectionColor(this.getSelectionColor(this.isSelectionColorFollowsSystem() ? theme : currentTheme, true));
        }
        if (!ignoreSettings) {
            this.setEnabledSystemPreferences(LafManager.isPreferenceChangeReportingEnabled());
        }
        this.update();
    }

    public void fetch(PreferredThemeStyle themeStyle) {
        this.fetch(themeStyle, false);
    }

    public void fetch(boolean ignoreSettings) {
        this.fetch(LafManager.getPreferredThemeStyle(), ignoreSettings);
    }

    private boolean updateButtonGroup(ButtonGroup bg, Color currentColor, AbstractButton defaultButton, Color defaultColor) {
        Enumeration<AbstractButton> buttons = bg.getElements();
        while (buttons.hasMoreElements()) {
            ColoredRadioButton radioButton = (ColoredRadioButton)buttons.nextElement();
            boolean selected = Objects.equals(radioButton.getColor(), currentColor) || radioButton == defaultButton && Objects.equals(defaultColor, currentColor);
            bg.setSelected(radioButton.getModel(), selected);
            if (!selected) continue;
            return true;
        }
        return false;
    }

    public Theme getEffectiveTheme(PreferredThemeStyle preferredThemeStyle) {
        Theme theme = this.getTheme(preferredThemeStyle);
        if (theme == null) {
            return null;
        }
        FontSizeRule fontSizeRule = this.getFontSizeRule(theme, preferredThemeStyle);
        AccentColorRule accentColorRule = this.getAccentColorRule(theme);
        return theme.derive(fontSizeRule, accentColorRule);
    }

    public Theme getEffectiveTheme() {
        return this.getEffectiveTheme(LafManager.getPreferredThemeStyle());
    }

    protected Color getSelectedColor(ButtonGroup bg, AbstractButton defaultButton) {
        Enumeration<AbstractButton> enumeration = bg.getElements();
        while (enumeration.hasMoreElements()) {
            ColoredRadioButton button = (ColoredRadioButton)enumeration.nextElement();
            if (!button.isSelected()) continue;
            Color c = button.getColor();
            return button != defaultButton ? c : null;
        }
        return null;
    }

    private Component createGeneralSettings() {
        JLabel themeLabel = new JLabel(this.resourceBundle.getString("label_theme"));
        this.themeComboBox = new JComboBox<Theme>(LafManager.getThemeComboBoxModel());
        this.themeComboBox.setSelectedItem(LafManager.getTheme());
        this.themeComboBox.putClientProperty("JComboBox.isTableCellEditor", true);
        this.themeComboBox.addItemListener(e -> this.update());
        themeLabel.setLabelFor(this.themeComboBox);
        JPanel themeBox = new JPanel(new FlowLayout(0));
        themeBox.setAlignmentX(0.0f);
        themeBox.add(themeLabel);
        themeBox.add(this.themeComboBox);
        this.add(themeBox);
        Color currentAccentColor = LafManager.getTheme().getAccentColorRule().getAccentColor();
        Color currentSelectionColor = LafManager.getTheme().getAccentColorRule().getSelectionColor();
        JPanel accentBox = new JPanel(new FlowLayout(0, 0, 0));
        JLabel accentColorLabel = new JLabel(this.resourceBundle.getString("label_accent_color"));
        accentColorLabel.setLabelFor(accentBox);
        this.defaultAccentColor = this.createDefaultColor("widgetFillDefault");
        this.bgAccent = new ButtonGroup();
        this.defaultAccent = this.addColoredButton(this.bgAccent, (JComponent)accentBox, ColoredRadioButton.DEFAULT_FILLED, this.resourceBundle.getString("color_default"));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.BLUE, this.resourceBundle.getString("color_Blue"));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.LILAC, this.resourceBundle.getString("color_lilac"));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ROSE, this.resourceBundle.getString("color_rose"));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.RED, this.resourceBundle.getString("color_red"));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.ORANGE, this.resourceBundle.getString("color_orange"));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.YELLOW, this.resourceBundle.getString("color_yellow"));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.GREEN, this.resourceBundle.getString("color_green"));
        this.addColoredButton(this.bgAccent, (JComponent)accentBox, MacOSColors.GRAY, this.resourceBundle.getString("color_gray"));
        this.customAccent = this.addCustomButton(this.bgAccent, accentBox, currentAccentColor, this.defaultAccentColor, this.resourceBundle.getString("color_custom"));
        JPanel selectionBox = new JPanel(new FlowLayout(0, 0, 0));
        JLabel selectionColorLabel = new JLabel(this.resourceBundle.getString("label_selection_color"));
        selectionColorLabel.setLabelFor(selectionBox);
        this.bgSelection = new ButtonGroup();
        this.defaultSelectionColor = this.createDefaultColor("textCompSelectionBackground");
        this.defaultSelection = this.addColoredButton(this.bgSelection, (JComponent)selectionBox, this.defaultSelectionColor, this.resourceBundle.getString("color_default"));
        this.customSelection = this.addCustomButton(this.bgSelection, selectionBox, currentSelectionColor, this.defaultSelectionColor, this.resourceBundle.getString("color_custom"));
        this.fontSlider = this.createFontSlider();
        JLabel fontSizeLabel = new JLabel(this.resourceBundle.getString("label_font_size"));
        fontSizeLabel.setLabelFor(this.fontSlider);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("title_general")));
        panel.add(this.getTwoColumnLayout(new JLabel[]{themeLabel, accentColorLabel, selectionColorLabel, fontSizeLabel}, new JComponent[]{this.themeComboBox, accentBox, selectionBox, this.fontSlider}));
        return panel;
    }

    protected ColoredRadioButton addCustomButton(ButtonGroup bg, JComponent parent, Color currentColor, Color defaultColor, String tipText) {
        Supplier<Color> supplier = () -> Optional.ofNullable(currentColor).orElse(defaultColor);
        ColoredRadioButton button = this.addColoredButton(bg, parent, supplier, tipText);
        QuickColorChooser.attachToComponent(button, button::setColor, () -> Optional.ofNullable(button.getColor()).orElse((Color)supplier.get()), button::isSelected);
        return button;
    }

    protected Color createDefaultColor(final String key) {
        return new ThemedColor(){
            private final Properties props = new Properties();
            private final UIDefaults defaults = new UIDefaults();

            @Override
            protected Color getUpdatedColor() {
                LafManager.getTheme().loadDefaults(this.props, this.defaults);
                Object obj = this.props.get(key);
                this.props.clear();
                this.defaults.clear();
                return obj instanceof Color ? (Color)obj : null;
            }
        };
    }

    public boolean isSystemPreferencesEnabled() {
        return !this.enabledSystemPreferences.getTristateModel().isDeselected() && this.enabledSystemPreferences.isEnabled();
    }

    public boolean isAccentColorFollowsSystem() {
        return this.accentColorFollowsSystem.isSelected() && this.accentColorFollowsSystem.isEnabled();
    }

    public boolean isFontSizeFollowsSystem() {
        return this.fontSizeFollowsSystem.isSelected() && this.fontSizeFollowsSystem.isEnabled();
    }

    public boolean isSelectionColorFollowsSystem() {
        return this.selectionColorFollowsSystem.isSelected() && this.selectionColorFollowsSystem.isEnabled();
    }

    public boolean isThemeFollowsSystem() {
        return this.themeFollowsSystem.isSelected() && this.themeFollowsSystem.isEnabled();
    }

    public Theme getTheme() {
        return this.getTheme(LafManager.getPreferredThemeStyle());
    }

    protected Theme getTheme(PreferredThemeStyle preferredThemeStyle) {
        return this.isThemeFollowsSystem() ? LafManager.themeForPreferredStyle(preferredThemeStyle) : (Theme)this.themeComboBox.getSelectedItem();
    }

    public FontSizeRule getFontSizeRule() {
        PreferredThemeStyle preferredThemeStyle = LafManager.getPreferredThemeStyle();
        return this.getFontSizeRule(this.getTheme(preferredThemeStyle), preferredThemeStyle);
    }

    protected FontSizeRule getFontSizeRule(Theme theme, PreferredThemeStyle preferredThemeStyle) {
        if (theme == null) {
            return FontSizeRule.getDefault();
        }
        return this.isFontSizeFollowsSystem() ? preferredThemeStyle.getFontSizeRule() : FontSizeRule.relativeAdjustment((int)this.fontSlider.getValue());
    }

    public AccentColorRule getAccentColorRule() {
        PreferredThemeStyle preferredThemeStyle = LafManager.getPreferredThemeStyle();
        return this.getAccentColorRule(this.getTheme(preferredThemeStyle));
    }

    protected AccentColorRule getAccentColorRule(Theme theme) {
        if (theme == null) {
            return AccentColorRule.getDefault();
        }
        Color accentColor = this.getAccentColor(theme, this.isAccentColorFollowsSystem());
        Color selectionColor = this.getSelectionColor(theme, this.isSelectionColorFollowsSystem());
        return AccentColorRule.fromColor((Color)accentColor, (Color)selectionColor);
    }

    protected Color getAccentColor(Theme theme, boolean useThemeColor) {
        return theme.supportsCustomAccentColor() ? (useThemeColor ? theme.getAccentColorRule().getAccentColor() : this.getSelectedColor(this.bgAccent, this.defaultAccent)) : null;
    }

    protected Color getSelectionColor(Theme theme, boolean useThemeColor) {
        return theme.supportsCustomSelectionColor() ? (useThemeColor ? theme.getAccentColorRule().getSelectionColor() : this.getSelectedColor(this.bgSelection, this.defaultSelection)) : null;
    }

    public void setEnabledSystemPreferences(boolean enabled) {
        TristateState state = TristateState.DESELECTED;
        if (!(!enabled || !this.isFontSizeFollowsSystem() && this.fontSizeFollowsSystem.isEnabled() || !this.isThemeFollowsSystem() && this.themeFollowsSystem.isEnabled() || !this.isAccentColorFollowsSystem() && this.accentColorFollowsSystem.isEnabled() || !this.isSelectionColorFollowsSystem() && this.selectionColorFollowsSystem.isEnabled())) {
            state = TristateState.SELECTED;
        } else if (enabled) {
            this.enabledSystemPreferences.getTristateModel().setIndeterminate();
            return;
        }
        this.enabledSystemPreferences.getTristateModel().setState(state);
    }

    public void setAccentColorFollowsSystem(boolean accentColorFollowsSystem) {
        this.accentColorFollowsSystem.setSelected(accentColorFollowsSystem);
    }

    public void setFontSizeFollowsSystem(boolean fontSizeFollowsSystem) {
        this.fontSizeFollowsSystem.setSelected(fontSizeFollowsSystem);
    }

    public void setSelectionColorFollowsSystem(boolean selectionColorFollowsSystem) {
        this.selectionColorFollowsSystem.setSelected(selectionColorFollowsSystem);
    }

    public void setThemeFollowsSystem(boolean themeFollowsSystem) {
        this.themeFollowsSystem.setSelected(themeFollowsSystem);
    }

    public void setTheme(Theme theme) {
        this.themeComboBox.setSelectedItem(LafManager.getClosestMatchForTheme(theme));
    }

    public void setAccentColorRule(AccentColorRule accentColorRule) {
        this.setAccentColorRule(accentColorRule.getAccentColor(), accentColorRule.getSelectionColor());
    }

    protected void setAccentColorRule(Color accentColor, Color selectionColor) {
        this.setAccentColor(accentColor);
        this.setSelectionColor(selectionColor);
    }

    protected void setAccentColor(Color accentColor) {
        this.setXColor(accentColor, this.bgAccent, this.customAccent, this.defaultAccent, this.defaultAccentColor);
    }

    protected void setSelectionColor(Color selectionColor) {
        this.setXColor(selectionColor, this.bgSelection, this.customSelection, this.defaultSelection, this.defaultSelectionColor);
    }

    protected void setXColor(Color color, ButtonGroup bg, ColoredRadioButton customButton, ColoredRadioButton defaultButton, Color defaultColor) {
        if (color == null) {
            defaultButton.setSelected(true);
            return;
        }
        if (!this.updateButtonGroup(bg, color, defaultButton, defaultColor)) {
            customButton.setSelected(true);
            if (customButton.getColor() == null) {
                customButton.setColor(color);
            }
        }
    }

    public void setFontSizeRule(FontSizeRule fontSizeRule) {
        if (fontSizeRule == null) {
            this.fontSlider.setValue(FontSizePreset.NORMAL.getPercentage());
        } else {
            this.fontSlider.setValue(fontSizeRule.getPercentage());
        }
    }

    private JSlider createFontSlider() {
        JSlider fontSlider = new JSlider(){

            @Override
            public String getToolTipText(MouseEvent event) {
                return this.getValue() + "%";
            }
        };
        ToolTipContext context = new ToolTipContext().setAlignment(Alignment.CENTER).setCenterAlignment(Alignment.NORTH).setUseBestFit(true).setToolTipRectSupplier(e -> {
            SliderUI ui = fontSlider.getUI();
            if (ui instanceof DarkSliderUI) {
                Rectangle r = ((DarkSliderUI)ui).getThumbRect();
                --r.x;
                return r;
            }
            return new Rectangle(0, 0, fontSlider.getWidth(), fontSlider.getHeight());
        });
        fontSlider.putClientProperty("JSlider.instantScrollEnabled", true);
        fontSlider.putClientProperty("JToolTip.toolTipContext", context);
        fontSlider.putClientProperty("JToolTip.style", "balloon");
        fontSlider.setToolTipText(String.valueOf(fontSlider.getValue()));
        fontSlider.setOrientation(0);
        fontSlider.setPaintTicks(true);
        fontSlider.setMinimum(FontSizePreset.TINY.getPercentage());
        fontSlider.setMaximum(FontSizePreset.HUGE.getPercentage());
        int tickSpacing = 25;
        Hashtable<Integer, JComponent> dict = fontSlider.createStandardLabels(tickSpacing);
        JLabel min = (JLabel)((Dictionary)dict).get(fontSlider.getMinimum());
        min.setText(this.resourceBundle.getString("label_font_smaller"));
        min.setAlignmentX(0.0f);
        min.putClientProperty("JSlider.manualLabelAlign", true);
        JLabel mid = (JLabel)((Dictionary)dict).get(fontSlider.getMinimum() + tickSpacing);
        ((Dictionary)dict).remove(fontSlider.getMinimum() + tickSpacing);
        ((Dictionary)dict).put(FontSizePreset.NORMAL.getPercentage(), mid);
        mid.setText(this.resourceBundle.getString("label_font_default"));
        mid.setAlignmentX(0.5f);
        mid.setHorizontalTextPosition(4);
        JLabel max = (JLabel)((Dictionary)dict).get(fontSlider.getMaximum());
        max.putClientProperty("JSlider.manualLabelAlign", true);
        max.setText(this.resourceBundle.getString("label_font_bigger"));
        max.setAlignmentX(1.0f);
        max.putClientProperty("JSlider.manualLabelAlign", true);
        ((Dictionary)dict).remove(FontSizePreset.Small.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.SMALL.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.Large.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.LARGE.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.Huge.getPercentage());
        fontSlider.setLabelTable(dict);
        fontSlider.setMajorTickSpacing(tickSpacing);
        fontSlider.setMinorTickSpacing(tickSpacing);
        fontSlider.setPaintLabels(true);
        fontSlider.setSnapToTicks(true);
        return fontSlider;
    }

    private Component createMonitorSettings() {
        this.accentColorFollowsSystem = new JCheckBox(this.resourceBundle.getString("check_system_accent_color")){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && ThemePreferencesHandler.getSharedInstance().supportsNativeAccentColor();
                super.setEnabled(enabled);
            }
        };
        this.accentColorFollowsSystem.setEnabled(false);
        this.accentColorFollowsSystem.setSelected(false);
        this.selectionColorFollowsSystem = new JCheckBox(this.resourceBundle.getString("check_system_selection_color")){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && ThemePreferencesHandler.getSharedInstance().supportsNativeSelectionColor();
                super.setEnabled(enabled);
            }
        };
        this.selectionColorFollowsSystem.setEnabled(false);
        this.selectionColorFollowsSystem.setSelected(false);
        this.fontSizeFollowsSystem = new JCheckBox(this.resourceBundle.getString("check_system_font")){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && ThemePreferencesHandler.getSharedInstance().supportsNativeFontSize();
                super.setEnabled(enabled);
            }
        };
        this.fontSizeFollowsSystem.setEnabled(false);
        this.fontSizeFollowsSystem.setSelected(false);
        this.themeFollowsSystem = new JCheckBox(this.resourceBundle.getString("check_system_theme")){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && ThemePreferencesHandler.getSharedInstance().supportsNativeFontSize();
                super.setEnabled(enabled);
            }
        };
        this.themeFollowsSystem.setEnabled(false);
        this.themeFollowsSystem.setSelected(false);
        this.enabledSystemPreferences = new TristateCheckBox(this.resourceBundle.getString("check_system_preferences"));
        ActionListener actionListener = e -> SwingUtilities.invokeLater(this::update);
        this.enabledSystemPreferences.addChangeListener(e -> {
            if (!this.enabledSystemPreferences.getTristateModel().isIndeterminate()) {
                boolean selected = this.enabledSystemPreferences.getTristateModel().isSelected();
                if (this.themeFollowsSystem.isEnabled()) {
                    this.themeFollowsSystem.setSelected(selected);
                }
                if (this.accentColorFollowsSystem.isEnabled()) {
                    this.accentColorFollowsSystem.setSelected(selected);
                }
                if (this.selectionColorFollowsSystem.isEnabled()) {
                    this.selectionColorFollowsSystem.setSelected(selected);
                }
                if (this.fontSizeFollowsSystem.isEnabled()) {
                    this.fontSizeFollowsSystem.setSelected(selected);
                }
            }
            this.update();
        });
        this.themeFollowsSystem.addActionListener(actionListener);
        this.accentColorFollowsSystem.addActionListener(actionListener);
        this.selectionColorFollowsSystem.addActionListener(actionListener);
        this.fontSizeFollowsSystem.addActionListener(actionListener);
        this.enabledSystemPreferences.setSelected(LafManager.isPreferenceChangeReportingEnabled());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("title_monitoring")));
        panel.add(this.getTwoColumnLayout(new JComponent[]{this.enabledSystemPreferences, this.themeFollowsSystem, this.accentColorFollowsSystem}, new JComponent[]{new JLabel(), this.fontSizeFollowsSystem, this.selectionColorFollowsSystem}, GroupLayout.Alignment.LEADING, GroupLayout.Alignment.LEADING));
        return panel;
    }

    private JComponent getTwoColumnLayout(JComponent[] left, JComponent[] right) {
        return this.getTwoColumnLayout(left, right, GroupLayout.Alignment.TRAILING, GroupLayout.Alignment.LEADING);
    }

    private JComponent getTwoColumnLayout(JComponent[] left, JComponent[] right, GroupLayout.Alignment leftColumn, GroupLayout.Alignment rightColumn) {
        if (left.length != right.length) {
            String s = left.length + " labels supplied for " + right.length + " fields!";
            throw new IllegalArgumentException(s);
        }
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup verticalLabelGroup = layout.createParallelGroup(leftColumn);
        horizontalGroup.addGroup(verticalLabelGroup);
        GroupLayout.ParallelGroup verticalComponentGroup = layout.createParallelGroup(rightColumn);
        horizontalGroup.addGroup(verticalComponentGroup);
        layout.setHorizontalGroup(horizontalGroup);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        layout.setVerticalGroup(verticalGroup);
        int p = -2;
        for (JComponent label : left) {
            ((GroupLayout.Group)verticalLabelGroup).addComponent(label);
        }
        for (JComponent field : right) {
            ((GroupLayout.Group)verticalComponentGroup).addComponent(field, p, p, p);
        }
        for (int i = 0; i < left.length; ++i) {
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(left[i]).addComponent(right[i], p, p, p));
        }
        return panel;
    }

    private void enableButtonGroup(ButtonGroup bg, boolean enabled) {
        Enumeration<AbstractButton> buttons = bg.getElements();
        while (buttons.hasMoreElements()) {
            buttons.nextElement().setEnabled(enabled);
        }
    }

    public ColoredRadioButton addColoredButton(ColoredRadioButton button, ButtonGroup bg, JComponent parent, String tipText) {
        this.setupButton(button, bg, tipText);
        parent.add(button);
        return button;
    }

    public ColoredRadioButton addColoredButton(ButtonGroup bg, JComponent parent, Color color, String tipText) {
        return this.addColoredButton(new ColoredRadioButton(null, color), bg, parent, tipText);
    }

    public ColoredRadioButton addColoredButton(ButtonGroup bg, JComponent parent, final Supplier<Color> colorSupplier, String tipText) {
        return this.addColoredButton(new ColoredRadioButton(null, null){
            {
                super(text, color);
                this.addActionListener(e -> this.getColor());
            }

            @Override
            public Color getColor() {
                Color c = super.getColor();
                if (c == null) {
                    this.setColor((Color)colorSupplier.get());
                }
                return super.getColor();
            }
        }, bg, parent, tipText);
    }

    private void setupButton(ColoredRadioButton button, ButtonGroup bg, String tipText) {
        bg.add(button);
        button.setName(tipText);
        ToolTipContext context = new ToolTipContext().setAlignment(Alignment.CENTER).setCenterAlignment(Alignment.NORTH);
        button.setToolTipText(tipText);
        button.putClientProperty("JToolTip.style", "balloon");
        button.putClientProperty("JToolTip.toolTipContext", context);
    }

    public String getTitle() {
        return this.resourceBundle.getString("title");
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.icon = UIManager.getIcon("ThemeSettings.icon");
    }
}

