/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.DefaultButton;
import com.github.weisj.darklaf.graphics.ImageUtil;
import com.github.weisj.darklaf.settings.ThemeSettingsPanel;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.event.ThemePreferenceChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemePreferenceListener;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.LazyValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ThemeSettings
implements ThemePreferenceListener {
    private static final LazyValue<ThemeSettings> instance = new LazyValue(ThemeSettings::new);
    private final JPanel contentPane;
    private final ThemeSettingsPanel settingsPanel;
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle("theme_settings");
    private JDialog dialog;

    public static ThemeSettings getInstance() {
        return (ThemeSettings)instance.get();
    }

    public static boolean isInitialized() {
        return instance.isInitialized();
    }

    public static void showSettingsDialog(Component parent) {
        ThemeSettings.showSettingsDialog(parent, Dialog.ModalityType.MODELESS);
    }

    public static void showSettingsDialog(Component parent, Dialog.ModalityType modalityType) {
        ThemeSettings.getInstance().showDialog(parent, modalityType);
    }

    protected ThemeSettings() {
        this.settingsPanel = new ThemeSettingsPanel(this.resourceBundle);
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.add((Component)this.settingsPanel, "Center");
        this.contentPane.add(this.createButtonPanel(), "South");
        this.settingsPanel.fetch(true);
        LafManager.addThemePreferenceChangeListener(this);
    }

    protected JDialog createDialog(Window parent) {
        JDialog dialog = new JDialog(parent);
        dialog.setIconImage(ImageUtil.createFrameIcon(this.settingsPanel.getIcon()));
        dialog.setTitle(this.settingsPanel.getTitle());
        dialog.setContentPane(this.contentPane);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.setLocationByPlatform(true);
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public void showDialog(Component parent, Dialog.ModalityType modal) {
        Window parentWindow = DarkUIUtil.getWindow(this.getSettingsPanel());
        if (parentWindow != null && parentWindow != DarkUIUtil.getWindow(this.dialog)) {
            throw new IllegalStateException("Can't show dialog while settings panel is used elsewhere");
        }
        this.refresh();
        Window window = DarkUIUtil.getWindow(parent);
        this.dialog = this.createDialog(window);
        this.dialog.setModalityType(modal);
        this.dialog.setVisible(true);
    }

    public JComponent getSettingsPanel() {
        return this.settingsPanel;
    }

    public boolean isSystemPreferencesEnabled() {
        return this.settingsPanel.isSystemPreferencesEnabled();
    }

    public boolean isAccentColorFollowsSystem() {
        return this.settingsPanel.isAccentColorFollowsSystem();
    }

    public boolean isFontSizeFollowsSystem() {
        return this.settingsPanel.isFontSizeFollowsSystem();
    }

    public boolean isSelectionColorFollowsSystem() {
        return this.settingsPanel.isSelectionColorFollowsSystem();
    }

    public boolean isThemeFollowsSystem() {
        return this.settingsPanel.isThemeFollowsSystem();
    }

    public AccentColorRule getAccentColorRule() {
        return this.settingsPanel.getAccentColorRule();
    }

    public FontSizeRule getFontSizeRule() {
        return this.settingsPanel.getFontSizeRule();
    }

    public Theme getTheme() {
        return this.settingsPanel.getTheme();
    }

    public void setEnabledSystemPreferences(boolean enabled) {
        this.settingsPanel.setEnabledSystemPreferences(enabled);
    }

    public void setAccentColorFollowsSystem(boolean accentColorFollowsSystem) {
        this.settingsPanel.setAccentColorFollowsSystem(accentColorFollowsSystem);
    }

    public void setFontSizeFollowsSystem(boolean fontSizeFollowsSystem) {
        this.settingsPanel.setFontSizeFollowsSystem(fontSizeFollowsSystem);
    }

    public void setSelectionColorFollowsSystem(boolean selectionColorFollowsSystem) {
        this.settingsPanel.setSelectionColorFollowsSystem(selectionColorFollowsSystem);
    }

    public void setThemeFollowsSystem(boolean themeFollowsSystem) {
        this.settingsPanel.setThemeFollowsSystem(themeFollowsSystem);
    }

    public void setAccentColorRule(AccentColorRule accentColorRule) {
        this.settingsPanel.setAccentColorRule(accentColorRule);
    }

    public void setFontSizeRule(FontSizeRule fontSizeRule) {
        this.settingsPanel.setFontSizeRule(fontSizeRule);
    }

    public void setTheme(Theme theme) {
        this.settingsPanel.setTheme(theme);
    }

    protected Component createButtonPanel() {
        DefaultButton ok = new DefaultButton(this.resourceBundle.getString("dialog_ok"));
        ok.setDefaultCapable(true);
        ok.addActionListener(e -> {
            this.apply();
            this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
        });
        JButton cancel = new JButton(this.resourceBundle.getString("dialog_cancel"));
        cancel.addActionListener(e -> {
            this.revert();
            this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
        });
        JButton apply = new JButton(this.resourceBundle.getString("dialog_apply"));
        apply.addActionListener(e -> this.apply());
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(ok);
        box.add(cancel);
        box.add(apply);
        box.setBorder(this.settingsPanel.getBorder());
        return box;
    }

    public void refresh() {
        this.settingsPanel.fetch(true);
    }

    public void save() {
        this.settingsPanel.saveSettings();
    }

    public void apply() {
        this.save();
        this.peek();
    }

    public void peek() {
        this.applyTheme(this.settingsPanel.getEffectiveTheme());
    }

    public void revert() {
        this.settingsPanel.discardChanges();
        this.refresh();
    }

    protected void applyTheme(Theme theme) {
        if (theme == null) {
            return;
        }
        if (LafManager.getTheme().appearsEqualTo(theme)) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            LafManager.installTheme(theme);
            this.settingsPanel.fetch(true);
        });
    }

    public Icon getIcon() {
        return this.settingsPanel.getIcon();
    }

    public String getTitle() {
        return this.settingsPanel.getTitle();
    }

    public void themePreferenceChanged(ThemePreferenceChangeEvent e) {
        this.settingsPanel.fetch(e.getPreferredThemeStyle());
        this.applyTheme(this.settingsPanel.getEffectiveTheme(e.getPreferredThemeStyle()));
    }
}

