/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tooltip;

import com.github.weisj.darklaf.components.alignment.AlignmentStrategy;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.ui.tooltip.DarkTooltipBorder;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;

public class ToolTipContext {
    private static ToolTipContext defaultContext;
    private final Insets calcInsets = new Insets(0, 0, 0, 0);
    private JComponent target;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent e) {
            this.checkExit(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ToolTipContext.this.hotSpotArea == null) {
                return;
            }
            this.checkExit(e);
        }

        private void checkExit(MouseEvent e) {
            if (!ToolTipContext.this.hideOnExit) {
                return;
            }
            if (ToolTipContext.this.hotSpotArea != null) {
                if (!ToolTipContext.this.hotSpotArea.contains(e.getPoint())) {
                    ToolTipManager.sharedInstance().mousePressed(null);
                }
            } else if (ToolTipContext.this.target != null && !ToolTipContext.this.target.contains(e.getPoint())) {
                ToolTipManager.sharedInstance().mousePressed(null);
            }
        }
    };
    private Alignment alignment;
    private Alignment centerAlignment;
    private boolean alignInside;
    private AlignmentStrategy alignmentStrategy;
    private Function<MouseEvent, Rectangle> toolTipRectSupplier;
    private boolean applyInsetsToRect;
    private Area hotSpotArea;
    private boolean hideOnExit;
    private JToolTip toolTip;
    private Insets insets;
    private ToolTipStyle style;
    private boolean ignoreBorder;
    private boolean bestFit;
    private Function<ToolTipContext, Point> fallBackPositionProvider;

    public static ToolTipContext getDefaultContext() {
        if (defaultContext == null) {
            defaultContext = ToolTipContext.createDefaultContext();
        }
        return defaultContext;
    }

    private static ToolTipContext createDefaultContext() {
        return new ToolTipContext().setAlignment(Alignment.SOUTH).setCenterAlignment(Alignment.SOUTH).setAlignInside(false).setIgnoreBorder(true).setUseBestFit(true);
    }

    public static void setDefaultContext(ToolTipContext defaultContext) {
        ToolTipContext.defaultContext = defaultContext;
    }

    public ToolTipContext() {
        this(null, null, null, null, true, null);
    }

    public ToolTipContext(JComponent target) {
        this(target, null, null, null, true, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, Alignment centerAlignment, AlignmentStrategy alignmentStrategy, boolean alignInside, Function<MouseEvent, Rectangle> toolTipRectSupplier) {
        this.target = target;
        this.setToolTipStyle(ToolTipStyle.BALLOON);
        this.setUpdatePosition(false);
        this.setHideOnExit(false);
        this.setFallBackPositionProvider(null);
        this.setAlignInside(alignInside);
        this.setAlignment(alignment);
        this.setCenterAlignment(centerAlignment);
        this.setAlignmentStrategy(alignmentStrategy);
        this.setToolTipRectSupplier(toolTipRectSupplier);
    }

    public ToolTipContext setToolTipStyle(ToolTipStyle style) {
        this.style = style;
        if (style == null) {
            this.style = ToolTipStyle.BALLOON;
        }
        return this;
    }

    public ToolTipContext setUpdatePosition(boolean updatePosition) {
        return this;
    }

    public ToolTipContext(JComponent target, Alignment alignment) {
        this(target, alignment, null, null, true, null);
    }

    public ToolTipContext setAlignInside(boolean alignInside) {
        this.alignInside = alignInside;
        return this;
    }

    public boolean isIgnoreBorder() {
        return this.ignoreBorder;
    }

    public boolean isBestFit() {
        return this.bestFit;
    }

    public ToolTipContext setAlignment(Alignment alignment) {
        this.alignment = alignment;
        if (alignment == null) {
            this.alignment = Alignment.CENTER;
        }
        return this;
    }

    public ToolTipContext setCenterAlignment(Alignment centerAlignment) {
        this.centerAlignment = centerAlignment;
        if (centerAlignment == null) {
            this.centerAlignment = Alignment.NORTH;
        }
        return this;
    }

    public ToolTipContext setAlignmentStrategy(AlignmentStrategy alignmentStrategy) {
        this.alignmentStrategy = alignmentStrategy;
        if (alignmentStrategy == null) {
            this.alignmentStrategy = AlignmentStrategy.COMPONENT_BOTH;
        }
        return this;
    }

    public ToolTipContext(JComponent target, Alignment alignment, Alignment centerAlignment) {
        this(target, alignment, centerAlignment, null, true, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, boolean alignInside) {
        this(target, alignment, null, null, alignInside, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, Alignment centerAlignment, boolean alignInside) {
        this(target, alignment, centerAlignment, null, alignInside, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, AlignmentStrategy alignmentStrategy) {
        this(target, alignment, null, alignmentStrategy, true, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, Alignment centerAlignment, AlignmentStrategy alignmentStrategy) {
        this(target, alignment, centerAlignment, alignmentStrategy, true, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, AlignmentStrategy alignmentStrategy, boolean alignInside) {
        this(target, alignment, null, alignmentStrategy, alignInside, null);
    }

    public ToolTipContext setHideOnExit(boolean hideOnExit) {
        this.hideOnExit = hideOnExit;
        if (this.target != null) {
            if (hideOnExit) {
                this.target.addMouseListener(this.mouseListener);
            } else {
                this.target.removeMouseListener(this.mouseListener);
            }
        }
        return this;
    }

    public ToolTipContext setToolTipRectSupplier(Function<MouseEvent, Rectangle> toolTipRectSupplier) {
        this.toolTipRectSupplier = toolTipRectSupplier;
        if (toolTipRectSupplier == null) {
            this.toolTipRectSupplier = e -> new Rectangle(0, 0, this.target.getWidth(), this.target.getHeight());
        }
        return this;
    }

    public void updateToolTip() {
        if (this.toolTip != null) {
            this.toolTip.putClientProperty("JToolTip.pointerLocation", this.alignment == Alignment.CENTER ? this.centerAlignment.opposite() : (this.alignInside ? this.alignment : this.alignment.opposite()));
            this.toolTip.putClientProperty("JToolTip.insets", this.insets);
            this.toolTip.putClientProperty("JToolTip.style", (Object)this.style);
            this.toolTip.doLayout();
        }
    }

    public ToolTipContext setInsideArea(Area insideRect) {
        this.hotSpotArea = insideRect;
        return this;
    }

    public ToolTipContext setApplyComponentInsetsToRect(boolean applyInsetsToRect) {
        this.applyInsetsToRect = applyInsetsToRect;
        return this;
    }

    public ToolTipContext setInsideArea(Rectangle insideRect) {
        this.hotSpotArea = new Area(insideRect);
        return this;
    }

    public ToolTipContext setToolTipInsets(Insets insets) {
        this.insets = insets;
        return this;
    }

    public Point getToolTipLocation(MouseEvent event) {
        Point mp = SwingUtilities.convertPoint((Component)event.getSource(), event.getPoint(), this.target);
        return this.getToolTipLocation(mp, event);
    }

    public ToolTipContext setIgnoreBorder(boolean ignoreBorder) {
        this.ignoreBorder = ignoreBorder;
        return this;
    }

    public ToolTipContext setUseBestFit(boolean bestFit) {
        this.bestFit = bestFit;
        return this;
    }

    public Point getToolTipLocation(Point mp, MouseEvent mouseEvent) {
        Point mousePoint;
        Point compPoint;
        if (this.target == null) {
            return null;
        }
        this.updateToolTip();
        MouseEvent event = this.processEvent(mouseEvent, mp);
        Rectangle rect = this.getTargetRect(event);
        if (this.applyInsetsToRect) {
            DarkUIUtil.applyInsets(rect, this.target.getInsets(this.calcInsets));
        }
        this.getToolTip().setTipText(this.target.getToolTipText(event));
        Dimension dim = this.getContentSize();
        Rectangle mRect = new Rectangle(mp.x, mp.y, 1, 1);
        if (this.alignment == Alignment.CENTER) {
            compPoint = this.alignCenter(dim, rect);
            mousePoint = this.alignCenter(dim, mRect);
        } else {
            compPoint = this.alignInside ? this.alignInside(dim, rect) : this.alignOutside(dim, rect);
            mousePoint = this.alignInside ? this.alignInside(dim, mRect) : this.alignOutside(dim, mRect);
        }
        return this.alignmentStrategy.align(compPoint, mousePoint);
    }

    private Rectangle getTargetRect(MouseEvent event) {
        Border border;
        Rectangle rect = this.toolTipRectSupplier.apply(event);
        if (this.ignoreBorder && (border = this.target.getBorder()) != null) {
            Insets ins = border.getBorderInsets(this.target);
            rect.x += ins.left;
            rect.y += ins.top;
            rect.width -= ins.left + ins.right;
            rect.height -= ins.top + ins.bottom;
        }
        return rect;
    }

    private MouseEvent processEvent(MouseEvent mouseEvent, Point mp) {
        if (mouseEvent != null) {
            return mouseEvent;
        }
        return new MouseEvent(this.target, 503, System.currentTimeMillis(), 0, mp.x, mp.y, 0, false, 0);
    }

    public JComponent getTarget() {
        return this.target;
    }

    public void setTarget(JComponent target) {
        this.target = target;
    }

    public JToolTip getToolTip() {
        if (this.toolTip == null) {
            this.setToolTip(new JToolTip());
        }
        return this.toolTip;
    }

    public void updateToolTipUI() {
        if (this.toolTip != null) {
            this.toolTip.updateUI();
        }
    }

    private Dimension getContentSize() {
        Alignment align;
        Dimension dim = this.toolTip.getPreferredSize();
        Alignment alignment = align = this.alignment == Alignment.CENTER ? this.centerAlignment : this.alignment;
        if (align == Alignment.EAST || align == Alignment.WEST) {
            dim.height -= ((DarkTooltipBorder)this.toolTip.getBorder()).getShadowSize(this.toolTip);
        }
        return dim;
    }

    private Point alignCenter(Dimension dim, Rectangle rect) {
        rect.x += rect.width / 2;
        rect.y += rect.height / 2;
        rect.width = 1;
        rect.height = 1;
        Point p = this.centerAlignment.alignOutside(dim, rect);
        return this.adjustPoint(p, this.centerAlignment, dim, true);
    }

    private Point alignInside(Dimension dim, Rectangle rect) {
        Point p = this.alignment.alignInside(dim, rect);
        return this.adjustPoint(p, this.alignment, dim, false);
    }

    private Point alignOutside(Dimension dim, Rectangle rect) {
        Point p = this.alignment.alignOutside(dim, rect);
        return this.adjustPoint(p, this.alignment, dim, true);
    }

    private Point adjustPoint(Point p, Alignment align, Dimension dim, boolean outside) {
        int factor = outside ? 1 : -1;
        DarkTooltipBorder border = (DarkTooltipBorder)this.toolTip.getBorder();
        if (align == Alignment.EAST) {
            p.x -= factor * border.getDistanceToPointer();
        } else if (align == Alignment.WEST) {
            p.x += factor * border.getDistanceToPointer();
        } else if (align.isNorth()) {
            p.y += factor * border.getDistanceToPointer();
        } else if (align.isSouth()) {
            p.y -= factor * border.getDistanceToPointer();
        }
        if (align == Alignment.NORTH_EAST || align == Alignment.SOUTH_EAST) {
            p.x -= factor * border.getPointerOffset(this.toolTip, dim, factor);
        } else if (align == Alignment.NORTH_WEST || align == Alignment.SOUTH_WEST) {
            p.x += factor * border.getPointerOffset(this.toolTip, dim, factor);
        }
        return p;
    }

    public void removeToolTip() {
        this.setHideOnExit(false);
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Alignment getCenterAlignment() {
        return this.centerAlignment;
    }

    public AlignmentStrategy getAlignmentStrategy() {
        return this.alignmentStrategy;
    }

    public boolean isAlignInside() {
        return this.alignInside;
    }

    public void setToolTip(JToolTip toolTip) {
        if (toolTip == null) {
            return;
        }
        this.toolTip = toolTip;
        if (this.target != toolTip.getComponent()) {
            this.toolTip.setComponent(this.target);
        }
    }

    public Point getFallBackPosition() {
        return this.fallBackPositionProvider.apply(this);
    }

    public ToolTipContext setFallBackPositionProvider(Function<ToolTipContext, Point> fallBackPositionProvider) {
        this.fallBackPositionProvider = fallBackPositionProvider;
        if (fallBackPositionProvider == null) {
            this.fallBackPositionProvider = c -> null;
        }
        return this;
    }
}

