/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http.apache;

import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.exception.HttpException;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.http.AbstractHttpClient;
import com.wechat.pay.java.core.http.FileRequestBody;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.OriginalResponse;
import com.wechat.pay.java.core.http.RequestBody;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClientAdapter
extends AbstractHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpClientAdapter.class);
    private static final String META_NAME = "meta";
    private static final String FILE_NAME = "file";
    private final CloseableHttpClient apacheHttpClient;

    public ApacheHttpClientAdapter(Credential credential, Validator validator, CloseableHttpClient client) {
        super(credential, validator);
        this.apacheHttpClient = Objects.requireNonNull(client);
    }

    @Override
    protected String getHttpClientInfo() {
        return "apachehttp/" + this.apacheHttpClient.getClass().getPackage().getImplementationVersion();
    }

    @Override
    public OriginalResponse innerExecute(HttpRequest wechatPayRequest) {
        OriginalResponse originalResponse;
        block8: {
            CloseableHttpResponse apacheHttpResponse = this.apacheHttpClient.execute(this.buildApacheHttpRequest(wechatPayRequest));
            try {
                originalResponse = this.assembleOriginalResponse(wechatPayRequest, apacheHttpResponse);
                if (apacheHttpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (apacheHttpResponse != null) {
                        try {
                            apacheHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new HttpException(wechatPayRequest, (Throwable)e);
                }
            }
            apacheHttpResponse.close();
        }
        return originalResponse;
    }

    private HttpUriRequest buildApacheHttpRequest(HttpRequest wechatPayRequest) {
        HttpGet apacheHttpRequest;
        String url = wechatPayRequest.getUrl().toString();
        switch (wechatPayRequest.getHttpMethod().name()) {
            case "GET": {
                apacheHttpRequest = new HttpGet(url);
                break;
            }
            case "POST": {
                apacheHttpRequest = new HttpPost(url);
                ((HttpPost)apacheHttpRequest).setEntity(this.buildApacheHttpEntity(wechatPayRequest.getBody()));
                break;
            }
            case "PUT": {
                apacheHttpRequest = new HttpPut(url);
                ((HttpPut)apacheHttpRequest).setEntity(this.buildApacheHttpEntity(wechatPayRequest.getBody()));
                break;
            }
            case "PATCH": {
                apacheHttpRequest = new HttpPatch(url);
                ((HttpPatch)apacheHttpRequest).setEntity(this.buildApacheHttpEntity(wechatPayRequest.getBody()));
                break;
            }
            case "DELETE": {
                apacheHttpRequest = new HttpDelete(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP method: " + wechatPayRequest.getHttpMethod().name());
            }
        }
        Map<String, String> headers = wechatPayRequest.getHeaders().getHeaders();
        headers.forEach((arg_0, arg_1) -> ((HttpUriRequest)apacheHttpRequest).addHeader(arg_0, arg_1));
        return apacheHttpRequest;
    }

    private HttpEntity buildApacheHttpEntity(RequestBody wechatPayRequestBody) {
        if (wechatPayRequestBody == null) {
            return new StringEntity("", "");
        }
        if (wechatPayRequestBody instanceof JsonRequestBody) {
            return new StringEntity(((JsonRequestBody)wechatPayRequestBody).getBody(), ContentType.create((String)wechatPayRequestBody.getContentType(), (Charset)StandardCharsets.UTF_8));
        }
        if (wechatPayRequestBody instanceof FileRequestBody) {
            FileRequestBody fileRequestBody = (FileRequestBody)wechatPayRequestBody;
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.setMode(HttpMultipartMode.RFC6532);
            entityBuilder.addTextBody(META_NAME, fileRequestBody.getMeta(), ContentType.APPLICATION_JSON);
            entityBuilder.addBinaryBody(FILE_NAME, fileRequestBody.getFile(), ContentType.create((String)fileRequestBody.getContentType()), fileRequestBody.getFileName());
            return entityBuilder.build();
        }
        logger.error("When an http request is sent and the apache request body is constructed, the requestBody parameter type cannot be found,requestBody class name[{}]", (Object)wechatPayRequestBody.getClass().getName());
        return null;
    }

    private OriginalResponse assembleOriginalResponse(HttpRequest wechatPayRequest, CloseableHttpResponse apacheHttpResponse) throws IOException {
        Map<String, String> responseHeaders = this.assembleResponseHeader(apacheHttpResponse);
        HttpEntity entity = apacheHttpResponse.getEntity();
        try {
            String responseBody = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            return new OriginalResponse.Builder().request(wechatPayRequest).headers(responseHeaders).statusCode(apacheHttpResponse.getStatusLine().getStatusCode()).contentType(entity != null ? entity.getContentType().getValue() : null).body(responseBody).build();
        }
        catch (IOException e) {
            throw new MalformedMessageException(String.format("Assemble OriginalResponse,get responseBody failed.%nHttpRequest[%s]", wechatPayRequest));
        }
    }

    private Map<String, String> assembleResponseHeader(CloseableHttpResponse apacheHttpResponse) {
        Header[] headers;
        ConcurrentHashMap<String, String> responseHeaders = new ConcurrentHashMap<String, String>();
        for (Header header : headers = apacheHttpResponse.getAllHeaders()) {
            responseHeaders.put(header.getName(), header.getValue());
        }
        return responseHeaders;
    }

    @Override
    protected InputStream innerDownload(HttpRequest httpRequest) {
        try {
            CloseableHttpResponse apacheHttpResponse = this.apacheHttpClient.execute(this.buildApacheHttpRequest(httpRequest));
            if (this.isInvalidHttpCode(apacheHttpResponse.getStatusLine().getStatusCode())) {
                throw new ServiceException(httpRequest, apacheHttpResponse.getStatusLine().getStatusCode(), "");
            }
            InputStream responseBodyStream = null;
            if (apacheHttpResponse.getEntity() != null) {
                responseBodyStream = apacheHttpResponse.getEntity().getContent();
            }
            return responseBodyStream;
        }
        catch (IOException e) {
            throw new HttpException(httpRequest, (Throwable)e);
        }
    }
}

