// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付分停车服务
//
// 微信支付分停车服务 扣费API
//
// API version: 1.2.1

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.wexinpayscoreparking.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** ParkingTradeScene */
public class ParkingTradeScene {
  /** 入场id 说明：微信支付分停车服务为商户分配的入场id，商户通过入场通知接口获取入场id */
  @SerializedName("parking_id")
  private String parkingId;

  /** 车牌号 说明：车牌号，仅包括省份+车牌，不包括特殊字符。 */
  @SerializedName("plate_number")
  private String plateNumber;

  /** 车牌颜色 说明：车牌颜色 */
  @SerializedName("plate_color")
  private PlateColor plateColor;

  /**
   * 入场时间
   * 说明：用户入场时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("start_time")
  private String startTime;

  /**
   * 出场时间
   * 说明：用户出场时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("end_time")
  private String endTime;

  /** 停车场名称 说明：所在停车位车场的名称 */
  @SerializedName("parking_name")
  private String parkingName;

  /** 计费时长 说明：计费的时间长，单位为秒 */
  @SerializedName("charging_duration")
  private Integer chargingDuration;

  /** 停车场设备id 说明：停车场设备id */
  @SerializedName("device_id")
  private String deviceId;

  public String getParkingId() {
    return parkingId;
  }

  public void setParkingId(String parkingId) {
    this.parkingId = parkingId;
  }

  public String getPlateNumber() {
    return plateNumber;
  }

  public void setPlateNumber(String plateNumber) {
    this.plateNumber = plateNumber;
  }

  public PlateColor getPlateColor() {
    return plateColor;
  }

  public void setPlateColor(PlateColor plateColor) {
    this.plateColor = plateColor;
  }

  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  public String getParkingName() {
    return parkingName;
  }

  public void setParkingName(String parkingName) {
    this.parkingName = parkingName;
  }

  public Integer getChargingDuration() {
    return chargingDuration;
  }

  public void setChargingDuration(Integer chargingDuration) {
    this.chargingDuration = chargingDuration;
  }

  public String getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(String deviceId) {
    this.deviceId = deviceId;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ParkingTradeScene {\n");
    sb.append("    parkingId: ").append(toIndentedString(parkingId)).append("\n");
    sb.append("    plateNumber: ").append(toIndentedString(plateNumber)).append("\n");
    sb.append("    plateColor: ").append(toIndentedString(plateColor)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    parkingName: ").append(toIndentedString(parkingName)).append("\n");
    sb.append("    chargingDuration: ").append(toIndentedString(chargingDuration)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
