// Copyright 2021 Tencent Inc. All rights reserved.
//
// 爱心餐对外API
//
// 微信支付爱心餐公益计划旨在面向深圳市的市政一线环卫工人提供每周一餐的1分钱用餐公益服务。在受助端，微信支付联动上千家餐饮门店关爱特殊人群，通过微信支付数字化能力将人群身份认证与公益福利领用全流程线上化，实现公益福利精准到人。在捐赠端，微信支付发挥连接优势与平台能力，结合用户就餐场景通过爱心餐一块捐插件让用户可在点餐时顺手捐1元，带动更多社会力量致谢城市美容师。
//
// API version: 0.0.4

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.lovefeast.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** OrdersEntity */
public class OrdersEntity {
  /** 捐赠订单号 说明：捐赠订单号 */
  @SerializedName("welfare_trade_id")
  private String welfareTradeId;

  /** 应用ID 说明：直连商户或服务商申请的公众号或移动应用AppID */
  @SerializedName("appid")
  private String appid;

  /** 子商户应用ID 说明：子商户申请的公众号或移动应用AppID */
  @SerializedName("sub_appid")
  private String subAppid;

  /** 品牌ID 说明：品牌的品牌ID，商家进驻微信支付品牌商家后获得的品牌ID */
  @SerializedName("brand_id")
  private Long brandId;

  /** 捐赠来源 说明：捐赠来源 枚举值 MINIPROGRAM_PAY：一起捐小程序 ENTRUST_PAY：一块捐插件 */
  @SerializedName("donate_source")
  private String donateSource;

  /** 商户订单 说明：商户订单，仅在一块捐来源回调中出现 */
  @SerializedName("merchant_order")
  private MerchantOrder merchantOrder;

  /** 捐赠机构名称 说明：捐赠公益机构名称。 */
  @SerializedName("institution_name")
  private String institutionName;

  /** 捐赠项目编号 说明：本次捐赠项目编号。 */
  @SerializedName("business_id")
  private String businessId;

  /** 捐赠活动名称 说明：本次捐赠活动名称。 */
  @SerializedName("business_name")
  private String businessName;

  /**
   * 支付完成时间
   * 说明：支付完成时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("success_time")
  private String successTime;

  /** 支付者 说明：支付者信息 */
  @SerializedName("payer")
  private Payer payer;

  /** 订单金额 说明：订单金额信息 */
  @SerializedName("amount")
  private Amount amount;

  /** 设备编号 说明：设备编号，通过物料码进入爱心餐一起捐小程序捐赠时携带的设备编号参数 */
  @SerializedName("device_id")
  private String deviceId;

  public String getWelfareTradeId() {
    return welfareTradeId;
  }

  public void setWelfareTradeId(String welfareTradeId) {
    this.welfareTradeId = welfareTradeId;
  }

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getSubAppid() {
    return subAppid;
  }

  public void setSubAppid(String subAppid) {
    this.subAppid = subAppid;
  }

  public Long getBrandId() {
    return brandId;
  }

  public void setBrandId(Long brandId) {
    this.brandId = brandId;
  }

  public String getDonateSource() {
    return donateSource;
  }

  public void setDonateSource(String donateSource) {
    this.donateSource = donateSource;
  }

  public MerchantOrder getMerchantOrder() {
    return merchantOrder;
  }

  public void setMerchantOrder(MerchantOrder merchantOrder) {
    this.merchantOrder = merchantOrder;
  }

  public String getInstitutionName() {
    return institutionName;
  }

  public void setInstitutionName(String institutionName) {
    this.institutionName = institutionName;
  }

  public String getBusinessId() {
    return businessId;
  }

  public void setBusinessId(String businessId) {
    this.businessId = businessId;
  }

  public String getBusinessName() {
    return businessName;
  }

  public void setBusinessName(String businessName) {
    this.businessName = businessName;
  }

  public String getSuccessTime() {
    return successTime;
  }

  public void setSuccessTime(String successTime) {
    this.successTime = successTime;
  }

  public Payer getPayer() {
    return payer;
  }

  public void setPayer(Payer payer) {
    this.payer = payer;
  }

  public Amount getAmount() {
    return amount;
  }

  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  public String getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(String deviceId) {
    this.deviceId = deviceId;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrdersEntity {\n");
    sb.append("    welfareTradeId: ").append(toIndentedString(welfareTradeId)).append("\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    subAppid: ").append(toIndentedString(subAppid)).append("\n");
    sb.append("    brandId: ").append(toIndentedString(brandId)).append("\n");
    sb.append("    donateSource: ").append(toIndentedString(donateSource)).append("\n");
    sb.append("    merchantOrder: ").append(toIndentedString(merchantOrder)).append("\n");
    sb.append("    institutionName: ").append(toIndentedString(institutionName)).append("\n");
    sb.append("    businessId: ").append(toIndentedString(businessId)).append("\n");
    sb.append("    businessName: ").append(toIndentedString(businessName)).append("\n");
    sb.append("    successTime: ").append(toIndentedString(successTime)).append("\n");
    sb.append("    payer: ").append(toIndentedString(payer)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
