// Copyright 2021 Tencent Inc. All rights reserved.
//
// 电商退款API
//
// 境内电商退款功能相关API文档
//
// API version: 1.1.8

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.ecommercerefund.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** ReturnAdvance */
public class ReturnAdvance {
  /** 微信退款单号 说明：必须是垫付退款的微信退款单 */
  @SerializedName("refund_id")
  private String refundId;

  /** 微信回补单号 说明：微信支付生成的垫付回补操作单号 */
  @SerializedName("advance_return_id")
  private String advanceReturnId;

  /** 垫付回补金额 说明：退款单对应的垫付退款的金额 */
  @SerializedName("return_amount")
  private Long returnAmount;

  /** 出款方商户号 说明：微信支付分配给出款方的商户号 */
  @SerializedName("payer_mchid")
  private String payerMchid;

  /** 出款方账户 说明：BASIC 基本账户 OPERATION 运营账户 */
  @SerializedName("payer_account")
  private String payerAccount;

  /** 入账方商户号 说明：微信支付分配给入账方的商户号 */
  @SerializedName("payee_mchid")
  private String payeeMchid;

  /** 入账方账户 说明：BASIC 基本账户 OPERATION 运营账户 */
  @SerializedName("payee_account")
  private String payeeAccount;

  /** 垫付回补结果 说明：SUCCESS 回补成功 FAILED 回补失败，出款方账户余额不足时发生 PROCESSING 处理中 */
  @SerializedName("result")
  private String result;

  /**
   * 垫付回补完成时间
   * 说明：垫付回补完成的时间，遵循rfc3339标准格式，格式为YYYY-MM-DDTHH:mm:ss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日13点29分35秒。
   */
  @SerializedName("success_time")
  private String successTime;

  public String getRefundId() {
    return refundId;
  }

  public void setRefundId(String refundId) {
    this.refundId = refundId;
  }

  public String getAdvanceReturnId() {
    return advanceReturnId;
  }

  public void setAdvanceReturnId(String advanceReturnId) {
    this.advanceReturnId = advanceReturnId;
  }

  public Long getReturnAmount() {
    return returnAmount;
  }

  public void setReturnAmount(Long returnAmount) {
    this.returnAmount = returnAmount;
  }

  public String getPayerMchid() {
    return payerMchid;
  }

  public void setPayerMchid(String payerMchid) {
    this.payerMchid = payerMchid;
  }

  public String getPayerAccount() {
    return payerAccount;
  }

  public void setPayerAccount(String payerAccount) {
    this.payerAccount = payerAccount;
  }

  public String getPayeeMchid() {
    return payeeMchid;
  }

  public void setPayeeMchid(String payeeMchid) {
    this.payeeMchid = payeeMchid;
  }

  public String getPayeeAccount() {
    return payeeAccount;
  }

  public void setPayeeAccount(String payeeAccount) {
    this.payeeAccount = payeeAccount;
  }

  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public String getSuccessTime() {
    return successTime;
  }

  public void setSuccessTime(String successTime) {
    this.successTime = successTime;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReturnAdvance {\n");
    sb.append("    refundId: ").append(toIndentedString(refundId)).append("\n");
    sb.append("    advanceReturnId: ").append(toIndentedString(advanceReturnId)).append("\n");
    sb.append("    returnAmount: ").append(toIndentedString(returnAmount)).append("\n");
    sb.append("    payerMchid: ").append(toIndentedString(payerMchid)).append("\n");
    sb.append("    payerAccount: ").append(toIndentedString(payerAccount)).append("\n");
    sb.append("    payeeMchid: ").append(toIndentedString(payeeMchid)).append("\n");
    sb.append("    payeeAccount: ").append(toIndentedString(payeeAccount)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    successTime: ").append(toIndentedString(successTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
