// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付电商平台分账API
//
// 微信支付电商平台分账API
//
// API version: 1.0.21

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.ecommerceprofitsharing.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** QueryAfterSalesOrderResponse */
public class QueryAfterSalesOrderResponse {
  /** 子商户号 说明：分账出资的商户 */
  @SerializedName("sub_mchid")
  private String subMchid;

  /** 微信订单号 说明：微信支付订单号 */
  @SerializedName("transaction_id")
  private String transactionId;

  /** 分账金额 说明：分账金额，单位为分，只能为整数，不能超过原订单支付金额及最大分账比例金额 */
  @SerializedName("amount")
  private Long amount;

  /**
   * 分账结果 说明：枚举值： 1、PROCESSING：分账中（请稍后查询确认结果） 2、SUCCESS：分账成功（最终状态） 3、FAILED:
   * 分账失败（最终状态，资金未变动或资金已转回分账出资方，请商户自行处理，具体失败原因请关注\"分账失败原因\"字段）
   */
  @SerializedName("result")
  private String result;

  /** 分账完成时间 说明：分账完成时间，遵循RFC3339标准格式 */
  @SerializedName("finish_time")
  private String finishTime;

  /**
   * 分账失败原因 说明：分账失败原因。包含以下枚举值： 1. ACCOUNT_ABNORMAL : 分账接收账户异常 2. NO_RELATION : 分账关系已解除 3.
   * RECEIVER_HIGH_RISK : 高风险接收方
   */
  @SerializedName("fail_reason")
  private String failReason;

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public String getFinishTime() {
    return finishTime;
  }

  public void setFinishTime(String finishTime) {
    this.finishTime = finishTime;
  }

  public String getFailReason() {
    return failReason;
  }

  public void setFailReason(String failReason) {
    this.failReason = failReason;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryAfterSalesOrderResponse {\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    finishTime: ").append(toIndentedString(finishTime)).append("\n");
    sb.append("    failReason: ").append(toIndentedString(failReason)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
