/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta.template;

import com.github.veithen.alta.template.EvaluationException;
import com.github.veithen.alta.template.Expression;
import com.github.veithen.alta.template.Property;
import com.github.veithen.alta.template.PropertyGroup;
import java.util.Map;

final class PropertyExpression<C, GC>
extends Expression<C> {
    private final PropertyGroup<C, GC> group;
    private final Property<GC> property;
    private final String prefix;
    private final String suffix;
    private final String defaultValue;

    public PropertyExpression(PropertyGroup<C, GC> group, Property<GC> property, String prefix, String suffix, String defaultValue) {
        this.group = group;
        this.property = property;
        this.prefix = prefix;
        this.suffix = suffix;
        this.defaultValue = defaultValue;
    }

    @Override
    boolean evaluate(C object, Map<Object, Object> contextMap, StringBuilder buffer) throws EvaluationException {
        String value;
        GC groupContext;
        if (contextMap.containsKey(this.group)) {
            groupContext = this.group.getGroupContextClass().cast(contextMap.get(this.group));
        } else {
            groupContext = this.group.prepare(object);
            contextMap.put(this.group, groupContext);
        }
        String string = value = groupContext == null ? null : this.property.evaluate(groupContext);
        if (value != null) {
            buffer.append(this.prefix);
            buffer.append(value);
            buffer.append(this.suffix);
            return true;
        }
        if (this.defaultValue != null) {
            buffer.append(this.defaultValue);
            return true;
        }
        return false;
    }
}

