/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.internalAnnotations.AnalysisContextContained;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;

public class CheckAnalysisContextContainedAnnotation
extends OpcodeStackDetector.WithCustomJumpInfo {
    final BugReporter bugReporter;
    final BugAccumulator accumulator;
    private final boolean testingEnabled;
    static final ClassDescriptor ConstantAnnotation = DescriptorFactory.createClassDescriptor(StaticConstant.class);
    static final ClassDescriptor AnalysisContextContainedAnnotation = DescriptorFactory.createClassDescriptor(AnalysisContextContained.class);

    public CheckAnalysisContextContainedAnnotation(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
        this.testingEnabled = SystemProperties.getBoolean("report_TESTING_pattern_in_standard_detectors");
    }

    private boolean analysisContextContained(XClass xclass) {
        AnnotatedObject ao = xclass;
        do {
            if (ao.getAnnotation(AnalysisContextContainedAnnotation) == null) continue;
            return true;
        } while ((ao = ao.getContainingScope()) != null);
        return false;
    }

    @Override
    public void visit(Field field) {
        if (!field.isStatic()) {
            return;
        }
        String signature = field.getSignature();
        if (!(!signature.startsWith("Ljava/util/") || "Ljava/util/regex/Pattern;".equals(signature) || "Ljava/util/logging/Logger;".equals(signature) || "Ljava/util/BitSet;".equals(signature) || "Ljava/util/ResourceBundle;".equals(signature) || "Ljava/util/Comparator;".equals(signature) || this.getXField().getAnnotation(ConstantAnnotation) != null)) {
            boolean flagged = this.analysisContextContained(this.getXClass());
            this.bugReporter.reportBug(new BugInstance(this, "TESTING", flagged ? 2 : 3).addClass(this).addField(this).addType(signature));
        }
    }

    @Override
    public void visit(Code code) {
        boolean interesting = this.testingEnabled;
        if (interesting) {
            super.visit(code);
        }
        this.accumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            default: {
                break;
            }
            case 159: 
            case 160: {
                OpcodeStack.Item left = this.stack.getStackItem(1);
                OpcodeStack.Item right = this.stack.getStackItem(0);
                if (!this.bad(left, right) && !this.bad(right, left)) break;
                this.accumulator.accumulateBug(new BugInstance(this, "TESTING", 2).addClassAndMethod(this).addValueSource(left, this).addValueSource(right, this).addString("Just check the sign of the result of compare or compareTo, not specific values such as 1 or -1"), this);
            }
        }
    }

    private boolean bad(OpcodeStack.Item left, OpcodeStack.Item right) {
        XMethod m = left.getReturnValueOf();
        if (m == null) {
            return false;
        }
        Object value = right.getConstant();
        return value instanceof Integer && (Integer)value != 0 && !m.isStatic() && m.isPublic() && ("compareTo".equals(m.getName()) && "(Ljava/lang/Object;)I".equals(m.getSignature()) || "compare".equals(m.getName()) && "(Ljava/lang/Object;Ljava/lang/Object;)I".equals(m.getSignature()));
    }

    @Override
    public OpcodeStack.JumpInfo customJumpInfo() {
        return null;
    }
}

