/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.model.JApiChangeStatus;
import japicmp.util.Optional;
import japicmp.util.OptionalHelper;
import javax.xml.bind.annotation.XmlAttribute;

public class JApiModifier<T> {
    private final Optional<T> oldModifier;
    private final Optional<T> newModifier;
    private final JApiChangeStatus changeStatus;

    public JApiModifier(Optional<T> oldModifier, Optional<T> newModifier, JApiChangeStatus changeStatus) {
        this.oldModifier = oldModifier;
        this.newModifier = newModifier;
        this.changeStatus = changeStatus;
    }

    public Optional<T> getOldModifier() {
        return this.oldModifier;
    }

    public Optional<T> getNewModifier() {
        return this.newModifier;
    }

    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlAttribute(name="oldValue")
    public String getValueOld() {
        return OptionalHelper.optionalToString(this.oldModifier);
    }

    @XmlAttribute(name="newValue")
    public String getValueNew() {
        return OptionalHelper.optionalToString(this.newModifier);
    }

    public boolean hasChangedFromTo(T oldValue, T newValue) {
        boolean hasChanged = false;
        if (this.oldModifier.isPresent() && this.newModifier.isPresent() && this.oldModifier.get() == oldValue && this.newModifier.get() == newValue) {
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean hasChangedFrom(T oldValue) {
        boolean hasChanged = false;
        if (this.oldModifier.isPresent() && this.newModifier.isPresent()) {
            if (this.oldModifier.get() == oldValue && this.newModifier.get() != oldValue) {
                hasChanged = true;
            }
        } else if (this.oldModifier.isPresent()) {
            if (this.oldModifier.get() == oldValue) {
                hasChanged = true;
            }
        } else {
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean hasChangedTo(T value) {
        T newValue;
        boolean hasChangedTo = false;
        if (this.newModifier.isPresent() && value == (newValue = this.newModifier.get())) {
            hasChangedTo = true;
        }
        return hasChangedTo;
    }
}

