/*
 * Decompiled with CFR 0.152.
 */
package japicmp.filter;

import japicmp.filter.AnnotationFilterBase;
import japicmp.filter.BehaviorFilter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;

public class AnnotationBehaviorFilter
extends AnnotationFilterBase
implements BehaviorFilter {
    private static final Logger LOGGER = Logger.getLogger(AnnotationBehaviorFilter.class.getName());

    public AnnotationBehaviorFilter(String filterString) {
        super(filterString.substring(1));
    }

    @Override
    public boolean matches(CtBehavior ctBehavior) {
        CtClass declaringClass;
        List attributes = ctBehavior.getMethodInfo().getAttributes();
        boolean hasAnnotation = this.hasAnnotation(attributes);
        if (!hasAnnotation && !(hasAnnotation = this.hasAnnotation((declaringClass = ctBehavior.getDeclaringClass()).getClassFile().getAttributes()))) {
            try {
                declaringClass = declaringClass.getDeclaringClass();
                if (declaringClass != null) {
                    hasAnnotation = this.hasAnnotation(declaringClass.getClassFile().getAttributes());
                }
            }
            catch (NotFoundException e) {
                LOGGER.log(Level.FINE, "Failed to load class '" + declaringClass.getName() + "': " + e.getLocalizedMessage(), e);
            }
        }
        return hasAnnotation;
    }

    public String toString() {
        return "@" + this.annotationClassName;
    }
}

