/*
 * Decompiled with CFR 0.152.
 */
package japicmp.cmp;

import japicmp.cmp.ClassesComparator;
import japicmp.cmp.JApiCmpArchive;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.compat.CompatibilityChanges;
import japicmp.exception.JApiCmpException;
import japicmp.filter.AnnotationFilterBase;
import japicmp.filter.Filter;
import japicmp.filter.Filters;
import japicmp.filter.JavadocLikePackageFilter;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JavaObjectSerializationCompatibility;
import japicmp.output.OutputFilter;
import japicmp.util.AnnotationHelper;
import japicmp.util.FileHelper;
import japicmp.util.Optional;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class JarArchiveComparator {
    private static final Logger LOGGER = Logger.getLogger(JarArchiveComparator.class.getName());
    private ClassPool commonClassPool;
    private ClassPool oldClassPool;
    private ClassPool newClassPool;
    private String commonClassPathAsString = "";
    private String oldClassPathAsString = "";
    private String newClassPathAsString = "";
    private final JarArchiveComparatorOptions options;

    public JarArchiveComparator(JarArchiveComparatorOptions options) {
        this.options = options;
        this.setupClasspaths();
        this.setupCompatibilityChanges(options);
    }

    private void setupCompatibilityChanges(JarArchiveComparatorOptions options) {
        for (JApiCompatibilityChange jApiCompatibility : JApiCompatibilityChange.values()) {
            jApiCompatibility.resetOverrides();
        }
        for (JarArchiveComparatorOptions.OverrideCompatibilityChange change : options.getOverrideCompatibilityChanges()) {
            JApiCompatibilityChange compatibilityChange = change.getCompatibilityChange();
            for (JApiCompatibilityChange jApiCompatibility : JApiCompatibilityChange.values()) {
                if (jApiCompatibility != compatibilityChange) continue;
                jApiCompatibility.setBinaryCompatible(change.isBinaryCompatible());
                jApiCompatibility.setSourceCompatible(change.isSourceCompatible());
                jApiCompatibility.setSemanticVersionLevel(change.getSemanticVersionLevel());
            }
        }
    }

    public List<JApiClass> compare(JApiCmpArchive oldArchive, JApiCmpArchive newArchive) {
        return this.compare(Collections.singletonList(oldArchive), Collections.singletonList(newArchive));
    }

    public List<JApiClass> compare(List<JApiCmpArchive> oldArchives, List<JApiCmpArchive> newArchives) {
        return this.createAndCompareClassLists(FileHelper.toFileList(oldArchives), FileHelper.toFileList(newArchives));
    }

    private void checkJavaObjectSerializationCompatibility(List<JApiClass> jApiClasses) {
        JavaObjectSerializationCompatibility javaObjectSerializationCompatibility = new JavaObjectSerializationCompatibility();
        javaObjectSerializationCompatibility.evaluate(jApiClasses);
    }

    private void setupClasspaths() {
        if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH) {
            this.commonClassPool = new ClassPool();
            this.commonClassPathAsString = this.setupClasspath(this.commonClassPool, this.options.getClassPathEntries());
        } else if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS) {
            this.oldClassPool = new ClassPool();
            this.oldClassPathAsString = this.setupClasspath(this.oldClassPool, this.options.getOldClassPath());
            this.newClassPool = new ClassPool();
            this.newClassPathAsString = this.setupClasspath(this.newClassPool, this.options.getNewClassPath());
        } else {
            throw new JApiCmpException(JApiCmpException.Reason.IllegalState, "Unknown classpath mode: " + (Object)((Object)this.options.getClassPathMode()));
        }
    }

    private String setupClasspath(ClassPool classPool, List<String> classPathEntries) {
        String classPathAsString = this.appendUserDefinedClassPathEntries(classPool, classPathEntries);
        return this.appendSystemClassPath(classPool, classPathAsString);
    }

    private String appendSystemClassPath(ClassPool classPool, String classPathAsString) {
        String retVal = classPathAsString;
        classPool.appendSystemPath();
        if (retVal.length() > 0 && !retVal.endsWith(File.pathSeparator)) {
            retVal = retVal + File.pathSeparator;
        }
        return retVal;
    }

    private String appendUserDefinedClassPathEntries(ClassPool classPool, List<String> classPathEntries) {
        StringBuilder classPathAsString = new StringBuilder();
        for (String classPathEntry : classPathEntries) {
            try {
                classPool.appendClassPath(classPathEntry);
                if (!classPathAsString.toString().endsWith(File.pathSeparator)) {
                    classPathAsString.append(File.pathSeparator);
                }
                classPathAsString.append(classPathEntry);
            }
            catch (NotFoundException e) {
                throw JApiCmpException.forClassLoading((Exception)((Object)e), classPathEntry, this);
            }
        }
        return classPathAsString.toString();
    }

    public String getCommonClasspathAsString() {
        return this.commonClassPathAsString;
    }

    public String getOldClassPathAsString() {
        return this.oldClassPathAsString;
    }

    public String getNewClassPathAsString() {
        return this.newClassPathAsString;
    }

    private void checkBinaryCompatibility(List<JApiClass> classList) {
        CompatibilityChanges compatibilityChanges = new CompatibilityChanges(this);
        compatibilityChanges.evaluate(classList);
    }

    private List<JApiClass> createAndCompareClassLists(List<File> oldArchives, List<File> newArchives) {
        if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH) {
            List<CtClass> oldClasses = this.createListOfCtClasses(oldArchives, this.commonClassPool);
            List<CtClass> newClasses = this.createListOfCtClasses(newArchives, this.commonClassPool);
            return this.compareClassLists(this.options, oldClasses, newClasses);
        }
        if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS) {
            List<CtClass> oldClasses = this.createListOfCtClasses(oldArchives, this.oldClassPool);
            List<CtClass> newClasses = this.createListOfCtClasses(newArchives, this.newClassPool);
            return this.compareClassLists(this.options, oldClasses, newClasses);
        }
        throw new JApiCmpException(JApiCmpException.Reason.IllegalState, "Unknown classpath mode: " + (Object)((Object)this.options.getClassPathMode()));
    }

    List<JApiClass> compareClassLists(JarArchiveComparatorOptions options, List<CtClass> oldClasses, List<CtClass> newClasses) {
        List<CtClass> oldClassesFiltered = this.applyFilter(options, oldClasses);
        List<CtClass> newClassesFiltered = this.applyFilter(options, newClasses);
        ClassesComparator classesComparator = new ClassesComparator(this, options);
        classesComparator.compare(oldClassesFiltered, newClassesFiltered);
        List<JApiClass> classList = classesComparator.getClasses();
        if (LOGGER.isLoggable(Level.FINE)) {
            for (JApiClass jApiClass : classList) {
                LOGGER.fine(jApiClass.toString());
            }
        }
        this.checkBinaryCompatibility(classList);
        this.checkJavaObjectSerializationCompatibility(classList);
        OutputFilter.sortClassesAndMethods(classList);
        return classList;
    }

    private List<CtClass> applyFilter(JarArchiveComparatorOptions options, List<CtClass> ctClasses) {
        ArrayList<CtClass> newList = new ArrayList<CtClass>(ctClasses.size());
        for (CtClass ctClass : ctClasses) {
            if (!options.getFilters().includeClass(ctClass)) continue;
            newList.add(ctClass);
        }
        return newList;
    }

    private List<CtClass> createListOfCtClasses(List<File> archives, ClassPool classPool) {
        LinkedList<CtClass> classes = new LinkedList<CtClass>();
        for (File archive : archives) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Loading classes from jar file '" + archive.getAbsolutePath() + "'");
            }
            try {
                JarFile jarFile = new JarFile(archive);
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> entryEnumeration = jarFile.entries();
                    while (entryEnumeration.hasMoreElements()) {
                        JarEntry jarEntry = entryEnumeration.nextElement();
                        String name = jarEntry.getName();
                        if (name.endsWith(".class")) {
                            CtClass ctClass;
                            try {
                                ctClass = classPool.makeClass(jarFile.getInputStream(jarEntry));
                            }
                            catch (Exception e) {
                                throw new JApiCmpException(JApiCmpException.Reason.IoException, String.format("Failed to load file from jar '%s' as class file: %s.", name, e.getMessage()), e);
                            }
                            classes.add(ctClass);
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine(String.format("Adding class '%s' with jar name '%s' to list.", ctClass.getName(), name));
                            }
                            if (!name.endsWith("package-info.class")) continue;
                            this.updatePackageFilter(ctClass);
                            continue;
                        }
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine(String.format("Skipping file '%s' because filename does not end with '.class'.", name));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            catch (IOException e) {
                throw new JApiCmpException(JApiCmpException.Reason.IoException, String.format("Processing of jar file %s failed: %s", archive.getAbsolutePath(), e.getMessage()), e);
            }
        }
        return classes;
    }

    private void updatePackageFilter(CtClass ctClass) {
        String className;
        Filters filters = this.options.getFilters();
        LinkedList<JavadocLikePackageFilter> newFilters = new LinkedList<JavadocLikePackageFilter>();
        for (Filter filter : filters.getIncludes()) {
            if (!(filter instanceof AnnotationFilterBase)) continue;
            className = ((AnnotationFilterBase)((Object)filter)).getClassName();
            if (!AnnotationHelper.hasAnnotation(ctClass.getClassFile(), className)) continue;
            newFilters.add(new JavadocLikePackageFilter(ctClass.getPackageName(), false));
        }
        if (newFilters.size() > 0) {
            filters.getIncludes().addAll(newFilters);
            newFilters.clear();
        }
        for (Filter filter : filters.getExcludes()) {
            if (!(filter instanceof AnnotationFilterBase)) continue;
            className = ((AnnotationFilterBase)((Object)filter)).getClassName();
            if (!AnnotationHelper.hasAnnotation(ctClass.getClassFile(), className)) continue;
            newFilters.add(new JavadocLikePackageFilter(ctClass.getPackageName(), false));
        }
        if (newFilters.size() > 0) {
            filters.getExcludes().addAll(newFilters);
            newFilters.clear();
        }
    }

    public JarArchiveComparatorOptions getJarArchiveComparatorOptions() {
        return this.options;
    }

    public ClassPool getCommonClassPool() {
        return this.commonClassPool;
    }

    public ClassPool getOldClassPool() {
        return this.oldClassPool;
    }

    public ClassPool getNewClassPool() {
        return this.newClassPool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<CtClass> loadClass(ArchiveType archiveType, String name) {
        Optional<CtClass> loadedClass = Optional.absent();
        if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH) {
            try {
                return Optional.of(this.commonClassPool.get(name));
            }
            catch (NotFoundException e) {
                if (this.options.getIgnoreMissingClasses().ignoreClass(e.getMessage())) return loadedClass;
                throw JApiCmpException.forClassLoading((Exception)((Object)e), name, this);
            }
        }
        if (this.options.getClassPathMode() != JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS) throw new JApiCmpException(JApiCmpException.Reason.IllegalState, "Unknown classpath mode: " + (Object)((Object)this.options.getClassPathMode()));
        if (archiveType == ArchiveType.OLD) {
            try {
                return Optional.of(this.oldClassPool.get(name));
            }
            catch (NotFoundException e) {
                if (this.options.getIgnoreMissingClasses().ignoreClass(e.getMessage())) return loadedClass;
                throw JApiCmpException.forClassLoading((Exception)((Object)e), name, this);
            }
        }
        if (archiveType != ArchiveType.NEW) throw new JApiCmpException(JApiCmpException.Reason.IllegalState, "Unknown archive type: " + (Object)((Object)archiveType));
        try {
            return Optional.of(this.newClassPool.get(name));
        }
        catch (NotFoundException e) {
            if (this.options.getIgnoreMissingClasses().ignoreClass(e.getMessage())) return loadedClass;
            throw JApiCmpException.forClassLoading((Exception)((Object)e), name, this);
        }
    }

    public static enum ArchiveType {
        OLD,
        NEW;

    }
}

